<?php
// admin/modules/tags/edit.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Tag";

$tag_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($tag_id_to_edit <= 0) {
    set_flash_message('danger', 'ID Tag tidak valid.');
    header('Location: index.php');
    exit;
}

$tag_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_tags WHERE id = :id");
        $stmt->bindParam(':id', $tag_id_to_edit, PDO::PARAM_INT);
        $stmt->execute();
        $tag_db_data = $stmt->fetch();
    } catch (\PDOException $e) {
        error_log("Error fetching tag for edit: " . $e->getMessage());
        set_flash_message('danger', 'Gagal mengambil data tag: ' . $e->getMessage());
        header('Location: index.php');
        exit;
    }
}

if (!$tag_db_data) {
    set_flash_message('danger', 'Tag tidak ditemukan.');
    header('Location: index.php');
    exit;
}

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'name' => $tag_db_data['name'],
    'slug' => $tag_db_data['slug']
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Tag', 'url' => 'index.php'],
        'Edit Tag: ' . esc_html($tag_db_data['name'])
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header">
           <i class="fas fa-edit me-1"></i> Formulir Edit Tag: <?php echo esc_html($tag_db_data['name']); ?>
        </div>
        <div class="card-body">
            <form action="process_tag.php" method="POST" id="tagForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $tag_db_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Tag <span class="text-danger">*</span></label>
                    <input type="text" class="form-control <?php echo isset($form_errors['name']) ? 'is-invalid' : ''; ?>" id="name" name="name" value="<?php echo old_form_data('name', $tag_db_data['name'], $form_data); ?>" required>
                    <?php echo get_form_error('name', $form_errors); ?>
                </div>

                <div class="mb-3">
                    <label for="slug" class="form-label">Slug (URL Friendly)</label>
                    <input type="text" class="form-control <?php echo isset($form_errors['slug']) ? 'is-invalid' : ''; ?>" id="slug" name="slug" value="<?php echo old_form_data('slug', $tag_db_data['slug'], $form_data); ?>" placeholder="Otomatis digenerate jika kosong">
                    <div class="form-text">Hanya huruf kecil, angka, dan tanda hubung (-).</div>
                    <?php echo get_form_error('slug', $form_errors); ?>
                </div>
                
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveTagButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
// Skrip AJAX dan slug generator sama seperti di create.php
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('name', 'slug');
    }

    $('#tagForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveTagButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    // Untuk edit, biasanya redirect atau update field jika ada data baru dikembalikan
                    if (response.redirect_url) {
                         setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan tag.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message;}
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>