<?php
// admin/modules/pages/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Halaman Statis";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$pages = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT p.id, p.title, p.slug, p.status, p.updated_at, u.full_name as author_name
                             FROM portal_pages p
                             LEFT JOIN portal_users u ON p.author_id = u.id
                             ORDER BY p.title ASC");
        $pages = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data halaman: ' . $e->getMessage());
        error_log("Error fetching static pages: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Halaman Statis'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Halaman Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-file-alt me-1"></i>
            Daftar Halaman Statis
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTablePages" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Judul Halaman</th>
                            <th>Slug</th>
                            <th>Penulis</th>
                            <th>Status</th>
                            <th>Terakhir Diperbarui</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($pages) > 0): ?>
                            <?php foreach ($pages as $index => $page_item): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <?php echo esc_html($page_item['title']); ?>
                                </td>
                                <td><?php echo esc_html($page_item['slug']); ?></td>
                                <td><?php echo esc_html($page_item['author_name'] ?? 'N/A'); ?></td>
                                <td class="text-center">
                                    <?php
                                    $status_class = 'secondary';
                                    $status_text = ucfirst(esc_html($page_item['status']));
                                    if ($page_item['status'] == 'published') {
                                        $status_class = 'success';
                                    } elseif ($page_item['status'] == 'draft') {
                                        $status_class = 'warning text-dark';
                                    } elseif ($page_item['status'] == 'pending') {
                                        $status_class = 'info text-dark';
                                        $status_text = 'Pending Review';
                                    }
                                    ?>
                                    <span class="badge bg-<?php echo $status_class; ?>">
                                        <?php echo $status_text; ?>
                                    </span>
                                </td>
                                <td><?php echo date('d M Y, H:i', strtotime($page_item['updated_at'])); ?></td>
                                <td class="text-center">
                                    <a href="<?php echo resolve_url('page.php?slug=' . esc_html($page_item['slug'])); ?>" target="_blank" class="btn btn-sm btn-outline-info mb-1" title="Lihat Halaman Publik"><i class="fas fa-eye"></i></a>
                                    <a href="edit.php?id=<?php echo $page_item['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-page"
                                            data-id="<?php echo $page_item['id']; ?>"
                                            data-title="<?php echo esc_html(addslashes($page_item['title'])); ?>"
                                            data-url="process_page.php?action=delete&id=<?php echo $page_item['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">Belum ada halaman statis.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTablePages').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 1, \"asc\" ]] // Order by Judul Halaman ascending
        });

        // AJAX Delete untuk Halaman Statis
        $('#dataTablePages').on('click', '.btn-delete-page', function() {
            const button = $(this);
            const pageTitle = button.data('title');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus halaman: ' + pageTitle + '? Aksi ini tidak dapat dibatalkan.')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus halaman.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus halaman.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>