<?php
// admin/modules/study_programs/edit.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$sp_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($sp_id <= 0) {
    set_flash_message('danger', 'ID Program Studi tidak valid.');
    header('Location: index.php');
    exit;
}

$study_program = null;
$faculties = [];

if (isset($pdo)) {
    try {
        // Ambil data program studi yang akan diedit
        $stmt_sp = $pdo->prepare("SELECT * FROM portal_study_programs WHERE id = :id");
        $stmt_sp->execute([':id' => $sp_id]);
        $study_program = $stmt_sp->fetch(PDO::FETCH_ASSOC);

        if (!$study_program) {
            set_flash_message('danger', 'Program Studi tidak ditemukan.');
            header('Location: index.php');
            exit;
        }

        // Ambil semua fakultas untuk dropdown
        $stmt_faculties = $pdo->query("SELECT id, name FROM portal_faculties ORDER BY name ASC");
        $faculties = $stmt_faculties->fetchAll(PDO::FETCH_ASSOC);

    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data: ' . $e->getMessage());
        error_log("Error fetching study program for edit: " . $e->getMessage());
        header('Location: index.php');
        exit;
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
    header('Location: index.php');
    exit;
}

// Ambil data form lama jika ada error validasi
$form_data = $_SESSION['form_data'] ?? $study_program;
$form_errors = $_SESSION['form_errors'] ?? [];
unset($_SESSION['form_data'], $_SESSION['form_errors']);

$module_base_path = '../../';
$page_title = "Edit Program Studi";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Program Studi', 'url' => 'index.php'],
        'Edit Program Studi'
    ]); ?>

    <h1 class="mt-4 mb-4">Edit Program Studi</h1>

    <?php echo display_flash_message(); ?>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-edit me-1"></i>
            Formulir Edit Program Studi
        </div>
        <div class="card-body">
            <form action="process_study_program.php" method="POST" enctype="multipart/form-data" id="editStudyProgramForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $sp_id; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="row">
                    <div class="col-lg-8">
                        <div class="mb-3">
                            <label for="name" class="form-label">Nama Program Studi <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php echo isset($form_errors['name']) ? 'is-invalid' : ''; ?>" id="name" name="name" value="<?php echo esc_html($form_data['name'] ?? ''); ?>" required>
                            <?php if (isset($form_errors['name'])): ?><div class="invalid-feedback"><?php echo $form_errors['name']; ?></div><?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label for="description_html" class="form-label">Deskripsi Program Studi</label>
                            <textarea class="form-control tinymce-editor" id="description_html" name="description_html" rows="10"><?php echo esc_html($form_data['description_html'] ?? ''); ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="vision_html" class="form-label">Visi</label>
                            <textarea class="form-control tinymce-editor-simple" id="vision_html" name="vision_html" rows="5"><?php echo esc_html($form_data['vision_html'] ?? ''); ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="mission_html" class="form-label">Misi</label>
                            <textarea class="form-control tinymce-editor-simple" id="mission_html" name="mission_html" rows="7"><?php echo esc_html($form_data['mission_html'] ?? ''); ?></textarea>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <div class="card card-body shadow-sm mb-4">
                             <div class="mb-3">
                                <label for="faculty_id" class="form-label">Fakultas</label>
                                <select class="form-select <?php echo isset($form_errors['faculty_id']) ? 'is-invalid' : ''; ?>" id="faculty_id" name="faculty_id">
                                    <option value="">-- Pilih Fakultas --</option>
                                    <?php foreach ($faculties as $faculty): ?>
                                        <option value="<?php echo $faculty['id']; ?>" <?php echo (isset($form_data['faculty_id']) && $form_data['faculty_id'] == $faculty['id']) ? 'selected' : ''; ?>>
                                            <?php echo esc_html($faculty['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <?php if (isset($form_errors['faculty_id'])): ?><div class="invalid-feedback"><?php echo $form_errors['faculty_id']; ?></div><?php endif; ?>
                            </div>

                             <div class="mb-3">
                                <label for="slug" class="form-label">Slug</label>
                                <input type="text" class="form-control <?php echo isset($form_errors['slug']) ? 'is-invalid' : ''; ?>" id="slug" name="slug" value="<?php echo esc_html($form_data['slug'] ?? ''); ?>" placeholder="Akan dibuat otomatis jika kosong">
                                <?php if (isset($form_errors['slug'])): ?><div class="invalid-feedback"><?php echo $form_errors['slug']; ?></div><?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label for="is_active" class="form-label">Status</label>
                                <select class="form-select" id="is_active" name="is_active">
                                    <option value="1" <?php echo (isset($form_data['is_active']) && $form_data['is_active'] == 1) ? 'selected' : ''; ?>>Aktif</option>
                                    <option value="0" <?php echo (isset($form_data['is_active']) && $form_data['is_active'] == 0) ? 'selected' : ''; ?>>Tidak Aktif</option>
                                </select>
                            </div>

                             <div class="mb-3">
                                <label for="program_order" class="form-label">Urutan Tampil</label>
                                <input type="number" class="form-control <?php echo isset($form_errors['program_order']) ? 'is-invalid' : ''; ?>" id="program_order" name="program_order" value="<?php echo esc_html($form_data['program_order'] ?? '0'); ?>">
                                <?php if (isset($form_errors['program_order'])): ?><div class="invalid-feedback"><?php echo $form_errors['program_order']; ?></div><?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="card card-body shadow-sm mb-4">
                            <h5 class="card-title h6">Informasi Detail</h5>
                            
                            <div class="mb-3">
                                <label for="degree" class="form-label">Jenjang Pendidikan</label>
                                <input type="text" class="form-control" id="degree" name="degree" value="<?php echo esc_html($form_data['degree'] ?? ''); ?>" placeholder="Contoh: S1, D3">
                            </div>

                            <div class="mb-3">
                                <label for="head_of_program_name" class="form-label">Nama Ketua Prodi</label>
                                <input type="text" class="form-control" id="head_of_program_name" name="head_of_program_name" value="<?php echo esc_html($form_data['head_of_program_name'] ?? ''); ?>">
                            </div>
                            
                            <div class="mb-3">
                                <label for="website_url" class="form-label">URL Website Prodi</label>
                                <input type="url" class="form-control <?php echo isset($form_errors['website_url']) ? 'is-invalid' : ''; ?>" id="website_url" name="website_url" value="<?php echo esc_html($form_data['website_url'] ?? ''); ?>" placeholder="https://prodi.contoh.com">
                                <?php if (isset($form_errors['website_url'])): ?><div class="invalid-feedback"><?php echo $form_errors['website_url']; ?></div><?php endif; ?>
                            </div>
                        </div>

                        <div class="card card-body shadow-sm mb-4">
                            <h5 class="card-title h6">Akreditasi</h5>
                             <div class="mb-3">
                                <label for="accreditation_status" class="form-label">Status Akreditasi</label>
                                <input type="text" class="form-control" id="accreditation_status" name="accreditation_status" value="<?php echo esc_html($form_data['accreditation_status'] ?? ''); ?>" placeholder="Contoh: Baik Sekali, Unggul">
                            </div>
                             <div class="mb-3">
                                <label for="accreditation_number" class="form-label">Nomor SK Akreditasi</label>
                                <input type="text" class="form-control" id="accreditation_number" name="accreditation_number" value="<?php echo esc_html($form_data['accreditation_number'] ?? ''); ?>">
                            </div>
                             <div class="mb-3">
                                <label for="accreditation_expiry_date" class="form-label">Tanggal Kadaluarsa</label>
                                <input type="date" class="form-control <?php echo isset($form_errors['accreditation_expiry_date']) ? 'is-invalid' : ''; ?>" id="accreditation_expiry_date" name="accreditation_expiry_date" value="<?php echo esc_html($form_data['accreditation_expiry_date'] ?? ''); ?>">
                                <?php if (isset($form_errors['accreditation_expiry_date'])): ?><div class="invalid-feedback"><?php echo $form_errors['accreditation_expiry_date']; ?></div><?php endif; ?>
                            </div>
                        </div>
                        
                        <div class="card card-body shadow-sm">
                            <h5 class="card-title h6">File Terkait</h5>

                            <div class="mb-3">
                                <label for="logo_file" class="form-label">Logo Prodi</label>
                                <input type="file" class="form-control" id="logo_file" name="logo_file" accept="image/jpeg,image/png,image/gif,image/svg+xml">
                                <small class="text-muted">Kosongkan jika tidak ingin mengubah logo.</small>
                                <?php if (!empty($study_program['logo_url'])): ?>
                                <div class="mt-2">
                                    <img src="<?php echo resolve_url($study_program['logo_url']); ?>" alt="Logo saat ini" style="max-height: 80px;" class="img-thumbnail">
                                    <input type="hidden" name="old_logo_url" value="<?php echo esc_html($study_program['logo_url']); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mb-3">
                                <label for="brochure_file" class="form-label">Brosur (PDF)</label>
                                <input type="file" class="form-control" id="brochure_file" name="brochure_file" accept="application/pdf">
                                <small class="text-muted">Kosongkan jika tidak ingin mengubah brosur.</small>
                                <?php if (!empty($study_program['brochure_url'])): ?>
                                <div class="mt-2">
                                    <a href="<?php echo resolve_url($study_program['brochure_url']); ?>" target="_blank">Lihat Brosur Saat Ini</a>
                                    <input type="hidden" name="old_brochure_url" value="<?php echo esc_html($study_program['brochure_url']); ?>">
                                </div>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label for="accreditation_certificate_file" class="form-label">Sertifikat Akreditasi (PDF/JPG/PNG)</label>
                                <input type="file" class="form-control" id="accreditation_certificate_file" name="accreditation_certificate_file" accept="application/pdf,image/jpeg,image/png">
                                <small class="text-muted">Kosongkan jika tidak ingin mengubah sertifikat.</small>
                                <?php if (!empty($study_program['accreditation_certificate_url'])): ?>
                                <div class="mt-2">
                                    <a href="<?php echo resolve_url($study_program['accreditation_certificate_url']); ?>" target="_blank">Lihat Sertifikat Saat Ini</a>
                                    <input type="hidden" name="old_accreditation_certificate_url" value="<?php echo esc_html($study_program['accreditation_certificate_url']); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <hr class="my-4">
                <div class="d-flex justify-content-end">
                    <a href="index.php" class="btn btn-secondary me-2">Batal</a>
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
// Memasukkan skrip untuk editor TinyMCE
$page_scripts[] = '<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>';
$page_scripts[] = '<script src="' . $module_base_path . 'assets/js/tinymce-configs.js"></script>';

require_once $project_root . '/admin/includes/footer.php';
?>