<?php
// admin/modules/sliders/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Slider";
$slider_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($slider_id_to_edit <= 0) { set_flash_message('danger', 'ID Slider tidak valid.'); header('Location: index.php'); exit;}
$slider_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_sliders WHERE id = :id");
        $stmt->execute([':id' => $slider_id_to_edit]);
        $slider_db_data = $stmt->fetch();
    } catch (\PDOException $e) { /* ... error handling ... */ }
}
if (!$slider_db_data) { set_flash_message('danger', 'Slider tidak ditemukan.'); header('Location: index.php'); exit; }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => $slider_db_data['title'], 'description' => $slider_db_data['description'],
    'image_url_desktop' => $slider_db_data['image_url_desktop'], 'image_url_mobile' => $slider_db_data['image_url_mobile'],
    'link_url' => $slider_db_data['link_url'], 'button_text' => $slider_db_data['button_text'],
    'slide_order' => $slider_db_data['slide_order'], 'is_active' => $slider_db_data['is_active'],
    'start_date' => $slider_db_data['start_date'] ? date('Y-m-d\TH:i', strtotime($slider_db_data['start_date'])) : '',
    'end_date' => $slider_db_data['end_date'] ? date('Y-m-d\TH:i', strtotime($slider_db_data['end_date'])) : '',
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($slider_db_data['title']);?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_slider.php" method="POST" enctype="multipart/form-data" id="sliderForm">
        <input type="hidden" name="action" value="edit">
        <input type="hidden" name="id" value="<?php echo $slider_db_data['id']; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
        <input type="hidden" name="old_image_url_desktop" value="<?php echo esc_html($slider_db_data['image_url_desktop'] ?? ''); ?>">
        <input type="hidden" name="old_image_url_mobile" value="<?php echo esc_html($slider_db_data['image_url_mobile'] ?? ''); ?>">

        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-info-circle me-1"></i> Informasi Dasar Slider</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="title" class="form-label">Judul Slider <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', $slider_db_data['title'], $form_data); ?>" required>
                     <?php echo get_form_error('title', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi Singkat (Opsional)</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo old_form_data('description', $slider_db_data['description'], $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
            </div>
        </div>

        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-image me-1"></i> Gambar Slider</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="image_file_desktop" class="form-label">Gambar Desktop <?php echo empty($form_data['image_url_desktop']) ? '<span class="text-danger">*</span>' : '(Opsional jika tidak diubah)'; ?></label>
                        <img id="imagePreviewDesktop" 
                             src="<?php echo !empty($form_data['image_url_desktop']) ? resolve_url(esc_html($form_data['image_url_desktop'])) : '#'; ?>" 
                             alt="Preview Desktop" class="img-thumbnail mb-2" 
                             style="max-height: 100px; <?php echo empty($form_data['image_url_desktop']) ? 'display: none;' : ''; ?>"
                             data-default-src="<?php echo !empty($form_data['image_url_desktop']) ? resolve_url(esc_html($form_data['image_url_desktop'])) : '#'; ?>">
                        <input type="file" class="form-control" id="image_file_desktop" name="image_file_desktop" accept="image/*" <?php echo empty($form_data['image_url_desktop']) ? 'required' : ''; ?>>
                        <div class="form-text">Upload baru untuk mengganti. Rekomendasi: 1920x700px. Maks 2MB.</div>
                        <?php echo get_form_error('image_url_desktop', $form_errors); ?>
                    </div>
                    <!--<div class="col-md-6 mb-3">-->
                    <!--    <label for="image_file_mobile" class="form-label">Gambar Mobile (Opsional)</label>-->
                    <!--    <img id="imagePreviewMobile" -->
                    <!--         src="<?php echo !empty($form_data['image_url_mobile']) ? resolve_url(esc_html($form_data['image_url_mobile'])) : '#'; ?>" -->
                    <!--         alt="Preview Mobile" class="img-thumbnail mb-2" -->
                    <!--         style="max-height: 100px; <?php echo empty($form_data['image_url_mobile']) ? 'display: none;' : ''; ?>"-->
                    <!--         data-default-src="<?php echo !empty($form_data['image_url_mobile']) ? resolve_url(esc_html($form_data['image_url_mobile'])) : '#'; ?>">-->
                    <!--    <input type="file" class="form-control" id="image_file_mobile" name="image_file_mobile" accept="image/*">-->
                    <!--    <div class="form-text">Upload baru untuk mengganti. Rekomendasi: 768x500px. Maks 1MB.</div>-->
                    <!--    <?php echo get_form_error('image_url_mobile', $form_errors); ?>-->
                    <!--</div>-->
                </div>
            </div>
        </div>
        
        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-link me-1"></i> Tautan & Tombol (Opsional)</div>
            <div class="card-body">
                 <div class="mb-3">
                    <label for="link_url" class="form-label">URL Tujuan Klik</label>
                    <input type="url" class="form-control" id="link_url" name="link_url" value="<?php echo old_form_data('link_url', $slider_db_data['link_url'], $form_data); ?>" placeholder="https://ugkmb.ac.id/halaman-tujuan">
                    <?php echo get_form_error('link_url', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="button_text" class="form-label">Teks Tombol</label>
                    <input type="text" class="form-control" id="button_text" name="button_text" value="<?php echo old_form_data('button_text', $slider_db_data['button_text'], $form_data); ?>" placeholder="Contoh: Selengkapnya">
                    <div class="form-text">Akan tampil jika URL Tujuan Klik diisi.</div>
                    <?php echo get_form_error('button_text', $form_errors); ?>
                </div>
            </div>
        </div>

        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-cog me-1"></i> Pengaturan & Penjadwalan</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="slide_order" class="form-label">Urutan Slide <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" id="slide_order" name="slide_order" value="<?php echo old_form_data('slide_order', $slider_db_data['slide_order'], $form_data); ?>" min="0" required>
                        <?php echo get_form_error('slide_order', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="is_active" class="form-label">Status Slider <span class="text-danger">*</span></label>
                        <select class="form-select" id="is_active" name="is_active" required>
                            <option value="1" <?php echo (old_form_data('is_active', $slider_db_data['is_active'], $form_data) == '1') ? 'selected' : ''; ?>>Aktif</option>
                            <option value="0" <?php echo (old_form_data('is_active', $slider_db_data['is_active'], $form_data) == '0') ? 'selected' : ''; ?>>Nonaktif</option>
                        </select>
                        <?php echo get_form_error('is_active', $form_errors); ?>
                    </div>
                </div>
                <h6 class="mt-3 mb-2 text-muted">Penjadwalan Tayang (Opsional)</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="start_date" class="form-label">Tanggal & Waktu Mulai Tayang</label>
                        <input type="datetime-local" class="form-control" id="start_date" name="start_date" value="<?php echo old_form_data('start_date', $slider_db_data['start_date'] ? date('Y-m-d\TH:i', strtotime($slider_db_data['start_date'])) : '', $form_data); ?>">
                        <?php echo get_form_error('start_date', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="end_date" class="form-label">Tanggal & Waktu Selesai Tayang</label>
                        <input type="datetime-local" class="form-control" id="end_date" name="end_date" value="<?php echo old_form_data('end_date', $slider_db_data['end_date'] ? date('Y-m-d\TH:i', strtotime($slider_db_data['end_date'])) : '', $form_data); ?>">
                        <?php echo get_form_error('end_date', $form_errors); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-3 mb-5">
            <button type="submit" class="btn btn-primary" id="saveSliderButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
            <a href="index.php" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
<?php
// Skrip AJAX dan image preview sama seperti di create.php untuk slider
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof initializeImagePreview === 'function') {
        initializeImagePreview('image_file_desktop', 'imagePreviewDesktop');
        initializeImagePreview('image_file_mobile', 'imagePreviewMobile');
    }
    // AJAX form submission (mirip dengan form create slider)
    $('#sliderForm').on('submit', function(e) { /* ... logika AJAX submit ... */
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveSliderButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        const formData = new FormData(this);

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    }
                    // Update UI jika ada data baru dari server, misal path gambar
                    if (response.updated_data) {
                        if(response.updated_data.image_url_desktop) {
                            $('#imagePreviewDesktop').attr('src', resolve_url_js(response.updated_data.image_url_desktop)).data('default-src', resolve_url_js(response.updated_data.image_url_desktop)).show();
                            $('input[name=\"old_image_url_desktop\"]').val(response.updated_data.image_url_desktop);
                        }
                        if(response.updated_data.image_url_mobile) {
                            $('#imagePreviewMobile').attr('src', resolve_url_js(response.updated_data.image_url_mobile)).data('default-src', resolve_url_js(response.updated_data.image_url_mobile)).show();
                            $('input[name=\"old_image_url_mobile\"]').val(response.updated_data.image_url_mobile);
                        }
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan slider.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });

    const BASE_URL_JS_HELPER_SLIDER = '" . (defined("BASE_URL") ? BASE_URL : "") . "';
    function resolve_url_js(path) { // Helper untuk JS jika dibutuhkan
        if (!BASE_URL_JS_HELPER_SLIDER) return path;
        return BASE_URL_JS_HELPER_SLIDER + '/' + path.replace(/^\\//, '');
    }
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>