<?php
// admin/modules/settings/process_settings.php
// ... (kode PHP awal seperti session_start, require, is_ajax, auth, pdo check) ...
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 3)); }
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

function is_ajax_request_settings() { /* ... */ return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'; }
$is_ajax = is_ajax_request_settings();
if ($is_ajax) { header('Content-Type: application/json'); }

// ... (Otorisasi admin) ...

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.'); header('Location: index.php'); exit;
    }

    $settings_input = $_POST['settings'] ?? [];
    $setting_files_input = $_FILES['setting_files'] ?? [];
    $upload_errors = [];
    $db_errors = []; // Untuk error DB per field jika ada

    try {
        $pdo->beginTransaction();
        $stmt_update = $pdo->prepare("UPDATE portal_settings SET setting_value = :value, updated_at = NOW() WHERE setting_key = :key");
        $stmt_get_all = $pdo->query("SELECT setting_key, setting_value, input_type FROM portal_settings");
        $current_settings_map_raw = $stmt_get_all->fetchAll(PDO::FETCH_ASSOC);
        $current_settings_map = [];
        foreach($current_settings_map_raw as $s_item){
            $current_settings_map[$s_item['setting_key']] = $s_item;
        }


        foreach ($settings_input as $key => $value_from_form) {
            $current_setting_info = $current_settings_map[$key] ?? ['setting_value' => null, 'input_type' => 'text'];
            $old_db_value = $current_setting_info['setting_value'];
            $input_type = $current_setting_info['input_type'];
            $new_value_to_save = $value_from_form; // Nilai dari input teks/select/textarea

            // Handle file uploads
            if (($input_type === 'image_url' || $input_type === 'file_url')) {
                // Jika ada file baru diupload untuk key ini
                if (isset($setting_files_input['name'][$key]) && $setting_files_input['error'][$key] == UPLOAD_ERR_OK) {
                    $upload_dir_relative = 'uploads/settings/';
                    $upload_dir_absolute = $project_root . '/' . $upload_dir_relative;
                    $allowed_mimes = ($input_type === 'image_url')
                        ? ['image/jpeg', 'image/png', 'image/gif', 'image/svg+xml', 'image/webp', 'image/x-icon']
                        : ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'text/plain', 'application/zip'];

                    $upload_result = upload_file(
                        [
                            'name' => $setting_files_input['name'][$key], 'type' => $setting_files_input['type'][$key],
                            'tmp_name' => $setting_files_input['tmp_name'][$key], 'error' => $setting_files_input['error'][$key],
                            'size' => $setting_files_input['size'][$key]
                        ],
                        $upload_dir_absolute, $allowed_mimes, 5 * 1024 * 1024
                    );

                    if ($upload_result['success']) {
                        if (!empty($old_db_value) && file_exists($project_root . '/' . $old_db_value)) {
                            @unlink($project_root . '/' . $old_db_value);
                        }
                        $new_value_to_save = $upload_result['filepath_relative'];
                    } else {
                        $upload_errors[] = "File untuk '" . esc_html(ucwords(str_replace('_', ' ', $key))) . "': " . $upload_result['message'];
                        // Jika upload gagal, JANGAN ubah $new_value_to_save, biarkan $value_from_form (path lama dari hidden input)
                        // $new_value_to_save tetap $value_from_form (yaitu path lama dari hidden input)
                    }
                } elseif (empty($value_from_form) && !empty($old_db_value)) {
                    // Jika value dari hidden input (path lama) dikosongkan oleh JS (tombol hapus)
                    if (file_exists($project_root . '/' . $old_db_value)) {
                        @unlink($project_root . '/' . $old_db_value);
                    }
                    $new_value_to_save = null; // Hapus path dari DB
                }
                // Jika tidak ada file baru dan value_from_form (path lama) masih ada, $new_value_to_save tetap path lama.
            }

            if ($input_type === 'boolean') {
                $new_value_to_save = ($new_value_to_save == '1' || strtolower((string)$new_value_to_save) === 'true') ? '1' : '0';
            }
            
            // Hanya update jika nilainya berubah dari yang ada di DB (atau jika ini file upload)
            // Untuk file, $new_value_to_save akan berbeda jika ada upload baru atau penghapusan.
            // Jika tidak ada upload baru dan path lama sama, $new_value_to_save akan sama dengan $old_db_value dari sisi path.
            $should_update_db = false;
            if ($input_type === 'image_url' || $input_type === 'file_url') {
                // Selalu update field file jika ada interaksi (upload baru, penghapusan, atau bahkan jika path lama di-submit ulang)
                // karena $new_value_to_save sudah di-set dengan benar.
                // Pengecualian: jika tidak ada file baru diupload DAN path lama dari form SAMA dengan path lama di DB, tidak perlu update.
                if (!( !isset($setting_files_input['name'][$key]) && $value_from_form === $old_db_value )) {
                    $should_update_db = true;
                }
            } else {
                if ($new_value_to_save !== $old_db_value) {
                    $should_update_db = true;
                }
            }

            if($should_update_db) {
                if (!$stmt_update->execute([':value' => $new_value_to_save, ':key' => $key])) {
                    $db_errors[$key] = "Gagal update database untuk " . $key;
                }
            }
        }

        if (!empty($db_errors)) {
            $pdo->rollBack();
            if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Beberapa pengaturan gagal disimpan ke database.', 'errors' => $db_errors, 'upload_errors' => $upload_errors]); }
            else { set_flash_message('danger', 'Beberapa pengaturan gagal disimpan ke database.'); header('Location: index.php'); }
            exit;
        }

        $pdo->commit();

        $final_message = 'Pengaturan berhasil diperbarui.';
        $response_data = ['success' => true, 'message' => $final_message];
        if (!empty($upload_errors)) {
            $response_data['message'] .= ' Namun, terjadi beberapa kesalahan saat unggah file.';
            $response_data['upload_errors'] = $upload_errors; // Kirim detail error upload ke client
        }

        if ($is_ajax) { echo json_encode($response_data); }
        else {
            $flash_type = empty($upload_errors) ? 'success' : 'warning';
            set_flash_message($flash_type, $response_data['message'] . (empty($upload_errors) ? '' : '<br>' . implode('<br>', $upload_errors)) );
            header('Location: index.php');
        }
        exit;

    } catch (\PDOException $e) {
        if ($pdo->inTransaction()) $pdo->rollBack();
        error_log("Settings update error (DB): " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan database.', 'upload_errors' => $upload_errors]); }
        else { set_flash_message('danger', 'Terjadi kesalahan database saat memperbarui pengaturan.'); header('Location: index.php');}
        exit;
    } catch (Exception $e) { // Catch other general exceptions
        if ($pdo->inTransaction()) $pdo->rollBack();
        error_log("Settings update error (General): " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan umum.', 'upload_errors' => $upload_errors]); }
        else { set_flash_message('danger', 'Terjadi kesalahan umum saat memperbarui pengaturan.'); header('Location: index.php'); }
        exit;
    }
} else {
    if ($is_ajax) { http_response_code(405); echo json_encode(['success' => false, 'message' => 'Permintaan tidak valid.']); }
    else { set_flash_message('danger', 'Permintaan tidak valid.'); header('Location: index.php'); }
    exit;
}
?>