<?php
// admin/modules/pages/process_page.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3));
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

function is_ajax_request_page() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}
$is_ajax = is_ajax_request_page();
if ($is_ajax) {
    header('Content-Type: application/json');
}

$module_redirect_url_base = 'index.php';

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Akses ditolak.']); exit; }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk aksi ini.'); header('Location: ../../login.php'); exit;
}
if (!isset($pdo)) {
    if ($is_ajax) { http_response_code(503); echo json_encode(['success' => false, 'message' => 'Koneksi database gagal.']); exit; }
    set_flash_message('danger', 'Koneksi database gagal.'); header('Location: ' . $module_redirect_url_base); exit;
}

// --- Validation Function ---
function validate_page_input($data, $is_edit = false, $page_id_to_edit = null, $pdo_conn = null) {
    $errors = [];
    if (empty($data['title'])) { $errors['title'] = 'Judul halaman wajib diisi.'; }
    elseif (strlen($data['title']) > 255) { $errors['title'] = 'Judul halaman maksimal 255 karakter.';}
    if (empty($data['content_html'])) { $errors['content_html'] = 'Isi halaman wajib diisi.';}
    if (!empty($data['slug'])) {
        if (!preg_match('/^[a-z0-9]+(?:-[a-z0-9-]+)*[a-z0-9]+$/', $data['slug']) && $data['slug'] !== '/') { $errors['slug'] = 'Slug hanya boleh berisi huruf kecil, angka, dan tanda hubung (-), tidak boleh diawali/diakhiri hubung.';}
        elseif (strlen($data['slug']) > 255) { $errors['slug'] = 'Slug maksimal 255 karakter.';}
        else {
            $sql_check_slug = "SELECT id FROM portal_pages WHERE slug = :slug";
            $params_check_slug = [':slug' => $data['slug']];
            if ($is_edit && $page_id_to_edit) { $sql_check_slug .= " AND id != :id"; $params_check_slug[':id'] = $page_id_to_edit;}
            $stmt_check_slug = $pdo_conn->prepare($sql_check_slug); $stmt_check_slug->execute($params_check_slug);
            if ($stmt_check_slug->fetch()) { $errors['slug'] = 'Slug "' . esc_html($data['slug']) . '" sudah digunakan.';}
        }
    } elseif ($is_edit && empty($data['slug'])) { $errors['slug'] = 'Slug wajib diisi saat edit jika dikosongkan.';}
    if (!in_array($data['status'], ['draft', 'published', 'pending'])) { $errors['status'] = 'Status tidak valid.';}
    if (!empty($data['published_at'])) { try { new DateTime($data['published_at']);} catch (Exception $e) { $errors['published_at'] = 'Format tanggal publikasi tidak valid.';}}
    if (!empty($data['template']) && !preg_match('/^[a-zA-Z0-9_-]+\.php$/', $data['template'])) { $errors['template'] = 'Format nama file template tidak valid (contoh: nama-template.php).';}
    if (!isset($data['page_order']) || !is_numeric($data['page_order'])) { $errors['page_order'] = 'Urutan halaman harus berupa angka.';}
    return $errors;
}


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.');
        $action_redirect = $_POST['action'] ?? 'create'; $id_redirect = $_POST['id'] ?? null;
        header('Location: ' . ($action_redirect === 'edit' && $id_redirect ? 'edit.php?id=' . $id_redirect : 'create.php')); exit;
    }

    $action = $_POST['action'] ?? null;
    $page_id = isset($_POST['id']) ? (int)$_POST['id'] : null;
    $redirect_on_error_url = ($action === 'edit' && $page_id ? 'edit.php?id=' . $page_id : 'create.php');

    $form_data_input = [
        'title' => trim($_POST['title'] ?? ''), 'slug' => trim($_POST['slug'] ?? ''),
        'content_html' => $_POST['content_html'] ?? '', 'status' => $_POST['status'] ?? 'draft',
        'published_at' => !empty($_POST['published_at']) ? $_POST['published_at'] : null,
        'meta_keywords' => trim($_POST['meta_keywords'] ?? ''), 'meta_description' => trim($_POST['meta_description'] ?? ''),
        'template' => trim($_POST['template'] ?? ''), 'page_order' => isset($_POST['page_order']) ? (int)$_POST['page_order'] : 0,
        'author_id' => $_SESSION['user_id']
    ];

    if ($action === 'create' && empty($form_data_input['slug'])) {
        $form_data_input['slug'] = generate_slug($form_data_input['title']);
        if(empty($form_data_input['slug'])) $form_data_input['slug'] = 'halaman-' . time();
    }

    $errors = validate_page_input($form_data_input, ($action === 'edit'), $page_id, $pdo);

    if (!empty($errors)) {
        if ($is_ajax) { http_response_code(422); echo json_encode(['success' => false, 'message' => 'Validasi gagal.', 'errors' => $errors]); }
        else {
            $_SESSION['form_errors'] = $errors; $_SESSION['form_data'] = $form_data_input;
            set_flash_message('danger', 'Gagal menyimpan halaman.'); header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }
    
    $published_at_db = null;
    if ($form_data_input['status'] === 'published') {
        $published_at_db = !empty($form_data_input['published_at']) ? (new DateTime($form_data_input['published_at']))->format('Y-m-d H:i:s') : date('Y-m-d H:i:s');
    } elseif (!empty($form_data_input['published_at'])) {
        $published_at_db = (new DateTime($form_data_input['published_at']))->format('Y-m-d H:i:s');
    }

    try {
        $sql_params = [
            ':title' => $form_data_input['title'], ':slug' => $form_data_input['slug'],
            ':content_html' => $form_data_input['content_html'], ':author_id' => $form_data_input['author_id'],
            ':status' => $form_data_input['status'], ':published_at' => $published_at_db,
            ':meta_keywords' => $form_data_input['meta_keywords'], ':meta_description' => $form_data_input['meta_description'],
            ':template' => $form_data_input['template'], ':page_order' => $form_data_input['page_order'],
        ];
        if ($action === 'create') {
            $sql = "INSERT INTO portal_pages (title, slug, content_html, author_id, status, published_at, meta_keywords, meta_description, template, page_order, created_at, updated_at)
                    VALUES (:title, :slug, :content_html, :author_id, :status, :published_at, :meta_keywords, :meta_description, :template, :page_order, NOW(), NOW())";
            $stmt = $pdo->prepare($sql);
        } elseif ($action === 'edit' && $page_id) {
            $sql = "UPDATE portal_pages SET title = :title, slug = :slug, content_html = :content_html, author_id = :author_id, status = :status, published_at = :published_at, meta_keywords = :meta_keywords, meta_description = :meta_description, template = :template, page_order = :page_order, updated_at = NOW()
                    WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $sql_params[':id'] = $page_id;
        } else { throw new Exception("Aksi tidak valid."); }
        
        $stmt->execute($sql_params);

        if ($is_ajax) {
            echo json_encode(['success' => true, 'message' => 'Halaman berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.', 'redirect_url' => $module_redirect_url_base]);
        } else {
            set_flash_message('success', 'Halaman berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.');
            header('Location: ' . $module_redirect_url_base);
        }
        exit;
    } catch (PDOException | Exception $e) {
        error_log("Error processing page ($action): " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan server: ' . $e->getMessage()]); }
        else {
            set_flash_message('danger', 'Terjadi kesalahan server: ' . $e->getMessage());
            $_SESSION['form_data'] = $form_data_input;
            header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'delete') {
    if (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.'); header('Location: ' . $module_redirect_url_base); exit;
    }

    $page_id_to_delete = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    if ($page_id_to_delete <= 0) {
        if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'ID Halaman tidak valid.']); exit; }
        set_flash_message('danger', 'ID Halaman tidak valid.'); header('Location: ' . $module_redirect_url_base); exit;
    }

    try {
        $stmt_delete = $pdo->prepare("DELETE FROM portal_pages WHERE id = :id");
        $stmt_delete->execute([':id' => $page_id_to_delete]);

        if ($stmt_delete->rowCount() > 0) {
            if ($is_ajax) { echo json_encode(['success' => true, 'message' => 'Halaman berhasil dihapus.']); }
            else { set_flash_message('success', 'Halaman berhasil dihapus.'); header('Location: ' . $module_redirect_url_base); }
        } else {
            if ($is_ajax) { echo json_encode(['success' => false, 'message' => 'Halaman tidak ditemukan atau sudah dihapus.']); }
            else { set_flash_message('warning', 'Halaman tidak ditemukan atau sudah dihapus.'); header('Location: ' . $module_redirect_url_base); }
        }
    } catch (PDOException $e) {
        error_log("Error deleting page: " . $e->getMessage());
        if ($is_ajax) { http_response_code(500); echo json_encode(['success' => false, 'message' => 'Gagal menghapus halaman: Kesalahan database.']); }
        else { set_flash_message('danger', 'Gagal menghapus halaman karena kesalahan database.'); header('Location: ' . $module_redirect_url_base); }
    }
    exit;
} else {
    if ($is_ajax) { http_response_code(400); echo json_encode(['success' => false, 'message' => 'Permintaan tidak valid.']); }
    else { set_flash_message('danger', 'Permintaan tidak valid.'); header('Location: ' . $module_redirect_url_base); }
    exit;
}
?>