<?php
// admin/modules/menus/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Grup Menu";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$menu_groups = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT m.id, m.name, m.location, m.description, COUNT(mi.id) as item_count
                             FROM portal_menus m
                             LEFT JOIN portal_menu_items mi ON m.id = mi.menu_id
                             GROUP BY m.id, m.name, m.location, m.description
                             ORDER BY m.name ASC");
        $menu_groups = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data grup menu: ' . $e->getMessage());
        error_log("Error fetching menu groups: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Grup Menu'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create_edit_menu.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Grup Menu Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-list-alt me-1"></i>
            Daftar Grup Menu
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableMenuGroups" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Grup Menu</th>
                            <th>Lokasi (Kunci Tema)</th>
                            <th>Deskripsi</th>
                            <th>Jumlah Item</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($menu_groups) > 0): ?>
                            <?php foreach ($menu_groups as $index => $group): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <a href="manage_menu_items.php?menu_id=<?php echo $group['id']; ?>" title="Kelola item untuk <?php echo esc_html($group['name']); ?>">
                                        <?php echo esc_html($group['name']); ?>
                                    </a>
                                </td>
                                <td><code><?php echo esc_html($group['location']); ?></code></td>
                                <td><?php echo esc_html($group['description'] ?? '-'); ?></td>
                                <td class="text-center"><?php echo esc_html($group['item_count']); ?></td>
                                <td class="text-center">
                                    <a href="manage_menu_items.php?menu_id=<?php echo $group['id']; ?>" class="btn btn-sm btn-info mb-1" title="Kelola Item Menu">
                                        <i class="fas fa-list-ul"></i>
                                    </a>
                                    <a href="create_edit_menu.php?id=<?php echo $group['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit Grup Menu">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-menu-group"
                                            data-id="<?php echo $group['id']; ?>"
                                            data-name="<?php echo esc_html(addslashes($group['name'])); ?>"
                                            data-url="process_menu_group.php?action=delete_menu_group&id=<?php echo $group['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus Grup Menu">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">Belum ada grup menu.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableMenuGroups').DataTable({
            responsive: true,
            language: { 
                search: \"Cari:\",
                lengthMenu: \"Tampilkan _MENU_ entri\",
                info: \"Menampilkan _START_ sampai _END_ dari _TOTAL_ entri\",
                infoEmpty: \"Tidak ada data untuk ditampilkan\",
                infoFiltered: \"(disaring dari _MAX_ total entri)\",
                paginate: {
                    first: \"Pertama\",
                    last: \"Terakhir\",
                    next: \"Berikutnya\",
                    previous: \"Sebelumnya\"
                },
                zeroRecords: \"Tidak ada data yang cocok ditemukan\",
                emptyTable: \"Tidak ada grup menu tersedia di tabel\"
            }
        });

        // AJAX Delete untuk Grup Menu
        $('#dataTableMenuGroups').on('click', '.btn-delete-menu-group', function() {
            const button = $(this);
            const groupName = button.data('name');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus grup menu: ' + groupName + '? SEMUA item menu di dalamnya juga akan terhapus secara permanen.')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET', // process_menu_group.php sudah handle GET untuk delete
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus grup menu.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function(jqXHR) {
                        let errorMsg = 'Kesalahan server saat menghapus grup menu.';
                        if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                            errorMsg = jqXHR.responseJSON.message;
                        }
                        showAdminNotification('danger', errorMsg);
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>