<?php
// admin/modules/faculties/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Fakultas";
$faculty_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($faculty_id_to_edit <= 0) { /* ... handle error ... */ }
$faculty_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_faculties WHERE id = :id");
        $stmt->execute([':id' => $faculty_id_to_edit]);
        $faculty_db_data = $stmt->fetch();
    } catch (\PDOException $e) { /* ... error handling ... */ }
}
if (!$faculty_db_data) { /* ... handle not found ... */ }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'name' => $faculty_db_data['name'], 'slug' => $faculty_db_data['slug'],
    'description_html' => $faculty_db_data['description_html'], 'dean_name' => $faculty_db_data['dean_name'],
    'website_url' => $faculty_db_data['website_url'], 'faculty_order' => $faculty_db_data['faculty_order']
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($faculty_db_data['name']); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-edit me-1"></i> Formulir Edit Fakultas</div>
        <div class="card-body">
            <form action="process_faculty.php" method="POST" id="facultyForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo $faculty_db_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <!-- Form fields sama seperti create.php, value dari $faculty_db_data -->
                <div class="mb-3">
                    <label for="name" class="form-label">Nama Fakultas <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo old_form_data('name', $faculty_db_data['name'], $form_data); ?>" required>
                </div>
                <div class="mb-3">
                    <label for="slug" class="form-label">Slug</label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', $faculty_db_data['slug'], $form_data); ?>">
                </div>
                <div class="mb-3">
                    <label for="description_html" class="form-label">Deskripsi</label>
                    <textarea class="form-control" id="description_html" name="description_html" rows="5"><?php echo old_form_data('description_html', $faculty_db_data['description_html'], $form_data); ?></textarea>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3"><label for="dean_name" class="form-label">Nama Dekan</label><input type="text" class="form-control" id="dean_name" name="dean_name" value="<?php echo old_form_data('dean_name', $faculty_db_data['dean_name'], $form_data); ?>"></div>
                    <div class="col-md-6 mb-3"><label for="website_url" class="form-label">URL Website</label><input type="url" class="form-control" id="website_url" name="website_url" value="<?php echo old_form_data('website_url', $faculty_db_data['website_url'], $form_data); ?>"></div>
                </div>
                 <div class="mb-3">
                    <label for="faculty_order" class="form-label">Urutan <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="faculty_order" name="faculty_order" value="<?php echo old_form_data('faculty_order', $faculty_db_data['faculty_order'], $form_data); ?>" min="0" required>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveFacultyButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
// Skrip AJAX, TinyMCE, slug sama seperti di create.php untuk faculties
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js";
$page_scripts[] = "<script>
$(document).ready(function() {
    tinymce.init({ selector: 'textarea#description_html', /* ... konfig ... */ });
    if (typeof initializeSlugGenerator === 'function') { initializeSlugGenerator('name', 'slug'); }
    $('#facultyForm').on('submit', function(e) { /* ... AJAX submit logic ... */ });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>