<?php
// admin/modules/events/create.php - VERSI DENGAN PERBAIKAN AJAX REDIRECT
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$form_data = $_SESSION['form_data'] ?? [];
$form_errors = $_SESSION['form_errors'] ?? [];
unset($_SESSION['form_data'], $_SESSION['form_errors']);

$module_base_path = '../../';
$page_title = "Tambah Acara Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Acara', 'url' => 'index.php'],
        'Tambah Acara Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-plus-circle me-1"></i>
            Formulir Acara Baru
        </div>
        <div class="card-body">
            <form action="process_event.php" method="POST" enctype="multipart/form-data" id="createEventForm">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="row">
                    <!-- Kolom Utama -->
                    <div class="col-lg-8">
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul Acara <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php echo isset($form_errors['title']) ? 'is-invalid' : ''; ?>" id="title" name="title" value="<?php echo esc_html($form_data['title'] ?? ''); ?>" required>
                            <?php if (isset($form_errors['title'])): ?><div class="invalid-feedback"><?php echo $form_errors['title']; ?></div><?php endif; ?>
                        </div>

                        <div class="mb-3">
                            <label for="description_html" class="form-label">Deskripsi Lengkap Acara</label>
                            <textarea class="form-control tinymce-editor" id="description_html" name="description_html" rows="15"><?php echo esc_html($form_data['description_html'] ?? ''); ?></textarea>
                        </div>
                        
                        <div class="card card-body border-top-0 shadow-sm">
                             <h5 class="card-title h6 mb-3">Informasi Tambahan (Opsional)</h5>
                             <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="location" class="form-label">Lokasi</label>
                                    <input type="text" class="form-control" id="location" name="location" value="<?php echo esc_html($form_data['location'] ?? ''); ?>" placeholder="Contoh: Auditorium Kampus">
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="organizer" class="form-label">Penyelenggara</label>
                                    <input type="text" class="form-control" id="organizer" name="organizer" value="<?php echo esc_html($form_data['organizer'] ?? ''); ?>" placeholder="Contoh: BEM UGKMB">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="contact_person" class="form-label">Narahubung</label>
                                    <input type="text" class="form-control" id="contact_person" name="contact_person" value="<?php echo esc_html($form_data['contact_person'] ?? ''); ?>">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="contact_email" class="form-label">Email Kontak</label>
                                    <input type="email" class="form-control" id="contact_email" name="contact_email" value="<?php echo esc_html($form_data['contact_email'] ?? ''); ?>">
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="contact_phone" class="form-label">Telepon Kontak</label>
                                    <input type="tel" class="form-control" id="contact_phone" name="contact_phone" value="<?php echo esc_html($form_data['contact_phone'] ?? ''); ?>">
                                </div>
                                <div class="col-12">
                                     <label for="event_url" class="form-label">URL Eksternal (Link Pendaftaran, dll)</label>
                                     <input type="url" class="form-control" id="event_url" name="event_url" value="<?php echo esc_html($form_data['event_url'] ?? ''); ?>" placeholder="https://linkpendaftaran.com">
                                </div>
                             </div>
                        </div>
                    </div>

                    <!-- Kolom Samping (Sidebar) -->
                    <div class="col-lg-4">
                        <div class="card card-body shadow-sm mb-4">
                            <h5 class="card-title h6 mb-3"><i class="fas fa-cog me-1"></i> Publikasi</h5>
                             <div class="mb-3">
                                <label for="start_datetime" class="form-label">Tanggal Mulai <span class="text-danger">*</span></label>
                                <input type="datetime-local" class="form-control <?php echo isset($form_errors['start_datetime']) ? 'is-invalid' : ''; ?>" id="start_datetime" name="start_datetime" value="<?php echo esc_html($form_data['start_datetime'] ?? date('Y-m-d\TH:i')); ?>" required>
                                <?php if (isset($form_errors['start_datetime'])): ?><div class="invalid-feedback"><?php echo $form_errors['start_datetime']; ?></div><?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label for="end_datetime" class="form-label">Tanggal Selesai (Opsional)</label>
                                <input type="datetime-local" class="form-control" id="end_datetime" name="end_datetime" value="<?php echo esc_html($form_data['end_datetime'] ?? ''); ?>">
                            </div>
                             <div class="mb-3">
                                <label for="slug" class="form-label">Slug</label>
                                <input type="text" class="form-control <?php echo isset($form_errors['slug']) ? 'is-invalid' : ''; ?>" id="slug" name="slug" value="<?php echo esc_html($form_data['slug'] ?? ''); ?>" placeholder="Dibuat otomatis jika kosong">
                                <?php if (isset($form_errors['slug'])): ?><div class="invalid-feedback"><?php echo $form_errors['slug']; ?></div><?php endif; ?>
                            </div>
                            <div class="mb-3">
                                <label for="is_published" class="form-label">Status</label>
                                <select class="form-select" id="is_published" name="is_published">
                                    <option value="1" <?php echo (isset($form_data['is_published']) && $form_data['is_published'] == 1) ? 'selected' : ''; ?>>Publikasikan</option>
                                    <option value="0" <?php echo (!isset($form_data['is_published']) || $form_data['is_published'] == 0) ? 'selected' : ''; ?>>Simpan sebagai Draft</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="card card-body shadow-sm">
                             <h5 class="card-title h6 mb-3"><i class="fas fa-image me-1"></i> Gambar Unggulan</h5>
                            <div class="mb-3">
                                <label for="featured_image_file" class="form-label">Upload Gambar</label>
                                <input type="file" class="form-control <?php echo isset($form_errors['featured_image_file']) ? 'is-invalid' : ''; ?>" id="featured_image_file" name="featured_image_file" accept="image/jpeg,image/png,image/gif,image/webp">
                                <small class="text-muted">Rekomendasi ukuran: 800x500 piksel.</small>
                                <?php if (isset($form_errors['featured_image_file'])): ?><div class="invalid-feedback d-block"><?php echo $form_errors['featured_image_file']; ?></div><?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <hr class="my-4">
                <div class="d-flex justify-content-end">
                    <a href="index.php" class="btn btn-secondary me-2">Batal</a>
                    <button type="submit" class="btn btn-primary" id="submitButton"><i class="fas fa-save me-1"></i> Simpan Acara</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
// Memasukkan skrip untuk editor TinyMCE dan logika AJAX
$page_scripts[] = '<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>';
$page_scripts[] = '<script src="' . $module_base_path . 'assets/js/tinymce-configs.js"></script>';

$page_scripts[] = "<script>
$(document).ready(function() {
    $('#createEventForm').on('submit', function(e) {
        // Mencegah form dikirim secara normal
        e.preventDefault();

        // Update konten TinyMCE ke dalam textarea
        if (typeof tinymce !== 'undefined') {
            tinymce.triggerSave();
        }

        const form = $(this);
        const submitButton = $('#submitButton');
        const originalButtonHtml = submitButton.html();
        
        // Nonaktifkan tombol dan tampilkan spinner
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\"></span> Menyimpan...');

        // Buat objek FormData untuk mengirim file
        var formData = new FormData(this);

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            dataType: 'json',
            contentType: false, // Wajib untuk FormData
            processData: false, // Wajib untuk FormData
            
            success: function(response) {
                if (response.success) {
                    // Tampilkan notifikasi sukses
                    showAdminNotification('success', response.message);
                    
                    // LAKUKAN REDIRECT JIKA URL DITERIMA
                    if (response.redirect_url) {
                        setTimeout(function() {
                            window.location.href = response.redirect_url;
                        }, 1000); // Tunggu 1 detik sebelum redirect
                    }
                } else {
                    // Tampilkan notifikasi error
                    showAdminNotification('danger', response.message || 'Terjadi kesalahan validasi.');
                    // Aktifkan kembali tombol
                    submitButton.prop('disabled', false).html(originalButtonHtml);
                }
            },
            error: function(jqXHR) {
                let errorMessage = 'Terjadi kesalahan pada server. Silakan coba lagi.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                    errorMessage = jqXHR.responseJSON.message;
                }
                showAdminNotification('danger', errorMessage);
                // Aktifkan kembali tombol
                submitButton.prop('disabled', false).html(originalButtonHtml);
            }
        });
    });
});
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>

