<?php
// admin/modules/contact_messages/index.php

ini_set('display_errors', 1); // Aktifkan untuk development
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Pastikan config.php dimuat paling awal dan hanya sekali
if (file_exists(dirname(__DIR__, 3) . '/config.php')) {
    require_once dirname(__DIR__, 3) . '/config.php';
} elseif (file_exists(dirname(__FILE__, 4) . '/config.php')) { 
    require_once dirname(__FILE__, 4) . '/config.php';
} else {
    error_log("CRITICAL FAILURE: config.php not found from contact_messages/index.php.");
    die("Konfigurasi sistem tidak ditemukan.");
}

// Autentikasi & Otorisasi
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    set_flash_message('danger', 'Akses ditolak. Anda tidak memiliki izin untuk halaman ini.');
    if (!headers_sent()) { header('Location: ' . admin_url('login.php')); }
    exit;
}

$page_title = "Manajemen Pesan Kontak";
$show_archived = isset($_GET['archived']) && $_GET['archived'] == '1';

$contact_messages = [];
if (!isset($pdo)) {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
    // Biarkan array $contact_messages kosong, DataTables akan menangani pesan empty
} else {
    try {
        $sql = "SELECT id, sender_name, sender_email, subject, created_at, is_read, is_archived
                FROM portal_contact_messages
                WHERE is_archived = :is_archived
                ORDER BY created_at DESC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':is_archived', $show_archived ? 1 : 0, PDO::PARAM_INT);
        $stmt->execute();
        $contact_messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data pesan kontak: ' . $e->getMessage());
        error_log("Error fetching contact messages: " . $e->getMessage());
    }
}

require_once PROJECT_ROOT . '/admin/includes/header.php';
// sidebar.php biasanya di-include oleh header.php
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => admin_url('index.php')],
        $show_archived ? 'Pesan Kontak Diarsipkan' : 'Manajemen Pesan Kontak'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title) . ($show_archived ? ' (Diarsipkan)' : ' (Kotak Masuk)'); ?></h1>
    <hr class="mb-4">
    <?php echo display_flash_message(); ?>

    <div class="mb-3 d-flex justify-content-between align-items-center">
        <div> 
            <?php if ($show_archived): ?>
                <a href="<?php echo admin_url('modules/contact_messages/index.php'); ?>" class="btn btn-outline-primary"><i class="fas fa-inbox me-1"></i> Kembali ke Kotak Masuk</a>
            <?php else: ?>
                <a href="<?php echo admin_url('modules/contact_messages/index.php?archived=1'); ?>" class="btn btn-outline-secondary"><i class="fas fa-archive me-1"></i> Lihat Pesan Diarsipkan</a>
            <?php endif; ?>
        </div>
        <div>
            <!-- Tombol aksi global lainnya bisa ditambahkan di sini -->
        </div>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-envelope-open-text me-1"></i>
            Daftar Pesan <?php echo $show_archived ? 'Diarsipkan' : 'Masuk'; ?>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableContactMessages" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th scope="col" style="width: 5%;">No</th>
                            <th scope="col" style="width: 15%;">Pengirim</th>
                            <th scope="col" style="width: 20%;">Email</th>
                            <th scope="col">Subjek</th>
                            <th scope="col" style="width: 15%;">Tanggal Diterima</th>
                            <th scope="col" style="width: 12%;" class="text-center">Status</th>
                            <th scope="col" style="width: 18%;" class="text-center text-nowrap">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php // Loop hanya jika $contact_messages tidak kosong. DataTables akan handle pesan kosong. ?>
                        <?php if (!empty($contact_messages)): ?>
                            <?php foreach ($contact_messages as $index => $message): ?>
                            <tr class="<?php echo !$message['is_read'] && !$show_archived ? 'fw-bold table-light' : ''; ?>" id="messageRow-<?php echo esc_html($message['id']); ?>">
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo esc_html($message['sender_name']); ?></td>
                                <td><a href="mailto:<?php echo esc_html($message['sender_email']); ?>" title="Kirim email ke <?php echo esc_html($message['sender_email']); ?>"><?php echo esc_html($message['sender_email']); ?></a></td>
                                <td>
                                    <a href="<?php echo admin_url('modules/contact_messages/view.php?id=' . esc_html($message['id'])); ?>" title="Lihat detail pesan">
                                        <?php echo esc_html($message['subject']); ?>
                                    </a>
                                </td>
                                <td data-order="<?php echo strtotime($message['created_at']); // Untuk sorting DataTables yang benar berdasarkan timestamp ?>">
                                    <?php echo date('d M Y, H:i', strtotime($message['created_at'])); ?>
                                </td>
                                <td class="text-center">
                                    <?php if (!$show_archived): // Hanya tampilkan status baca/belum jika di kotak masuk ?>
                                        <?php if ($message['is_read']): ?>
                                            <span class="badge bg-secondary">Sudah Dibaca</span>
                                        <?php else: ?>
                                            <span class="badge bg-primary">Baru</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                     <?php if ($message['is_archived']): ?>
                                        <span class="badge bg-warning text-dark ms-1">Diarsipkan</span>
                                    <?php endif; ?>
                                    <?php if (empty($message['is_read']) && empty($message['is_archived']) && $show_archived): // Jika belum dibaca dan sudah diarsipkan (aneh, tapi jaga2) ?>
                                        <span class="badge bg-info text-dark">Belum Dibaca</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <a href="<?php echo admin_url('modules/contact_messages/view.php?id=' . esc_html($message['id'])); ?>" class="btn btn-sm btn-info mb-1 me-1" title="Lihat Detail">
                                        <i class="fas fa-eye"></i> <span class="d-none d-md-inline">Lihat</span>
                                    </a>
                                    <?php
                                    $csrf_token_for_actions_cm_row = generate_csrf_token(); // Regenerate untuk setiap set tombol jika perlu, atau gunakan satu dari atas
                                    $process_url_base_cm_row = admin_url('modules/contact_messages/process_message.php');
                                    ?>
                                    <?php if (!$show_archived): ?>
                                        <?php if (!$message['is_read']): ?>
                                        <a href="<?php echo $process_url_base_cm_row . '?action=mark_read&id=' . esc_html($message['id']) . '&csrf_token=' . $csrf_token_for_actions_cm_row; ?>" class="btn btn-sm btn-outline-success mb-1 me-1 action-mark-read" title="Tandai Sudah Dibaca">
                                            <i class="fas fa-check-circle"></i>
                                        </a>
                                        <?php else: ?>
                                        <a href="<?php echo $process_url_base_cm_row . '?action=mark_unread&id=' . esc_html($message['id']) . '&csrf_token=' . $csrf_token_for_actions_cm_row; ?>" class="btn btn-sm btn-outline-secondary mb-1 me-1 action-mark-unread" title="Tandai Belum Dibaca">
                                            <i class="fas fa-envelope"></i>
                                        </a>
                                        <?php endif; ?>
                                        <button type="button" class="btn btn-sm btn-outline-warning mb-1 me-1 btn-archive-message"
                                                data-id="<?php echo esc_html($message['id']); ?>"
                                                data-subject="<?php echo esc_html(addslashes($message['subject'])); ?>"
                                                title="Arsipkan Pesan">
                                           <i class="fas fa-archive"></i>
                                        </button>
                                    <?php else: // Jika di halaman arsip ?>
                                        <button type="button" class="btn btn-sm btn-outline-success mb-1 me-1 btn-unarchive-message"
                                                data-id="<?php echo esc_html($message['id']); ?>"
                                                data-subject="<?php echo esc_html(addslashes($message['subject'])); ?>"
                                                title="Batal Arsip (Kembalikan ke Kotak Masuk)">
                                           <i class="fas fa-box-open"></i>
                                        </button>
                                    <?php endif; ?>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-message"
                                            data-id="<?php echo esc_html($message['id']); ?>"
                                            data-subject="<?php echo esc_html(addslashes($message['subject'])); ?>"
                                            title="Hapus Permanen">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts = []; // Inisialisasi array $page_scripts
// Variabel PHP ke JS menggunakan json_encode untuk keamanan dan menghindari error sintaks
$js_process_message_url_cm_page = json_encode(admin_url('modules/contact_messages/process_message.php'));
$js_initial_csrf_token_cm_page = json_encode(generate_csrf_token()); // Token awal untuk halaman ini
$js_show_archived_flag_cm_page = json_encode($show_archived); // boolean akan di-encode dengan benar

// Menggunakan Heredoc untuk blok JavaScript yang panjang
$inline_script_content_contact_messages = <<<JS_CONTACT_MESSAGES_PAGE
<script>
    // Fallback functions jika admin-global.js belum termuat atau fungsi tidak ada
    if (typeof showAdminNotification === 'undefined') { function showAdminNotification(type, message) { console.warn('showAdminNotification fallback:', type, message); alert(type + ': ' + message); } }
    if (typeof confirmAdminAction === 'undefined') { window.confirmAdminAction = function(message, callback) { if (confirm(message)) { if (typeof callback === 'function') callback(); } }; }

    // Variabel JS global untuk halaman ini (dengan suffix _CM_Page untuk unik)
    const processMessageUrl_CM_Page = $js_process_message_url_cm_page;
    let currentCsrfToken_CM_Page = $js_initial_csrf_token_cm_page;
    const isArchivedView_CM_Page = $js_show_archived_flag_cm_page;

    // Fungsi untuk mengupdate CSRF token di halaman ini
    function updateCsrfTokenOnContactPage_CM(newToken) {
        currentCsrfToken_CM_Page = newToken;
        // Jika ada form lain di halaman ini yang juga menggunakan CSRF, update di sini
        // Misalnya: $('input[name="csrf_token_form_lain"]').val(newToken);
    }

    $(document).ready(function() {
        const contactMessagesTableInstance = $('#dataTableContactMessages').DataTable({
            responsive: true,
            language: { 
                search: "Cari:", 
                lengthMenu: "Tampilkan _MENU_ entri per halaman",
                info: "Menampilkan _START_ sampai _END_ dari _TOTAL_ total pesan",
                infoEmpty: "Tidak ada pesan untuk ditampilkan saat ini", 
                infoFiltered: "(disaring dari _MAX_ total pesan)",
                paginate: { first: "Awal", last: "Akhir", next: "Berikutnya", previous: "Sebelumnya" },
                zeroRecords: "Tidak ada pesan yang cocok dengan kriteria pencarian Anda", 
                emptyTable: "Tidak ada pesan untuk ditampilkan di " + (isArchivedView_CM_Page ? "halaman arsip ini" : "kotak masuk ini") + "."
            },
            "order": [[ 4, "desc" ]], // Order by "Tanggal Diterima" (indeks kolom ke-4) descending
            columnDefs: [
                { targets: [0, 5, 6], orderable: false, searchable: false }, // Kolom No, Status, Aksi
                // Kolom Tanggal (indeks 4) sudah memiliki data-order untuk sorting yang benar
            ]
        });

        // Fungsi generik untuk aksi AJAX (archive, unarchive, delete)
        function performMessageAction_CM_Page(buttonElement, actionType, confirmMessageText, successMessageText) {
            const button = $(buttonElement);
            const messageId = button.data('id');
            const messageSubject = button.data('subject') || 'pesan ini'; 
            const rowElement = button.closest('tr');
            let originalButtonHtml = button.data('original-html-cm'); // Gunakan nama data unik
            if(!originalButtonHtml) { 
                originalButtonHtml = button.html();
                button.data('original-html-cm', originalButtonHtml);
            }

            if (typeof messageId === 'undefined' || messageId === null || messageId === '' || parseInt(messageId) <= 0) {
                showAdminNotification('danger', 'Error: ID Pesan tidak valid untuk aksi ini.');
                return;
            }
            
            const finalConfirmMessageText = confirmMessageText.replace('{subject}', messageSubject);

            confirmAdminAction(finalConfirmMessageText, function() { // onConfirm callback
                button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span>');
                $.ajax({
                    url: processMessageUrl_CM_Page,
                    method: 'POST', 
                    data: {
                        action: actionType,
                        id: messageId, // 'id' sesuai dengan yang diharapkan process_message.php
                        csrf_token: currentCsrfToken_CM_Page,
                        archived_view: isArchivedView_CM_Page ? '1' : '0' 
                    },
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message || successMessageText);
                            contactMessagesTableInstance.row(rowElement).remove().draw(false);
                            if (contactMessagesTableInstance.rows().count() === 0) {
                                // DataTables akan menampilkan pesan emptyTable secara otomatis
                            }
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal melakukan aksi pada pesan.');
                        }
                        if (response.new_csrf_token) {
                            updateCsrfTokenOnContactPage_CM(response.new_csrf_token);
                        }
                    },
                    error: function(jqXHR) {
                        let errorMsgAjaxCMPage = 'Kesalahan server saat memproses permintaan.';
                        if(jqXHR.responseJSON && jqXHR.responseJSON.message) errorMsgAjaxCMPage = jqXHR.responseJSON.message;
                        else if(jqXHR.statusText) errorMsgAjaxCMPage += ' Status: ' + jqXHR.statusText;
                        showAdminNotification('danger', errorMsgAjaxCMPage);
                        console.error('Contact Message Action AJAX Error:', jqXHR.status, jqXHR.responseText);
                    },
                    complete: function() {
                        button.prop('disabled', false).html(originalButtonHtml);
                    }
                });
            });
        }

        $('#dataTableContactMessages').on('click', '.btn-archive-message', function() {
            performMessageAction_CM_Page(this, 'archive', 'Anda yakin ingin mengarsipkan pesan dengan subjek: "{subject}"?', 'Pesan berhasil diarsipkan.');
        });
        $('#dataTableContactMessages').on('click', '.btn-unarchive-message', function() {
            performMessageAction_CM_Page(this, 'unarchive', 'Anda yakin ingin membatalkan pengarsipan pesan dengan subjek: "{subject}"?', 'Pesan berhasil dikembalikan ke kotak masuk.');
        });
        $('#dataTableContactMessages').on('click', '.btn-delete-message', function() {
            performMessageAction_CM_Page(this, 'delete', 'PERINGATAN: Anda yakin ingin menghapus permanen pesan dengan subjek: "{subject}"? Aksi ini tidak dapat dibatalkan.', 'Pesan berhasil dihapus secara permanen.');
        });

        // Untuk link mark_read/unread, biarkan sebagai request GET biasa yang akan me-refresh halaman.
        // Jika ingin AJAX, logika akan mirip dengan performMessageAction_CM_Page tapi mungkin tanpa konfirmasi
        // dan akan mengupdate tampilan baris (misal, class fw-bold) daripada menghapusnya.
    });
</script>
JS_CONTACT_MESSAGES_PAGE;

$page_scripts[] = $inline_script_content_contact_messages; 
require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>