<?php
// admin/modules/articles/edit.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Artikel";
$article_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($article_id_to_edit <= 0) { /* ... handle error & redirect ... */ }
$article_db_data = null; $article_current_tags = [];

if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_articles WHERE id = :id");
        $stmt->execute([':id' => $article_id_to_edit]);
        $article_db_data = $stmt->fetch();
        if ($article_db_data) {
            $stmt_current_tags = $pdo->prepare("SELECT tag_id FROM portal_article_tag WHERE article_id = :article_id");
            $stmt_current_tags->execute([':article_id' => $article_id_to_edit]);
            $article_current_tags = $stmt_current_tags->fetchAll(PDO::FETCH_COLUMN);
        } else { /* ... handle not found & redirect ... */ }
    } catch (\PDOException $e) { /* ... handle error & redirect ... */ }
}
if (!$article_db_data) { /* ... handle not found & redirect ... */ }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$categories = []; // Fetch categories (sama seperti di create.php)
if(isset($pdo)){ try{ $stmt_cat = $pdo->query("SELECT id, name FROM portal_categories ORDER BY name ASC"); $categories = $stmt_cat->fetchAll(); } catch(\PDOException $e){} }

$tags_available = []; // Fetch tags (sama seperti di create.php)
if(isset($pdo)){ try{ $stmt_tags_all = $pdo->query("SELECT id, name FROM portal_tags ORDER BY name ASC"); $tags_available = $stmt_tags_all->fetchAll(); } catch(\PDOException $e){} }


$form_data = $_SESSION['form_data'] ?? [
    'title' => $article_db_data['title'], 'slug' => $article_db_data['slug'],
    'category_id' => $article_db_data['category_id'], 'content_html' => $article_db_data['content_html'],
    'excerpt' => $article_db_data['excerpt'], 'status' => $article_db_data['status'],
    'published_at' => $article_db_data['published_at'] ? date('Y-m-d\TH:i', strtotime($article_db_data['published_at'])) : '',
    'featured_image_url' => $article_db_data['featured_image_url'],
    'meta_keywords' => $article_db_data['meta_keywords'], 'meta_description' => $article_db_data['meta_description'],
    'allow_comments' => $article_db_data['allow_comments'], 'tags' => $article_current_tags
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($article_db_data['title']); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_article.php" method="POST" enctype="multipart/form-data" id="articleForm">
        <input type="hidden" name="action" value="edit">
        <input type="hidden" name="id" value="<?php echo $article_db_data['id']; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
        <input type="hidden" name="old_featured_image_url" value="<?php echo esc_html($article_db_data['featured_image_url'] ?? ''); ?>">

        <div class="row">
            <!-- Kolom Konten Utama (sama seperti create.php) -->
            <div class="col-lg-9">
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-file-alt me-1"></i> Informasi Artikel</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul Artikel <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', $article_db_data['title'], $form_data); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="slug" class="form-label">Slug (URL Friendly)</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', $article_db_data['slug'], $form_data); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="content_html" class="form-label">Konten Artikel <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="content_html" name="content_html" rows="18"><?php echo old_form_data('content_html', $article_db_data['content_html'], $form_data); ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label for="excerpt" class="form-label">Kutipan Singkat (Excerpt)</label>
                            <textarea class="form-control" id="excerpt" name="excerpt" rows="4"><?php echo old_form_data('excerpt', $article_db_data['excerpt'], $form_data); ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                     <div class="card-header"><i class="fas fa-search-dollar me-1"></i> Pengaturan SEO (Opsional)</div>
                    <div class="card-body">
                         <div class="mb-3">
                            <label for="meta_keywords" class="form-label">Meta Keywords</label>
                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo old_form_data('meta_keywords', $article_db_data['meta_keywords'], $form_data); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="meta_description" class="form-label">Meta Description</label>
                            <textarea class="form-control" id="meta_description" name="meta_description" rows="3" maxlength="160"><?php echo old_form_data('meta_description', $article_db_data['meta_description'], $form_data); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Kolom Sidebar Kanan (sama seperti create.php, tapi tombol Simpan Perubahan) -->
            <div class="col-lg-3">
                <div class="card mb-4 shadow-sm sticky-lg-top" style="top: 70px;">
                    <div class="card-header"><i class="fas fa-cogs me-1"></i> Publikasi</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select" id="status" name="status" required>
                                <option value="draft" <?php echo (old_form_data('status', $article_db_data['status'], $form_data) == 'draft') ? 'selected' : ''; ?>>Draft</option>
                                <option value="published" <?php echo (old_form_data('status', $article_db_data['status'], $form_data) == 'published') ? 'selected' : ''; ?>>Published</option>
                                <option value="pending" <?php echo (old_form_data('status', $article_db_data['status'], $form_data) == 'pending') ? 'selected' : ''; ?>>Pending Review</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="published_at" class="form-label">Tanggal Publikasi</label>
                            <input type="datetime-local" class="form-control" id="published_at" name="published_at" value="<?php echo old_form_data('published_at', $article_db_data['published_at'] ? date('Y-m-d\TH:i', strtotime($article_db_data['published_at'])) : '', $form_data); ?>">
                        </div>
                         <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" value="1" id="allow_comments" name="allow_comments" <?php echo (old_form_data('allow_comments', $article_db_data['allow_comments'], $form_data) == 1) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="allow_comments">Izinkan Komentar</label>
                        </div>
                        <button type="submit" class="btn btn-primary w-100" id="saveArticleButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                     <div class="card-header"><i class="fas fa-folder-open me-1"></i> Kategori <span class="text-danger">*</span></div>
                    <div class="card-body">
                        <select class="form-select" id="category_id" name="category_id" required>
                            <option value="">-- Pilih Kategori --</option>
                            <?php foreach ($categories as $category): ?>
                            <option value="<?php echo $category['id']; ?>" <?php echo (old_form_data('category_id', $article_db_data['category_id'], $form_data) == $category['id']) ? 'selected' : ''; ?>>
                                <?php echo esc_html($category['name']); ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                        <div class="mt-2"><a href="<?php echo $module_base_path; ?>modules/categories/create.php" target="_blank" class="small text-decoration-none"><i class="fas fa-plus-circle fa-xs"></i> Tambah Kategori Baru</a></div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-tags me-1"></i> Tags (Opsional)</div>
                    <div class="card-body" style="max-height: 250px; overflow-y: auto;">
                         <?php if(!empty($tags_available)): ?>
                        <?php foreach ($tags_available as $tag): ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="tags[]" value="<?php echo $tag['id']; ?>" id="tag_<?php echo $tag['id']; ?>"
                                    <?php echo in_array($tag['id'], (array)old_form_data('tags', $article_current_tags, $form_data)) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="tag_<?php echo $tag['id']; ?>"><?php echo esc_html($tag['name']); ?></label>
                            </div>
                        <?php endforeach; ?>
                        <?php else: ?> <p class="small text-muted">Belum ada tag.</p> <?php endif; ?>
                        <div class="mt-2"><a href="<?php echo $module_base_path; ?>modules/tags/create.php" target="_blank" class="small text-decoration-none"><i class="fas fa-plus-circle fa-xs"></i> Tambah Tag Baru</a></div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-image me-1"></i> Gambar Unggulan (Opsional)</div>
                    <div class="card-body text-center">
                        <img id="featuredImagePreview" 
                             src="<?php echo !empty($form_data['featured_image_url']) ? resolve_url(esc_html($form_data['featured_image_url'])) : '#'; ?>" 
                             alt="Preview Gambar Unggulan" 
                             class="img-thumbnail mb-2" 
                             style="max-height: 150px; <?php echo empty($form_data['featured_image_url']) ? 'display: none;' : ''; ?>"
                             data-default-src="<?php echo !empty($form_data['featured_image_url']) ? resolve_url(esc_html($form_data['featured_image_url'])) : '#'; ?>">
                        <input type="file" class="form-control form-control-sm" id="featured_image_file" name="featured_image_file" accept="image/jpeg, image/png, image/gif, image/webp">
                        <div class="form-text">Upload baru untuk mengganti. Biarkan kosong jika tidak ingin mengubah.</div>
                        <?php echo get_form_error('featured_image_file', $form_errors); ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php
// Skrip AJAX, TinyMCE, slug, image preview sama seperti di create.php
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js";
$page_scripts[] = "<script>
$(document).ready(function() {
    tinymce.init({ /* ... Konfigurasi TinyMCE ... */
        selector: 'textarea#content_html',
        plugins: 'lists link image table code help wordcount autoresize preview fullscreen media visualblocks charmap anchor pagebreak searchreplace visualchars',
        toolbar1: 'undo redo | styles | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | fontfamily fontsize blocks',
        toolbar2: 'bullist numlist outdent indent | link image media | table charmap | forecolor backcolor removeformat | pagebreak | anchor | searchreplace visualblocks code fullscreen preview | help',
        height: 550,
        menubar: 'file edit view insert format tools table help'
    });

    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('title', 'slug');
    }
    if (typeof initializeImagePreview === 'function') {
        initializeImagePreview('featured_image_file', 'featuredImagePreview');
    }

    $('#articleForm').on('submit', function(e) { /* ... AJAX submit logic ... */
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveArticleButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        if (typeof tinymce !== 'undefined' && tinymce.get('content_html')) {
            tinymce.get('content_html').save();
        }
        const formData = new FormData(this);

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                         setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    }
                    // Untuk edit, biasanya tidak reset form, kecuali jika data baru dikembalikan
                    if (response.updated_data && response.updated_data.featured_image_url) {
                        $('#featuredImagePreview').attr('src', resolve_url_js(response.updated_data.featured_image_url)).data('default-src', resolve_url_js(response.updated_data.featured_image_url)).show();
                        $('input[name=\"old_featured_image_url\"]').val(response.updated_data.featured_image_url);
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan artikel.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
    // Helper resolve_url JS jika dibutuhkan oleh success callback
    const BASE_URL_JS_HELPER = '" . (defined("BASE_URL") ? BASE_URL : "") . "';
    function resolve_url_js(path) {
        if (!BASE_URL_JS_HELPER) return path;
        return BASE_URL_JS_HELPER + '/' + path.replace(/^\\//, '');
    }
});
</script>";
require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>