<?php
// admin/includes/sidebar.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// PROJECT_ROOT and BASE_URL should be defined by config.php, included via header.php or db_connect.php
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 2)); }
if (!defined('BASE_URL')) { /* Fallback or error, but ideally set */ }


$current_page_script = basename($_SERVER['PHP_SELF']);
$current_url_path = $_SERVER['PHP_SELF'];
$current_module_sidebar = '';

// Determine the current module based on URL structure
if (preg_match_all('~admin/modules/([^/]+)/~', $current_url_path, $matches)) {
    $current_module_sidebar = $matches[1][0] ?? '';
}

// Calculate path to admin root from the current script's location (where sidebar.php is included)
// This helps make links in the sidebar robust.
$path_to_admin_root_from_current_script_context = '';
$path_to_self_sidebar_context = str_replace('\\', '/', $_SERVER['PHP_SELF']);
$admin_folder_pos_sidebar_context = strpos($path_to_self_sidebar_context, '/admin/');

if ($admin_folder_pos_sidebar_context !== false) {
    $path_after_admin_sidebar_context = substr($path_to_self_sidebar_context, $admin_folder_pos_sidebar_context + strlen('/admin/'));
    $depth_sidebar_context = substr_count($path_after_admin_sidebar_context, '/');
    $path_to_admin_root_from_current_script_context = str_repeat('../', $depth_sidebar_context);
} else {
    $path_to_admin_root_from_current_script_context = './'; // Fallback
}

// Function to generate a link correctly resolving from current context to admin root, then to target
// function admin_url($target_path_from_admin_root, $base_path_to_admin_root) {
//     // Ensure target path doesn't start with / if base_path_to_admin_root is used
//     $target_path_from_admin_root = ltrim($target_path_from_admin_root, '/');
//     return rtrim($base_path_to_admin_root, '/') . '/' . $target_path_from_admin_root;
// }

?>
<div id="layoutSidenav_nav">
    <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
        <div class="sb-sidenav-menu">
            <div class="nav">
                <div class="sb-sidenav-menu-heading">Utama</div>
                <a class="nav-link <?php echo ($current_page_script == 'index.php' && empty($current_module_sidebar) && strpos($current_url_path, '/admin/index.php') !== false) ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                    Dashboard
                </a>

                <div class="sb-sidenav-menu-heading">Konten</div>
                <a class="nav-link <?php echo ($current_module_sidebar == 'articles') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/articles/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-newspaper"></i></div>
                    Artikel
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'pages') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/pages/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-file-alt"></i></div>
                    Halaman Statis
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'categories') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/categories/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-folder-open"></i></div>
                    Kategori
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'tags') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/tags/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-tags"></i></div>
                    Tags
                </a>
                

                <div class="sb-sidenav-menu-heading">Akademik</div>
                 <a class="nav-link <?php echo ($current_module_sidebar == 'faculties') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/faculties/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-university"></i></div>
                    Fakultas
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'study_programs') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/study_programs/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-graduation-cap"></i></div>
                    Program Studi
                </a>

                <div class="sb-sidenav-menu-heading">Fitur Lain</div>
                <a class="nav-link <?php echo ($current_module_sidebar == 'events') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/events/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-calendar-alt"></i></div>
                    Agenda/Acara
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'gallery_albums') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/gallery_albums/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-images"></i></div>
                    Galeri
                </a>
                 <a class="nav-link <?php echo ($current_module_sidebar == 'sliders') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/sliders/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-images"></i></div>
                    Slider Homepage
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'quick_links') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/quick_links/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-link"></i></div>
                    Tautan Cepat
                </a>
                 <a class="nav-link <?php echo ($current_module_sidebar == 'contact_messages') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/contact_messages/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-envelope-open-text"></i></div>
                    Pesan Kontak
                </a>

                <div class="sb-sidenav-menu-heading">Administrasi</div>
                 <a class="nav-link <?php echo ($current_module_sidebar == 'menus') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/menus/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-stream"></i></div>
                    Manajemen Menu
                </a>
                <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
                <a class="nav-link <?php echo ($current_module_sidebar == 'users') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/users/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-users-cog"></i></div>
                    Pengguna
                </a>
                <a class="nav-link <?php echo ($current_module_sidebar == 'settings') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars(admin_url('modules/settings/index.php', $path_to_admin_root_from_current_script_context)); ?>">
                    <div class="sb-nav-link-icon"><i class="fas fa-cogs"></i></div>
                    Pengaturan Website
                </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="sb-sidenav-footer">
            <div class="small">Masuk sebagai:</div>
            <?php echo isset($_SESSION['full_name']) && !empty($_SESSION['full_name']) ? htmlspecialchars($_SESSION['full_name']) : (isset($_SESSION['username']) ? htmlspecialchars($_SESSION['username']) : 'Pengguna'); ?>
            (<?php echo isset($_SESSION['role']) ? ucfirst(htmlspecialchars($_SESSION['role'])) : 'Role Tidak Diketahui'; ?>)
        </div>
    </nav>
</div>