<?php
// admin/includes/footer.php

// Centralized PROJECT_ROOT definition (should be in config.php and included earlier)
if (!defined('PROJECT_ROOT')) {
    // Fallback jika belum didefinisikan (seharusnya sudah oleh config.php)
    define('PROJECT_ROOT', dirname(__DIR__, 2)); 
}
// Ensure config.php (which defines BASE_URL) is included
if (!defined('BASE_URL')) { 
    if (file_exists(PROJECT_ROOT . '/config.php')) {
        require_once PROJECT_ROOT . '/config.php';
    } else {
        // Fallback darurat jika config.php tidak ditemukan
        error_log("CRITICAL: config.php not found or BASE_URL not defined from admin/includes/footer.php. Path tried: " . PROJECT_ROOT . '/config.php');
        // Definisikan resolve_url fallback jika benar-benar tidak ada
        if(!function_exists('resolve_url')) { function resolve_url($path) { return $path; } }
    }
}

$current_page_basename_footer = basename($_SERVER['PHP_SELF']);

// Pathing for assets (JS)
$admin_root_from_current_php_footer = '';
$path_to_self_footer = str_replace('\\', '/', $_SERVER['PHP_SELF'] ?? '');
$admin_folder_pos_footer = strpos($path_to_self_footer, '/admin/');

if ($admin_folder_pos_footer !== false) {
    $path_after_admin_footer = substr($path_to_self_footer, $admin_folder_pos_footer + strlen('/admin/'));
    $depth_footer = substr_count($path_after_admin_footer, '/');
    $admin_root_from_current_php_footer = str_repeat('../', $depth_footer);
} else {
    // Jika '/admin/' tidak ditemukan, mungkin script ada di root admin atau struktur berbeda
    // Coba deteksi berdasarkan kedalaman relatif terhadap PROJECT_ROOT jika diketahui
    if (defined('PROJECT_ROOT')) {
        $current_script_path_from_project_root = str_replace(str_replace('\\', '/', PROJECT_ROOT), '', str_replace('\\', '/', __FILE__));
        $current_script_path_from_project_root = ltrim($current_script_path_from_project_root, '/');
        $admin_path_relative_to_script = '';
        // Jika kita tahu footer.php ada di admin/includes/footer.php
        if (strpos($current_script_path_from_project_root, 'admin/includes/footer.php') !== false) {
            $path_to_admin_root = substr($current_script_path_from_project_root, 0, strpos($current_script_path_from_project_root, 'admin/') + strlen('admin/'));
            $parts = explode('/', rtrim(substr($current_script_path_from_project_root, strlen($path_to_admin_root)), '/'));
            $admin_root_from_current_php_footer = str_repeat('../', count(array_filter($parts)) +1 ); // +1 untuk keluar dari 'admin'
             // Perbaikan jika footer.php langsung di admin/
            if(strpos($current_script_path_from_project_root, 'admin/footer.php') !== false && !strpos($current_script_path_from_project_root, 'admin/includes/footer.php')) {
                 $admin_root_from_current_php_footer = './';
            } else if (strpos($current_script_path_from_project_root, 'admin/includes/footer.php') !== false) {
                // ../ untuk keluar dari includes, lalu ./ untuk admin root
                $admin_root_from_current_php_footer = '../'; 
            }

        } else {
             $admin_root_from_current_php_footer = './'; // Fallback umum
        }
    } else {
        $admin_root_from_current_php_footer = './'; 
    }
}

// Override jika ini adalah login.php (yang ada di root admin)
if ($current_page_basename_footer === 'login.php' && strpos($path_to_self_footer, '/admin/login.php') !== false) {
    $admin_root_from_current_php_footer = ''; // Tidak perlu ../
}
// Override jika footer.php ada di admin/includes/
if (strpos(str_replace('\\', '/', __FILE__), '/admin/includes/footer.php') !== false && $current_page_basename_footer !== 'login.php') {
    $admin_root_from_current_php_footer = '../'; // Satu level up dari includes ke admin
}
// Jika footer.php ada di admin/ (bukan di includes/) dan bukan login.php
else if (strpos(str_replace('\\', '/', __FILE__), '/admin/footer.php') !== false && $current_page_basename_footer !== 'login.php') {
    $admin_root_from_current_php_footer = ''; // Sudah di root admin
}


// Ambil settings untuk footer text
global $settings; // Diasumsikan $settings sudah di-load oleh config.php atau header.php
$footer_admin_text = $settings['footer_admin_text'] ?? 'Hak Cipta © Universitas Graha Karya Muara Bulian ' . date('Y');


?>

            <?php if ($current_page_basename_footer !== 'login.php'): ?>
                </main> 
                <footer class="py-4 footer-admin mt-auto bg-light dark:bg-dark">
                    <div class="container-fluid px-4">
                        <div class="d-flex align-items-center justify-content-between small">
                            <div class="text-muted dark:text-gray-400"><?php echo esc_html($footer_admin_text); ?>
                            <div class="text-muted">
                            Made with <i class="fas fa-heart text-danger"></i> by <a href="https://mitrautamateknologi.co-id.id/" target="_blank" rel="noopener noreferrer">CV MUT</a>
                        </div>
                            </div>
                             
                            <div>
                                <!-- Tambahan link jika perlu, misal: -->
                                <!-- <a href="#">Privacy Policy</a> · <a href="#">Terms & Conditions</a> -->
                            </div>
                        </div>
                    </div>
                </footer>
            </div> <!-- Penutup #layoutSidenav_content -->
        </div> <!-- Penutup #layoutSidenav -->
    <?php endif; // End if not login.php ?> 

    <!-- Bootstrap JS Bundle (Popper.js included) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>

    <!-- Core Admin Theme Scripts (misal dari SB Admin atau custom Anda) -->
    <script src="<?php echo htmlspecialchars($admin_root_from_current_php_footer); ?>assets/js/scripts.js"></script>

    <!-- jQuery (HARUS DIMUAT SEBELUM script yang menggunakan $) -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

    <!-- DataTables JS & Bootstrap 5 Integration (bergantung jQuery) -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

    <!-- Script Global Admin (jika ada, dan mungkin bergantung jQuery) -->
    <?php 
    // Contoh jika Anda punya admin-global.js
    // $admin_global_js_path = $admin_root_from_current_php_footer . 'assets/js/admin-global.js';
    // echo '<script src="' . htmlspecialchars($admin_global_js_path) . '"></script>'; 
    ?>

    <!-- Definisi Fungsi Notifikasi dan Error Form (bergantung jQuery untuk displayAdminFormErrors) -->
    <script>
        // Fungsi Notifikasi Admin Global
        function showAdminNotification(type, message, duration = 5000) {
            const notificationContainerId = 'adminNotificationArea';
            let container = document.getElementById(notificationContainerId);

            if (!container) {
                container = document.createElement('div');
                container.id = notificationContainerId;
                // Styling untuk container notifikasi (pojok kanan atas)
                container.style.position = 'fixed';
                container.style.top = '70px'; // Sesuaikan dengan tinggi navbar admin Anda
                container.style.right = '20px';
                container.style.zIndex = '1090'; // Pastikan di atas komponen lain (modal Bootstrap biasanya 1050-1060)
                container.style.width = 'auto';   // Lebar otomatis
                container.style.maxWidth = '400px'; // Lebar maksimal
                document.body.appendChild(container);
            }

            const alertEl = document.createElement('div');
            // Mapping tipe ke class alert Bootstrap
            const alertTypeClass = (type === 'error' || type === 'danger') ? 'danger' : 
                                  (type === 'warning' ? 'warning' : 
                                  (type === 'info' ? 'info' : 'success'));
            
            alertEl.className = `alert alert-${alertTypeClass} alert-dismissible fade show shadow-sm`; // Tambah shadow
            alertEl.setAttribute('role', 'alert');
            alertEl.style.marginBottom = '10px'; // Jarak antar notifikasi
            
            alertEl.innerHTML = `
                <div>${message}</div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            `;
            
            container.insertBefore(alertEl, container.firstChild); // Notifikasi baru muncul di atas

            // Auto-dismiss menggunakan Bootstrap's Alert component
            if (typeof bootstrap !== 'undefined' && bootstrap.Alert) {
                const bsAlert = new bootstrap.Alert(alertEl);
                setTimeout(() => {
                    if (alertEl.parentElement) { // Cek apakah elemen masih ada di DOM
                        bsAlert.close();
                    }
                }, duration);
            } else { // Fallback jika Bootstrap Alert JS tidak ada
                setTimeout(() => {
                    if (alertEl.parentElement) {
                        alertEl.remove();
                    }
                }, duration);
            }
        }

        // Fungsi untuk menampilkan error form dari AJAX (bergantung jQuery)
        if (typeof displayAdminFormErrors === 'undefined') {
            function displayAdminFormErrors(formElement, errors) { // formElement harus objek jQuery
                if (!formElement || !formElement.length) return;

                // Hapus error sebelumnya di form ini
                formElement.find('.is-invalid').removeClass('is-invalid');
                formElement.find('.invalid-feedback.custom-ajax-error').remove(); // Hapus error AJAX lama
                
                // Untuk error feedback standar Bootstrap, kosongkan saja
                formElement.find('.invalid-feedback:not(.custom-ajax-error)').html('');

                if (typeof errors === 'object' && errors !== null) {
                    $.each(errors, function(key, value) {
                        const field = formElement.find(`[name="${key}"], [name="${key}[]"]`);
                        if (field.length > 0) {
                            field.addClass('is-invalid');
                            let feedbackElement = field.siblings('.invalid-feedback');
                            if (!feedbackElement.length) { // Jika tidak ada sibling .invalid-feedback
                                // Coba cari di parent jika input ada di dalam input-group atau sejenisnya
                                feedbackElement = field.closest('.mb-3, .form-group').find('.invalid-feedback');
                            }
                            if (!feedbackElement.length) { // Jika masih tidak ada, buat baru
                                feedbackElement = $('<div class="invalid-feedback custom-ajax-error"></div>').insertAfter(field.last());
                            }
                            feedbackElement.html(Array.isArray(value) ? value.join('<br>') : value).show();
                        } else {
                            // Jika error tidak terkait field spesifik (misal, error umum form)
                            // Anda bisa menambahkannya ke area error umum di form
                            // console.warn(`Field not found for error key: ${key}`);
                            // Contoh: formElement.find('.form-general-error-area').append(`<p class="text-danger">${value}</p>`);
                        }
                    });
                } else if (typeof errors === 'string') { // Jika errors adalah string tunggal
                     // Tampilkan sebagai error umum form
                     // Contoh: formElement.find('.form-general-error-area').html(`<p class="text-danger">${errors}</p>`).show();
                     showAdminNotification('danger', errors); // Atau tampilkan sebagai notifikasi
                }
            }
        }
    </script>

    <!-- Script untuk Sidebar Toggle & Theme Switcher Admin (tidak bergantung jQuery) -->
    <script>
        <?php if ($current_page_basename_footer !== 'login.php'): ?>
        // Sidebar Toggle Script (sesuaikan dengan implementasi SB Admin Anda)
        window.addEventListener('DOMContentLoaded', event => { 
            const sidebarToggle = document.body.querySelector('#sidebarToggle');
            if (sidebarToggle) {
                // Cek localStorage untuk state sidebar
                if (localStorage.getItem('sb|sidebar-toggle') === 'true' && !document.body.classList.contains('sb-sidenav-toggled')) {
                    document.body.classList.add('sb-sidenav-toggled');
                } else if (localStorage.getItem('sb|sidebar-toggle') === 'false' && document.body.classList.contains('sb-sidenav-toggled')) {
                     document.body.classList.remove('sb-sidenav-toggled');
                }
                // Event listener untuk toggle
                sidebarToggle.addEventListener('click', event => {
                    event.preventDefault();
                    document.body.classList.toggle('sb-sidenav-toggled');
                    localStorage.setItem('sb|sidebar-toggle', document.body.classList.contains('sb-sidenav-toggled'));
                });
            }
        });
        <?php endif; ?>

        // Admin Theme Switcher Script
        const adminThemeToggleBtn = document.getElementById('themeToggle'); // ID tombol tema di header admin
        const adminThemeIcon = document.getElementById('themeIcon');    // ID ikon di tombol tema

        function applyAdminTheme(selectedTheme) {
            document.documentElement.className = selectedTheme; // Ganti class di <html> (light-theme atau dark-theme)
            // Jika body juga perlu class tema (misal untuk override Bootstrap), tambahkan di sini:
            // document.body.className = selectedTheme + (document.body.classList.contains('sb-nav-fixed') ? ' sb-nav-fixed' : '');
            // Atau jika Anda menggunakan class Bootstrap dark mode:
            if (selectedTheme === 'dark-theme') {
                document.body.setAttribute('data-bs-theme', 'dark');
                 if (adminThemeIcon) { adminThemeIcon.classList.remove('fa-moon'); adminThemeIcon.classList.add('fa-sun'); }
            } else {
                document.body.setAttribute('data-bs-theme', 'light');
                if (adminThemeIcon) { adminThemeIcon.classList.remove('fa-sun'); adminThemeIcon.classList.add('fa-moon'); }
            }
            document.cookie = "admin_theme=" + selectedTheme + ";path=/;max-age=" + (60*60*24*365) + ";SameSite=Lax";
        }

        // Inisialisasi tema saat halaman dimuat
        // Ambil dari cookie, atau fallback ke preferensi sistem, atau default ke light
        let currentAdminTheme = document.cookie.split('; ').find(row => row.startsWith('admin_theme='))?.split('=')[1] || 
                               (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark-theme' : 'light-theme');
        applyAdminTheme(currentAdminTheme);

        if (adminThemeToggleBtn) {
            adminThemeToggleBtn.addEventListener('click', () => {
                let newTheme = document.documentElement.classList.contains('dark-theme') ? 'light-theme' : 'dark-theme';
                applyAdminTheme(newTheme);
            });
        }
      
    </script>
  <!-- Underscore.js (atau Lodash) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/underscore.js/1.13.6/underscore-min.js" integrity="sha512-2V49R8nda9f0VI*/}YFhZslYEotwaAdgZjKYiPUQRVKJvSUK49dkD8A5RTbM2Sg1N5TKsynWjyEHEtI0C1YmTE4w==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- ATAU Lodash jika Anda lebih suka: -->
    <!-- <script src="https://cdn.jsdelivr.net/npm/lodash@4.17.21/lodash.min.js"></script> -->

    <?php
    // Output page-specific scripts (SEKARANG semua fungsi global sudah PASTI terdefinisi)
    if (isset($page_scripts) && is_array($page_scripts)) {
        foreach ($page_scripts as $script_source) {
            // Check if it's a full URL, an absolute path, a relative path, or inline script
            if (strpos($script_source, '<script>') !== false) {
                echo $script_source . "\n"; // Ini adalah blok script inline
            } else {
                $resolved_script_url = $script_source; // Asumsikan sudah URL atau path absolut
                if (!preg_match('~^(?:f|ht)tps?://~i', $script_source) && substr($script_source, 0, 1) !== '/') {
                    // Jika path relatif, gabungkan dengan $admin_root_from_current_php_footer
                    $resolved_script_url = $admin_root_from_current_php_footer . ltrim($script_source, './');
                }
                echo '<script src="' . htmlspecialchars($resolved_script_url) . '"></script>' . "\n";
            }
        }
    }
    // Output page-specific styles (kurang umum di footer, tapi untuk kelengkapan)
    if (isset($page_styles) && is_array($page_styles)) {
        foreach ($page_styles as $style_block) {
            echo $style_block . "\n";
        }
    }
    ?>
   
</body>
</html>