$(document).ready(function() {
    // Gunakan event delegation untuk tombol hapus yang mungkin ditambahkan secara dinamis
    $(document).on('click', '.btn-delete-item', function(e) {
        e.preventDefault(); // Mencegah aksi default jika tombol ada di dalam form

        var $thisButton = $(this);
        var itemId = $thisButton.data('id');
        var module = $thisButton.data('module');
        var itemName = $thisButton.data('item-name') |
| 'item ini'; // Nama item untuk pesan konfirmasi
        var rowTargetSelector = $thisButton.data('row-target'); // Selector untuk elemen yang akan dihapus dari DOM

        if (!itemId ||!module) {
            alert('Kesalahan: Atribut data-id atau data-module tidak ditemukan pada tombol.');
            return;
        }

        // Tampilkan dialog konfirmasi
        if (confirm('Apakah Anda yakin ingin menghapus ' + itemName + '? Aksi ini tidak dapat dibatalkan.')) {
            // Kirim permintaan AJAX
            $.ajax({
                url: '../ajax_delete_handler.php', // Sesuaikan path jika perlu
                type: 'POST',
                dataType: 'json',
                data: {
                    id: itemId,
                    module: module
                    // Jika menggunakan CSRF, tambahkan token di sini:
                    // csrf_token: 'your_csrf_token_value'
                },
                beforeSend: function() {
                    // Opsional: Tampilkan loading atau nonaktifkan tombol
                    $thisButton.prop('disabled', true).text('Menghapus...');
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.message |
| 'Item berhasil dihapus.');
                        // Hapus elemen dari DOM jika selector target diberikan
                        if (rowTargetSelector) {
                            $(rowTargetSelector).fadeOut(500, function() {
                                $(this).remove();
                            });
                        } else {
                            // Jika tidak ada target spesifik, coba hapus baris tabel terdekat (tr)
                            $thisButton.closest('tr').fadeOut(500, function() {
                                $(this).remove();
                            });
                        }
                        // Opsional: Reload halaman atau update data table jika menggunakan DataTables
                        // location.reload();
                    } else {
                        alert('Gagal menghapus: ' + (response.message |
| 'Terjadi kesalahan.'));
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.error("AJAX Error:", textStatus, errorThrown, jqXHR.responseText);
                    alert('Terjadi kesalahan pada server. Silakan coba lagi. Detail: ' + textStatus);
                },
                complete: function() {
                    // Kembalikan tombol ke keadaan semula
                    $thisButton.prop('disabled', false).text('Delete'); // Atau teks asli tombol
                }
            });
        }
    });
});