<?php
// public/index.php
if (session_status() == PHP_SESSION_NONE) {
    // session_start(); // Handled by config.php
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__));
}

require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php'; // Untuk resolve_url dan esc_html

// ======================================================================
// KODE PHP ASLI ANDA - TIDAK DIUBAH SAMA SEKALI
// ======================================================================
$settings = [];
$sliders = [];
$latest_articles_section_1 = [];
$featured_story_section_2 = null;
$side_stories_section_2 = [];
$media_text_blocks = [];
$spotlight_categories_with_articles = [];
$featured_stories_slider = [];
$quick_links_homepage = [];

if (isset($pdo)) {
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
        while ($row = $stmt_settings->fetch()) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }

        // Sliders
        $stmt_sliders = $pdo->query("SELECT title, description, image_url_desktop, image_url_mobile, link_url, button_text
                                     FROM portal_sliders
                                     WHERE is_active = 1 AND (start_date IS NULL OR start_date <= NOW()) AND (end_date IS NULL OR end_date >= NOW())
                                     ORDER BY slide_order ASC LIMIT 5");
        $sliders = $stmt_sliders->fetchAll();

        // Section 1: Berita Terkini
        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at
                                 FROM portal_articles a 
                                 LEFT JOIN portal_categories c ON a.category_id = c.id
                                 LEFT JOIN portal_users u ON a.author_id = u.id
                                 WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

        // Section 2: Artikel Utama & Sampingan
        $stmt_s2_main = $pdo->query("SELECT a.id, a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at
                                      FROM portal_articles a 
                                      LEFT JOIN portal_categories c ON a.category_id = c.id
                                      LEFT JOIN portal_users u ON a.author_id = u.id
                                      WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.views_count DESC, a.published_at DESC LIMIT 1");
        $featured_story_section_2 = $stmt_s2_main->fetch();

        $side_stories_section_2_query_id_exclude = $featured_story_section_2['id'] ?? 0;
        $stmt_s2_side = $pdo->prepare("SELECT a.title, a.slug, c.name as category_name, c.slug as category_slug, u.full_name as author_name, a.published_at
                                       FROM portal_articles a 
                                       LEFT JOIN portal_categories c ON a.category_id = c.id
                                       LEFT JOIN portal_users u ON a.author_id = u.id
                                       WHERE a.status = 'published' AND a.published_at <= NOW() AND a.id != :exclude_id 
                                       ORDER BY a.published_at DESC LIMIT 4");
        $stmt_s2_side->execute(['exclude_id' => $side_stories_section_2_query_id_exclude]);
        $side_stories_section_2 = $stmt_s2_side->fetchAll();

        // Media Text Blocks (Untuk section alternating)
        $stmt_media_text_all = $pdo->query("SELECT title, slug, excerpt, featured_image_url, published_at, u.full_name as author_name
                                             FROM portal_articles 
                                             LEFT JOIN portal_users u ON portal_articles.author_id = u.id
                                             WHERE status='published' AND published_at <= NOW() 
                                             ORDER BY RAND() LIMIT 3");
        $media_text_blocks = $stmt_media_text_all->fetchAll();

        // Kategori Sorotan
        $spotlight_category_slugs = ['berita-kampus', 'riset', 'event-kampus'];
        foreach ($spotlight_category_slugs as $slug) {
            $stmt_spotlight_cat_info = $pdo->prepare("SELECT id, name, slug FROM portal_categories WHERE slug = :slug LIMIT 1");
            $stmt_spotlight_cat_info->execute(['slug' => $slug]);
            $category_info = $stmt_spotlight_cat_info->fetch();

            if ($category_info) {
                $stmt_articles_in_cat = $pdo->prepare("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, u.full_name as author_name, a.published_at
                                                        FROM portal_articles a
                                                        LEFT JOIN portal_users u ON a.author_id = u.id
                                                        WHERE a.category_id = :category_id AND a.status = 'published' AND a.published_at <= NOW()
                                                        ORDER BY a.published_at DESC LIMIT 3");
                $stmt_articles_in_cat->execute(['category_id' => $category_info['id']]);
                $articles = $stmt_articles_in_cat->fetchAll();

                if (!empty($articles)) {
                    $spotlight_categories_with_articles[] = [
                        'category_info' => $category_info,
                        'articles' => $articles
                    ];
                }
            }
        }

        // Featured Stories Slider
        $stmt_feat_slider = $pdo->query("SELECT title, slug, excerpt, featured_image_url, u.full_name as author_name, published_at 
                                         FROM portal_articles 
                                         LEFT JOIN portal_users u ON portal_articles.author_id = u.id
                                         WHERE status='published' AND published_at <= NOW() 
                                         ORDER BY views_count DESC, published_at DESC LIMIT 5");
        $featured_stories_slider = $stmt_feat_slider->fetchAll();

        // Quick Links
        $stmt_ql_home = $pdo->query("SELECT title, url, icon_class, open_in_new_tab FROM portal_quick_links WHERE is_active = 1 AND group_key = 'homepage_focus' ORDER BY link_order ASC LIMIT 4");
        $quick_links_homepage = $stmt_ql_home->fetchAll();

    } catch (\PDOException $e) {
        error_log("Error fetching data for public/index.php: " . $e->getMessage());
    }
}

// Pengaturan Judul Halaman & Meta
$site_title = htmlspecialchars($settings['site_name'] ?? 'UGKMB Portal');
if (!empty($settings['homepage_title_seo'])) { $site_title = htmlspecialchars($settings['homepage_title_seo']); }
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');
if (!empty($settings['homepage_meta_description_seo'])) { $meta_description = htmlspecialchars($settings['homepage_meta_description_seo']); }

require_once PROJECT_ROOT . '/public/includes/header_public.php';
?>

<main class="homepage-main">

    <?php if (!empty($sliders)): ?>
    <section id="hero-slider" class="carousel slide main-hero-slider" data-bs-ride="carousel" data-bs-interval="7000">
        <div class="carousel-indicators">
            <?php foreach ($sliders as $index => $slide): ?>
            <button type="button" data-bs-target="#hero-slider" data-bs-slide-to="<?php echo $index; ?>" class="<?php echo ($index == 0) ? 'active' : ''; ?>" aria-current="<?php echo ($index == 0) ? 'true' : 'false'; ?>" aria-label="Slide <?php echo $index + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
        <div class="carousel-inner">
            <?php foreach ($sliders as $index => $slide): ?>
            <div class="carousel-item <?php echo ($index == 0) ? 'active' : ''; ?>">
                <div class="hero-slider-image-wrapper">
                    <picture>
                        <?php if(!empty($slide['image_url_mobile'])): ?>
                        <source media="(max-width: 767px)" srcset="<?php echo htmlspecialchars(resolve_url($slide['image_url_mobile'])); ?>">
                        <?php endif; ?>
                        <img src="<?php echo htmlspecialchars(resolve_url($slide['image_url_desktop'])); ?>" class="d-block w-100 hero-slider-image" alt="<?php echo esc_html($slide['title']); ?>" loading="<?php echo ($index == 0) ? 'eager' : 'lazy'; ?>">
                    </picture>
                </div>
                <div class="container h-100">
                    <div class="carousel-caption text-start">
                        <h1 class="display-4 fw-bold animate__animated animate__fadeInDown animate__delay-0.5s"><?php echo esc_html($slide['title']); ?></h1>
                        <?php if(!empty($slide['description'])): ?><p class="lead d-none d-md-block animate__animated animate__fadeInUp animate__delay-0.8s col-md-8 col-lg-7"><?php echo esc_html($slide['description']); ?></p><?php endif; ?>
                        <?php if(!empty($slide['link_url']) && !empty($slide['button_text'])): ?>
                            <a href="<?php echo esc_html($slide['link_url']); ?>" class="btn btn-primary btn-lg mt-3 animate__animated animate__fadeInUp animate__delay-1s"><?php echo esc_html($slide['button_text']); ?> <i class="fas fa-arrow-right ms-1"></i></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php if (count($sliders) > 1): ?>
        <button class="carousel-control-prev" type="button" data-bs-target="#hero-slider" data-bs-slide="prev">
            <span class="carousel-control-prev-icon" aria-hidden="true"></span><span class="visually-hidden">Previous</span></button>
        <button class="carousel-control-next" type="button" data-bs-target="#hero-slider" data-bs-slide="next">
            <span class="carousel-control-next-icon" aria-hidden="true"></span><span class="visually-hidden">Next</span></button>
        <?php endif; ?>
    </section>
    <?php endif; ?>

    <section class="py-5 section-latest-news">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Berita & Informasi Terkini</h2>
            </header>
            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
                <?php if (!empty($latest_articles_section_1)): ?>
                    <?php foreach($latest_articles_section_1 as $article): ?>
                    <div class="col d-flex align-items-stretch">
                        <div class="card h-100 shadow-sm custom-card article-card-hover">
                            <?php if (!empty($article['featured_image_url'])): ?>
                            <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="article-card-image-link">
                                <img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" loading="lazy">
                            </a>
                            <?php endif; ?>
                            <div class="card-body d-flex flex-column">
                                <?php if(!empty($article['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($article['category_slug'])); ?>" class="badge bg-primary text-decoration-none mb-2 align-self-start"><?php echo esc_html($article['category_name']); ?></a><?php endif; ?>
                                <h5 class="card-title h6 custom-card-title mb-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                                <p class="card-text small text-muted custom-card-excerpt flex-grow-1 mb-2"><?php echo esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...'; ?></p>
                                <div class="mt-auto">
                                    <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($article['published_at'])); ?></small>
                                    <?php if (!empty($article['author_name'])): ?>
                                        <small class="text-muted article-meta ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($article['author_name']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="col-12"><p class="text-muted text-center">Belum ada berita terkini.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="py-5 bg-light-subtle">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h3 class="section-title h3 fw-bold custom-page-title">Postingan Terdahulu dari Situs Utama</h3>
            </header>
            <div id="wordpress-posts-container-index" class="row row-cols-1 row-cols-sm-2 row-cols-lg-4 g-4">
                <div id="wp-loading-indicator-index" class="col-12 text-center">
                    <div class="spinner-border text-secondary" role="status"><span class="visually-hidden">Memuat...</span></div>
                </div>
            </div>
            <div class="text-center mt-5">
                <a href="<?php echo resolve_url('articles.php'); ?>" class="btn btn-outline-primary">Lihat Arsip Berita Lengkap <i class="fas fa-arrow-right ms-1"></i></a>
            </div>
        </div>
    </section>

    <section class="py-5 section-news-layout-B">
        <div class="container">
            <header class="section-header text-center mb-5">
                <h2 class="section-title display-5 fw-bold custom-page-title">Wawasan & Pendanaan</h2>
                <p class="lead text-muted section-subtitle">Wawasan mendalam mengenai pendanaan riset dan dampaknya.</p>
            </header>
            <div class="row g-lg-5"> 
                <div class="col-lg-7 mb-4 mb-lg-0">
                    <?php if ($featured_story_section_2): ?>
                    <div class="card custom-card-featured shadow-lg h-100 article-card-hover">
                        <?php if($featured_story_section_2['featured_image_url']): ?>
                        <a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>" class="article-card-image-link">
                            <img src="<?php echo resolve_url(esc_html($featured_story_section_2['featured_image_url'])); ?>" class="card-img-top custom-card-img-featured" alt="<?php echo esc_html($featured_story_section_2['title']); ?>" loading="lazy" style="min-height: 300px; object-fit:cover;">
                        </a>
                        <?php endif; ?>
                        <div class="card-body d-flex flex-column p-4"> 
                            <?php if(!empty($featured_story_section_2['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($featured_story_section_2['category_slug'])); ?>" class="badge bg-danger text-decoration-none mb-2 align-self-start"><?php echo esc_html($featured_story_section_2['category_name']); ?></a><?php endif; ?>
                            <h3 class="card-title h4 fw-bold custom-card-title mb-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($featured_story_section_2['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($featured_story_section_2['title']); ?></a></h3>
                            <p class="text-muted small custom-card-excerpt flex-grow-1 mb-3"><?php echo esc_html(substr(strip_tags($featured_story_section_2['excerpt'] ?? ''), 0, 180)) . '...'; ?></p>
                             <div class="mt-auto">
                                <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> <?php echo date('d M Y', strtotime($featured_story_section_2['published_at'])); ?></small>
                                <?php if (!empty($featured_story_section_2['author_name'])): ?>
                                    <small class="text-muted article-meta ms-2"><i class="fas fa-user fa-xs me-1"></i> <?php echo esc_html($featured_story_section_2['author_name']); ?></small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                        <div class="alert alert-secondary text-center">Cerita unggulan sedang disiapkan.</div>
                    <?php endif; ?>
                </div>
                <div class="col-lg-5">
                    <h4 class="h5 fw-semibold mb-3">Baca Juga:</h4>
                    <ul class="list-group list-group-flush custom-side-list">
                        <?php if(!empty($side_stories_section_2)): ?>
                            <?php foreach($side_stories_section_2 as $idx_side => $story): ?>
                            <li class="list-group-item bg-transparent px-0 py-3 <?php echo ($idx_side < count($side_stories_section_2) - 1) ? 'border-bottom' : '';?>">
                                <?php if(!empty($story['category_name'])): ?><a href="<?php echo resolve_url('category.php?slug='.esc_html($story['category_slug'])); ?>" class="text-uppercase text-decoration-none text-danger small fw-bold custom-side-list-category d-block mb-1"><?php echo esc_html($story['category_name']); ?></a><?php endif; ?>
                                <h5 class="h6 mb-1 custom-side-list-title line-clamp-2"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($story['slug'])); ?>" class="text-decoration-none"><?php echo esc_html($story['title']); ?></a></h5>
                                <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs"></i> <?php echo date('d M \'y', strtotime($story['published_at'])); ?></small>
                            </li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <li class="list-group-item bg-transparent px-0 text-muted">Cerita lainnya akan segera hadir.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <section class="py-5">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-4">
                    <h3 class="h4 fw-bold custom-page-title">Halaman Penting</h3>
                     <div id="wordpress-pages-container" class="list-group list-group-flush mt-3">
                        <div id="wp-pages-loader" class="text-center"><div class="spinner-border spinner-border-sm text-secondary" role="status"></div></div>
                     </div>
                </div>
                <div class="col-lg-8">
                    <h3 class="h4 fw-bold custom-page-title">Galeri Media Terbaru</h3>
                    <div id="wordpress-media-container" class="row row-cols-2 row-cols-sm-3 row-cols-md-4 g-3 mt-3">
                         <div id="wp-media-loader" class="col-12 text-center"><div class="spinner-border spinner-border-sm text-secondary" role="status"></div></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';
    
    // Fungsi untuk mengambil data dan merendernya
    const fetchAndRender = async (endpoint, containerId, loaderId, renderFunction) => {
        const container = document.getElementById(containerId);
        const loader = document.getElementById(loaderId);
        
        if (!container) return;

        try {
            const response = await fetch(`${baseApiUrl}${endpoint}`);
            if (!response.ok) throw new Error('Network response was not ok');
            const data = await response.json();
            
            if (loader) loader.style.display = 'none';
            
            if (data.length === 0) {
                container.innerHTML = `<div class="col-12"><p class="text-muted small">Tidak ada konten yang bisa ditampilkan.</p></div>`;
            } else {
                renderFunction(data, container);
            }
        } catch (error) {
            console.error(`Error fetching ${endpoint}:`, error);
            if (loader) loader.style.display = 'none';
            container.innerHTML = `<div class="col-12"><p class="text-danger small">Gagal memuat konten.</p></div>`;
        }
    };

    // Fungsi Render untuk Postingan
    const renderPosts = (posts, container) => {
        let html = '';
        posts.forEach(post => {
            const featuredImage = post._embedded?.['wp:featuredmedia']?.[0]?.source_url || '<?php echo resolve_url("assets/images/default-placeholder.png"); ?>';
            const postDate = new Date(post.date).toLocaleDateString('id-ID', { day: 'numeric', month: 'short', year: 'numeric' });
            html += `
                <div class="col d-flex align-items-stretch">
                    <div class="card h-100 shadow-sm custom-card article-card-hover">
                        <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="article-card-image-link">
                            <img src="${featuredImage}" class="card-img-top custom-card-img" alt="${post.title.rendered}" loading="lazy">
                        </a>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title h6 custom-card-title mb-2">
                                <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="text-decoration-none stretched-link">${post.title.rendered}</a>
                            </h5>
                            <div class="mt-auto">
                                <small class="text-muted article-meta"><i class="fas fa-calendar-alt fa-xs me-1"></i> ${postDate}</small>
                            </div>
                        </div>
                    </div>
                </div>`;
        });
        container.innerHTML = html;
    };

    // Fungsi Render untuk Halaman
    const renderPages = (pages, container) => {
        let html = '';
        pages.forEach(page => {
            html += `
                <a href="${page.link}" target="_blank" rel="noopener noreferrer" class="list-group-item list-group-item-action d-flex align-items-center px-0">
                    <i class="fas fa-file-alt fa-fw me-2 text-primary"></i>
                    ${page.title.rendered}
                    <i class="fas fa-external-link-alt fa-xs ms-auto text-muted"></i>
                </a>`;
        });
        container.innerHTML = html;
    };

    // Fungsi Render untuk Media
    const renderMedia = (media, container) => {
        let html = '';
        media.forEach(item => {
            if (item.media_type === 'image' && item.source_url) {
                html += `
                    <div class="col">
                        <a href="${item.source_url}" target="_blank" rel="noopener noreferrer">
                            <img src="${item.media_details.sizes.thumbnail.source_url}" class="img-fluid rounded shadow-sm" alt="${item.title.rendered}" style="aspect-ratio: 1/1; object-fit: cover;">
                        </a>
                    </div>`;
            }
        });
        container.innerHTML = html;
    };

    // Panggil semua fungsi fetch
    fetchAndRender('/posts?per_page=4&_embed', 'wordpress-posts-container-index', 'wp-loading-indicator-index', renderPosts);
    fetchAndRender('/pages?per_page=5', 'wordpress-pages-container', 'wp-pages-loader', renderPages);
    fetchAndRender('/media?per_page=8&media_type=image', 'wordpress-media-container', 'wp-media-loader', renderMedia);

});
</script>

<?php
require_once PROJECT_ROOT . '/includes/footer_public.php';
?>