<?php
// public/index.php (FINAL & COMPLETE VERSION)

// PENTING: Panggil file konfigurasi utama dari root proyek untuk memastikan
// semua konstanta (seperti PROJECT_ROOT) dan koneksi database tersedia.
// Ini adalah praktik terbaik agar file ini mandiri dan dapat diandalkan.
require_once dirname(__DIR__) . '/config.php';

// Menyiapkan variabel untuk judul halaman dan meta deskripsi.
// Variabel ini akan digunakan oleh header_public.php.
global $pdo, $settings, $site_title, $meta_description;

$site_title = htmlspecialchars($settings['site_name'] ?? 'UGKMB Portal');
$meta_description = htmlspecialchars($settings['site_tagline'] ?? 'Universitas Graha Karya Muara Bulian');

// ======================================================================
// PENGAMBILAN DATA LENGKAP DARI DATABASE LOKAL
// ======================================================================
$sliders = [];
$latest_articles_section_1 = [];
$upcoming_events = [];
$media_text_blocks = [];
$spotlight_categories_with_articles = [];

if (isset($pdo)) {
    try {
        // Data Sliders
        $stmt_sliders = $pdo->query("SELECT title, description, image_url_desktop, image_url_mobile, link_url, button_text FROM portal_sliders WHERE is_active = 1 AND (start_date IS NULL OR start_date <= NOW()) AND (end_date IS NULL OR end_date >= NOW()) ORDER BY slide_order ASC LIMIT 5");
        $sliders = $stmt_sliders->fetchAll();

        // Data Berita Terkini
        $stmt_s1 = $pdo->query("SELECT a.title, a.slug, a.excerpt, a.featured_image_url, c.name as category_name, c.slug as category_slug FROM portal_articles a LEFT JOIN portal_categories c ON a.category_id = c.id WHERE a.status = 'published' AND a.published_at <= NOW() ORDER BY a.published_at DESC LIMIT 3");
        $latest_articles_section_1 = $stmt_s1->fetchAll();

        // Data Agenda Mendatang
        $stmt_events = $pdo->query("SELECT e.title, e.slug, e.start_datetime, e.location, e.featured_image_url FROM portal_events e WHERE e.is_published = 1 AND e.start_datetime >= CURDATE() ORDER BY e.start_datetime ASC LIMIT 5");
        $upcoming_events = $stmt_events->fetchAll();

        // Data Blok Media & Teks
        $stmt_media_text_all = $pdo->query("SELECT title, slug, excerpt, featured_image_url FROM portal_articles WHERE status='published' AND published_at <= NOW() ORDER BY RAND() LIMIT 3");
        $media_text_blocks = $stmt_media_text_all->fetchAll();
        
        // Data Spotlight Kategori
        $spotlight_category_slugs = ['berita-kampus', 'penelitian-pengabdian'];
        foreach ($spotlight_category_slugs as $slug) {
            $stmt_cat = $pdo->prepare("SELECT id, name, slug FROM portal_categories WHERE slug = :slug LIMIT 1");
            $stmt_cat->execute(['slug' => $slug]);
            $category_info = $stmt_cat->fetch();

            if ($category_info) {
                $stmt_articles = $pdo->prepare("SELECT title, slug, featured_image_url FROM portal_articles WHERE category_id = :category_id AND status = 'published' AND published_at <= NOW() ORDER BY published_at DESC LIMIT 4");
                $stmt_articles->execute(['category_id' => $category_info['id']]);
                $articles_in_cat = $stmt_articles->fetchAll();

                if (!empty($articles_in_cat)) {
                    $spotlight_categories_with_articles[] = ['category_info' => $category_info, 'articles' => $articles_in_cat];
                }
            }
        }

    } catch (\PDOException $e) {
        error_log("Error fetching data for public/index.php: " . $e->getMessage());
        // Jika ada kesalahan, variabel-variabel di atas akan tetap kosong dan situs akan menampilkan pesan "belum ada berita" dll.
    }
}

// Mulai render halaman setelah semua data berhasil diambil
require_once PROJECT_ROOT . '/public/includes/header_public.php';
?>

<style>
    /* ... (CSS tidak berubah) ... */
</style>

<main class="homepage-main">

    <?php if (!empty($sliders)): ?>
    <section id="hero-slider" class="carousel slide" data-bs-ride="carousel">
        <div class="carousel-inner">
            <?php foreach ($sliders as $index => $slide): ?>
            <div class="carousel-item <?php echo ($index == 0) ? 'active' : ''; ?>">
                <img src="<?php echo htmlspecialchars(resolve_url($slide['image_url_desktop'])); ?>" class="d-block w-100" alt="<?php echo esc_html($slide['title']); ?>" loading="<?php echo ($index == 0) ? 'eager' : 'lazy'; ?>">
                <div class="container h-100">
                    <div class="carousel-caption text-start">
                        <h1 data-aos="fade-down"><?php echo esc_html($slide['title']); ?></h1>
                        <?php if(!empty($slide['description'])): ?><p data-aos="fade-up" data-aos-delay="200"><?php echo esc_html($slide['description']); ?></p><?php endif; ?>
                        <?php if(!empty($slide['link_url'])): ?><a href="<?php echo esc_html($slide['link_url']); ?>" class="btn btn-primary btn-lg mt-3" data-aos="fade-up" data-aos-delay="400"><?php echo esc_html($slide['button_text'] ?? 'Selengkapnya'); ?> <i class="bi bi-arrow-right"></i></a><?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#hero-slider" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
        <button class="carousel-control-next" type="button" data-bs-target="#hero-slider" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
    </section>
    <?php endif; ?>

    <section class="py-5">
        <div class="container" data-aos="fade-up">
            <header class="section-header text-center mb-5"><h2 class="section-title custom-page-title">Berita & Informasi Terkini</h2></header>
            <div class="row row-cols-1 row-cols-md-3 g-4">
                <?php if (!empty($latest_articles_section_1)): foreach($latest_articles_section_1 as $article): ?>
                <div class="col d-flex align-items-stretch">
                    <div class="card h-100 article-card-hover">
                        <a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="overflow-hidden">
                            <img src="<?php echo resolve_url(esc_html($article['featured_image_url'])); ?>" class="card-img-top custom-card-img" alt="<?php echo esc_html($article['title']); ?>" loading="lazy">
                        </a>
                        <div class="card-body d-flex flex-column">
                            <a href="#" class="badge bg-primary text-decoration-none mb-2 align-self-start"><?= esc_html($article['category_name']) ?></a>
                            <h5 class="card-title"><a href="<?php echo resolve_url('article.php?slug=' . esc_html($article['slug'])); ?>" class="text-decoration-none stretched-link"><?php echo esc_html($article['title']); ?></a></h5>
                            <p class="card-text small text-muted flex-grow-1"><?= esc_html(substr(strip_tags($article['excerpt'] ?? ''), 0, 100)) . '...' ?></p>
                        </div>
                    </div>
                </div>
                <?php endforeach; else: ?>
                <div class="col-12"><p class="text-center">Belum ada berita terkini.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    
    <?php if (!empty($upcoming_events)): ?>
    <section class="py-5 bg-light-subtle">
        <div class="container" data-aos="fade-up">
            <header class="section-header text-center mb-5"><h2 class="section-title custom-page-title">Agenda Mendatang</h2></header>
            <div id="agendaSlider" class="carousel slide agenda-slider shadow-lg" data-bs-ride="carousel">
                 <div class="carousel-inner">
                     <?php foreach ($upcoming_events as $index => $event): ?>
                     <div class="carousel-item <?php if ($index == 0) echo 'active'; ?>" style="background-image: url('<?php echo !empty($event['featured_image_url']) ? resolve_url(esc_html($event['featured_image_url'])) : resolve_url('public/assets/images/default-event.jpg'); ?>');">
                         <div class="carousel-caption">
                             <div class="agenda-date-box mb-3">
                                 <div class="day"><?php echo date('d', strtotime($event['start_datetime'])); ?></div>
                                 <div class="month"><?php echo strtoupper(date('M', strtotime($event['start_datetime']))); ?></div>
                             </div>
                             <h3 class="fw-bold"><?php echo esc_html($event['title']); ?></h3>
                             <p><i class="bi bi-geo-alt-fill"></i> <?php echo esc_html($event['location'] ?? 'Informasi lokasi menyusul'); ?></p>
                             <a href="<?php echo resolve_url('event.php?slug=' . esc_html($event['slug'])); ?>" class="btn btn-primary">Lihat Detail</a>
                         </div>
                     </div>
                     <?php endforeach; ?>
                 </div>
                 <button class="carousel-control-prev" type="button" data-bs-target="#agendaSlider" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
                 <button class="carousel-control-next" type="button" data-bs-target="#agendaSlider" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
             </div>
        </div>
    </section>
    <?php endif; ?>

    <?php if (!empty($media_text_blocks)): ?>
    <section class="py-5">
        <div class="container">
            <?php foreach($media_text_blocks as $index => $block): ?>
            <div class="row align-items-center g-5 mb-5 media-text-block" data-aos="fade-up">
                <div class="col-lg-6 <?php echo $index % 2 != 0 ? 'order-lg-2' : ''; ?>">
                    <img src="<?php echo resolve_url(esc_html($block['featured_image_url'])); ?>" class="img-fluid media-img" alt="<?php echo esc_html($block['title']); ?>" loading="lazy">
                </div>
                <div class="col-lg-6">
                    <h3 class="fw-bold"><?php echo esc_html($block['title']); ?></h3>
                    <p class="text-muted"><?php echo esc_html($block['excerpt']); ?></p>
                    <a href="<?php echo resolve_url('article.php?slug=' . esc_html($block['slug'])); ?>" class="btn btn-outline-primary">Baca Selengkapnya</a>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </section>
    <?php endif; ?>
    
    <?php if (!empty($spotlight_categories_with_articles)): ?>
    <section class="py-5 bg-light-subtle">
        <div class="container" data-aos="fade-up">
            <?php foreach($spotlight_categories_with_articles as $spotlight): ?>
            <header class="section-header text-center mb-5"><h2 class="section-title custom-page-title"><?= esc_html($spotlight['category_info']['name']) ?></h2></header>
            <div class="row g-4">
                <?php foreach($spotlight['articles'] as $index => $article): ?>
                <div class="<?= $index == 0 ? 'col-lg-6' : 'col-lg-3 col-md-6'; ?>">
                    <a href="<?= resolve_url('article.php?slug=' . esc_html($article['slug'])) ?>" class="d-block spotlight-card article-card-hover h-100">
                        <img src="<?= resolve_url(esc_html($article['featured_image_url'])) ?>" class="img-fluid w-100 h-100" style="object-fit: cover;" alt="<?= esc_html($article['title']) ?>" loading="lazy">
                        <div class="spotlight-caption">
                            <h5 class="mb-0"><?= esc_html($article['title']) ?></h5>
                        </div>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
            <?php if(next($spotlight_categories_with_articles)): echo '<hr class="my-5">'; endif; ?>
            <?php endforeach; ?>
        </div>
    </section>
    <?php endif; ?>
    
    <section class="py-5">
        <div class="container" data-aos="fade-up">
            <div class="row g-5">
                <div class="col-lg-4">
                    <h3 class="h4 fw-bold custom-page-title">Halaman Penting</h3>
                     <div id="wordpress-pages-container" class="list-group list-group-flush mt-3">
                        <script>for(let i=0;i<4;i++){document.write('<div class="skeleton skeleton-text" style="height:2.5em;margin-bottom:0.5rem" aria-hidden="true"></div>')}</script>
                     </div>
                </div>
                <div class="col-lg-8">
                    <h3 class="h4 fw-bold custom-page-title">Galeri Media Terbaru</h3>
                    <div id="wordpress-media-container" class="row row-cols-3 row-cols-md-4 g-3 mt-3">
                        <script>for(let i=0;i<8;i++){document.write('<div class="col"><div class="skeleton" style="aspect-ratio:1/1;border-radius:var(--card-border-radius)" aria-hidden="true"></div></div>')}</script>
                    </div>
                </div>
            </div>
        </div>
    </section>

</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';
    
    const fetchAndRender = async (endpoint, containerId, renderFunction, callback) => {
        const container = document.getElementById(containerId);
        if (!container) return;
        const cacheKey = `wp_api_cache_${endpoint}`;
        const cacheDuration = 5 * 60 * 1000; // 5 menit

        try {
            const cachedItem = JSON.parse(sessionStorage.getItem(cacheKey));
            if (cachedItem && (Date.now() - cachedItem.timestamp < cacheDuration)) {
                setTimeout(() => { container.innerHTML = renderFunction(cachedItem.data); if (callback) callback(); }, 100);
                return;
            }
        } catch (e) { sessionStorage.removeItem(cacheKey); }

        try {
            const response = await fetch(`${baseApiUrl}${endpoint}`);
            if (!response.ok) throw new Error(`Network response error.`);
            const data = await response.json();
            
            if (data.length === 0) {
                container.innerHTML = `<div class="col-12"><p class="text-muted">Konten tidak tersedia.</p></div>`;
            } else {
                const itemToCache = { timestamp: Date.now(), data: data };
                sessionStorage.setItem(cacheKey, JSON.stringify(itemToCache));
                setTimeout(() => { container.innerHTML = renderFunction(data); if (callback) callback(); }, 350);
            }
        } catch (error) {
            console.error(`Fetch Error`, error);
            container.innerHTML = `<div class="col-12"><p class="text-danger">Gagal memuat konten.</p></div>`;
        }
    };

    const renderPages = (pages) => {
        return pages.map(page => `<a href="${page.link}" target="_blank" rel="noopener noreferrer" class="list-group-item list-group-item-action">${page.title.rendered}</a>`).join('');
    };

    const renderMedia = (media) => {
        return media.map(item => {
            if (item.media_type === 'image' && item.media_details?.sizes?.thumbnail) {
                const alt = item.alt_text || item.title.rendered;
                return `<div class="col"><a href="${item.source_url}" class="glightbox d-block" data-gallery="wp-gallery" title="${alt}"><img src="${item.media_details.sizes.thumbnail.source_url}" class="img-fluid rounded shadow-sm article-card-hover" alt="${alt}" loading="lazy" style="aspect-ratio:1/1;object-fit:cover"></a></div>`;
            } return '';
        }).join('');
    };

    // Panggil semua fungsi fetch
    fetchAndRender('/posts?per_page=4&_embed', 'wordpress-posts-container-index', (posts) => {
         return posts.map(post => {
            const img = post._embedded?.['wp:featuredmedia']?.[0]?.source_url || '<?php echo resolve_url("public/assets/images/default-placeholder.png"); ?>';
            const alt = post._embedded?.['wp:featuredmedia']?.[0]?.alt_text || post.title.rendered;
            const date = new Date(post.date).toLocaleDateString('id-ID', { day: 'numeric', month: 'short', year: 'numeric' });
            return `<div class="col d-flex"><div class="card h-100 article-card-hover"><a href="${post.link}" target="_blank" rel="noopener noreferrer"><img src="${img}" class="card-img-top custom-card-img" alt="${alt}" loading="lazy"></a><div class="card-body d-flex flex-column p-3"><h5 class="h6"><a href="${post.link}" target="_blank" rel="noopener noreferrer" class="text-decoration-none stretched-link">${post.title.rendered}</a></h5><div class="mt-auto pt-2"><small class="text-muted"><i class="bi bi-calendar3"></i> ${date}</small></div></div></div></div>`;
        }).join('');
    });
    fetchAndRender('/pages?per_page=5', 'wordpress-pages-container', renderPages);
    fetchAndRender('/media?per_page=8&media_type=image&_fields=id,source_url,media_type,title,alt_text,media_details', 'wordpress-media-container', renderMedia, () => {
        if (typeof GLightbox === 'function') GLightbox({ selector: '.glightbox' });
    });
});
</script>

<?php
require_once PROJECT_ROOT . '/public/includes/footer_public.php';
?>