<?php
// public/includes/header_public.php

// Inisialisasi dasar
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__, 2)); }

// Memuat file konfigurasi dan fungsi penting
if (file_exists(PROJECT_ROOT . '/config.php')) {
    require_once PROJECT_ROOT . '/config.php';
} else {
    require_once PROJECT_ROOT . '/includes/db_connect.php'; 
    require_once PROJECT_ROOT . '/admin/includes/functions.php';
}

global $pdo, $settings, $site_title, $meta_description;

// Ambil settings dari DB jika belum ada
if (!isset($settings) && isset($pdo)) {
    $settings = [];
    try {
        $stmt_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings");
        while ($row = $stmt_settings->fetch(PDO::FETCH_ASSOC)) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (\PDOException $e) { error_log("Error fetching settings: " . $e->getMessage()); }
}

// Ambil item menu dari database
$primary_menu_items = [];
if (isset($pdo)) {
    try {
        $stmt_menu_group = $pdo->prepare("SELECT id FROM portal_menus WHERE location = 'primary_nav' LIMIT 1");
        $stmt_menu_group->execute();
        if ($menu_group_id = $stmt_menu_group->fetchColumn()) {
            $stmt_items = $pdo->prepare("SELECT * FROM portal_menu_items WHERE menu_id = :menu_id ORDER BY parent_id ASC, item_order ASC");
            $stmt_items->execute([':menu_id' => $menu_group_id]);
            $raw_items = $stmt_items->fetchAll(PDO::FETCH_ASSOC);

            if (!function_exists('build_public_menu_tree')) {
                function build_public_menu_tree(array $elements, $parentId = null) {
                    $branch = []; foreach ($elements as $element) { if ($element['parent_id'] == $parentId) {
                    $children = build_public_menu_tree($elements, $element['id']);
                    if ($children) { $element['children'] = $children; } $branch[$element['id']] = $element; } } return $branch;
                }
            }
            $primary_menu_items = build_public_menu_tree($raw_items);
        }
    } catch (\PDOException $e) { error_log("Error fetching menu: " . $e->getMessage()); }
}

// Fungsi untuk render menu Bootstrap yang sudah ada
if (!function_exists('render_public_menu_items')) {
    function render_public_menu_items($items, $is_submenu = false) {
        $html = ''; if (empty($items)) return $html;
        $ul_class = $is_submenu ? 'dropdown-menu shadow-sm' : 'navbar-nav mx-auto mb-2 mb-lg-0';
        $ul_attributes = $is_submenu ? ' aria-labelledby="navbarDropdownMenuLink' . ($items[array_key_first($items)]['parent_id'] ?? rand()) . '"' : '';
        $html .= '<ul class="' . $ul_class . '"' . $ul_attributes . '>';
        foreach ($items as $item) {
            $has_children = !empty($item['children']);
            $li_class = 'nav-item' . ($has_children ? ' dropdown' : '');
            $a_class = $is_submenu ? 'dropdown-item' : 'nav-link px-lg-3' . ($has_children ? ' dropdown-toggle' : '');

            // Perbaikan Error basename() di dalam fungsi
            $current_page_path = $_SERVER['PHP_SELF'] ?? '';
            $menu_item_path = parse_url($item['url'], PHP_URL_PATH) ?? '';
            if (basename($current_page_path) == basename($menu_item_path)) {
                if(!$is_submenu) $a_class .= ' active';
            }

            $html .= '<li class="' . $li_class . '">';
            $item_url = esc_html((strpos($item['url'], 'http') === 0 || substr($item['url'], 0, 1) === '#') ? $item['url'] : resolve_url($item['url']));
            $html .= '<a class="' . $a_class . '" href="' . $item_url . '"';
            if ($has_children && !$is_submenu) { $html .= ' id="navbarDropdownMenuLink' . $item['id'] . '" role="button" data-bs-toggle="dropdown" aria-expanded="false"'; }
            if (!empty($item['target']) && $item['target'] === '_blank') { $html .= ' target="_blank" rel="noopener noreferrer"'; }
            $html .= '>' . esc_html($item['title']) . '</a>';
            if ($has_children) { $html .= render_public_menu_items($item['children'], true); }
            $html .= '</li>';
        } $html .= '</ul>'; return $html;
    }
}

// Variabel untuk tampilan
$current_theme = $_COOKIE['theme'] ?? 'light-theme'; 
$site_name_display = esc_html($settings['site_name'] ?? 'Universitas Graha Karya');
$site_logo_url_display = isset($settings['site_logo_url']) && !empty($settings['site_logo_url']) ? esc_html(resolve_url($settings['site_logo_url'])) : resolve_url('public/assets/images/logo_ugk.png');
$site_favicon_url_display = isset($settings['site_favicon_url']) && !empty($settings['site_favicon_url']) ? esc_html(resolve_url($settings['site_favicon_url'])) : resolve_url('public/assets/images/favicon.ico');
$page_title_display = isset($site_title) ? $site_title . ' - ' . $site_name_display : $site_name_display;
$page_meta_desc_display = isset($meta_description) ? $meta_description : esc_html($settings['site_tagline'] ?? 'Deskripsi default situs.');
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title_display; ?></title>
    <meta name="description" content="<?php echo $page_meta_desc_display; ?>">

    <link rel="icon" href="<?php echo $site_favicon_url_display; ?>" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/theme.css'); ?>">
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/style.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />
     <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,600;1,700&family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Raleway:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap" rel="stylesheet">

    <style> 
     
        body { padding-top: 0; } /* Reset padding-top karena header tidak lagi fixed-top */
        .header-logo-area { background-color: #fff; padding: 1.5rem 0; }
        .logo-title-container { display: flex; align-items: center; justify-content: center; }
        .logo-title-container img { max-height: 90px; margin-right: 25px; }
        .logo-title-container h1 {
            font-size: 2.8rem;
            color: #006400; /* Warna hijau UGK */
            font-weight: 700;
            margin: 0;
            line-height: 1.2;
        }
        .header-menu-area { background-color: #333; }
        .header-menu-area .navbar { background-color: transparent !important; }
        .header-menu-area .navbar-nav .nav-link {
            color: #fff !important;
            font-weight: 600;
            text-transform: uppercase;
            padding: 1rem 1.25rem;
            border-bottom: 3px solid transparent;
            transition: border-color 0.3s ease;
        }
        .header-menu-area .navbar-nav .nav-link:hover,
        .header-menu-area .navbar-nav .nav-link.active {
            color: #98fb98 !important; /* Hijau muda saat hover/aktif */
            border-bottom-color: #98fb98;
        }
        .navbar-toggler { border-color: rgba(255,255,255,0.5); }
        .navbar-toggler-icon { background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28255, 255, 255, 0.8%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e"); }

        @media (max-width: 991px) {
            .logo-title-container { flex-direction: column; text-align: center; }
            .logo-title-container img { margin-right: 0; margin-bottom: 15px; }
            .logo-title-container h1 { font-size: 2rem; }
            .navbar-collapse { background-color: #333; padding: 1rem; border-top: 1px solid #444; }
        }
        /* --- START: Chat Widget Styles --- */
    #chat-toggle-button {
      position: fixed;
      bottom: 20px;
      left: 20px;
      width: 60px; /* Size of the button */
      height: 60px;
      z-index: 1050; /* Ensure it's above most content */
      box-shadow: 0 2px 10px rgba(0,0,0,0.2); /* Add shadow */
      transition: transform 0.3s ease;
      border: none; /* Remove default button border if needed */
    }
    #chat-toggle-button:hover {
        transform: scale(1.1); /* Slight zoom on hover */
    }
    #chat-widget-container {
      position: fixed;
      bottom: 90px; /* Position above the toggle button */
      left: 20px;
      width: 370px; /* Width of the chat window */
      height: 550px; /* Height of the chat window */
      max-width: calc(100vw - 40px); /* Ensure it doesn't overflow viewport width */
      max-height: calc(100vh - 110px); /* Ensure it doesn't overflow viewport height */
      z-index: 1049; /* Below the button */
      border-radius: 15px; /* Rounded corners */
      overflow: hidden; /* Clip the iframe corners */
      box-shadow: 0 5px 15px rgba(0,0,0,0.3); /* Add shadow */
      background-color: #fff; /* Optional background */
      /* Initial state: hidden */
      opacity: 0;
      transform: translateY(20px) scale(0.95);
      transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0.3s; /* Delay visibility transition */
      visibility: hidden;
    }
    #chat-widget-container.show {
      opacity: 1;
      transform: translateY(0) scale(1);
      visibility: visible;
      transition: opacity 0.3s ease, transform 0.3s ease, visibility 0s linear 0s; /* Show immediately */
    }
    #chat-widget-container iframe {
      width: 100%;
      height: 100%;
      border: none; /* Remove iframe border */
    }
    /* --- END: Chat Widget Styles --- */
       
    </style>
</head>
<body class="<?php echo esc_html($current_theme); ?>">

    <header class="full-width-header">
        <div class="header-logo-area">
            <div class="container">
                <div class="logo-title-container">
                    <div class="logo-area">
                        <a href="<?= resolve_url('index.php') ?>">
                            <img src="<?= $site_logo_url_display ?>" alt="Logo UGK">
                        </a>
                    </div>
                    <div class="site-title-area">
                        <h1><?= $site_name_display ?></h1>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-menu-area shadow-sm">
            <nav class="navbar navbar-expand-lg">
                <div class="container">
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavPublic" aria-controls="navbarNavPublic" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarNavPublic">
                        <?php
                        if (!empty($primary_menu_items)) {
                            echo render_public_menu_items($primary_menu_items);
                        } else {
                            // Menu darurat (fallback) jika database kosong
                            $current_page_basename_header = basename($_SERVER['PHP_SELF'] ?? '');
                        ?>
                        <ul class="navbar-nav mx-auto mb-2 mb-lg-0">
                            <li class="nav-item"><a class="nav-link px-lg-3 <?php echo ($current_page_basename_header == 'index.php') ? 'active' : ''; ?>" href="<?php echo resolve_url('index.php'); ?>">Beranda</a></li>
                            <li class="nav-item"><a class="nav-link px-lg-3" href="#">Akademik</a></li>
                            <li class="nav-item"><a class="nav-link px-lg-3" href="<?php echo resolve_url('contact.php'); ?>">Kontak</a></li>
                        </ul>
                        <?php } ?>
                    </div>
                </div>
            </nav>
        </div>
        </header>

    <main id="main-content">
        