<?php
// public/includes/footer_public.php
global $pdo, $settings;

// Ambil Tautan Cepat untuk footer dari DB
$quick_links_footer = [];
if (isset($pdo)) {
    try {
        $stmt_ql = $pdo->prepare("SELECT title, url FROM portal_quick_links WHERE group_key = 'footer_links' AND is_active = 1 ORDER BY link_order ASC LIMIT 4");
        $stmt_ql->execute();
        $quick_links_footer = $stmt_ql->fetchAll(PDO::FETCH_ASSOC);
    } catch (\PDOException $e) {
        error_log("Error fetching footer quick links: " . $e->getMessage());
    }
}

// Fungsi helper jika belum didefinisikan
if (!function_exists('get_site_setting')) {
    function get_site_setting($key, $default = '') {
        global $settings;
        return $settings[$key] ?? $default;
    }
}
?>
    </main> <footer id="rs-footer" class="bg3 rs-footer footer-unsri-style" style="background-image: url('<?= resolve_url(get_site_setting('footer_bg_image_url', 'public/assets/images/image_0b26de.jpg')) ?>');">
        <div class="container">
            <div class="footer-top">
                <div class="row">
                    <div class="col-lg-6 col-md-12">
                        <h5 class="footer-title">KONTAK KAMI</h5>
                        <div class="about-widget">
                            <img src="<?= resolve_url(get_site_setting('site_logo_footer_url', 'public/assets/images/logo-ugk-putih.png')) ?>" alt="Logo Footer">
                            <ul class="sitemap-widget">
                                <li>
                                    <i class="fa fa-map-marker" aria-hidden="true"></i>
                                    <span><?= nl2br(esc_html(get_site_setting('address', 'Alamat lengkap universitas belum diatur.'))) ?></span>
                                </li>
                                <li>
                                    <i class="fa fa-phone" aria-hidden="true"></i>
                                    <span><?= esc_html(get_site_setting('contact_phone_display', 'Telepon belum diatur.')) ?></span>
                                </li>
                                <li>
                                    <i class="fa fa-envelope-o" aria-hidden="true"></i>
                                    <a href="mailto:<?= esc_html(get_site_setting('contact_email', '#')) ?>"><?= esc_html(get_site_setting('contact_email', 'Email belum diatur.')) ?></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <h5 class="footer-title">LOKASI KAMPUS</h5>
                         <ul class="sitemap-widget">
                            <?php if (!empty($quick_links_footer)): ?>
                                <?php foreach ($quick_links_footer as $link): ?>
                                    <li><a href="<?= esc_html($link['url']) ?>"><i class="fa fa-angle-right" aria-hidden="true"></i><?= esc_html($link['title']) ?></a></li>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <li><a href="#"><i class="fa fa-angle-right" aria-hidden="true"></i>Kampus Utama</a></li>
                                <li><a href="#"><i class="fa fa-angle-right" aria-hidden="true"></i>Kampus Pascasarjana</a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
             <div class="footer-share">
                <ul>
                    <?php if(!empty($settings['social_facebook_url'])): ?><li><a href="<?= esc_html($settings['social_facebook_url']) ?>" target="_blank"><i class="fa fa-facebook"></i></a></li><?php endif; ?>
                    <?php if(!empty($settings['social_twitter_url'])): ?><li><a href="<?= esc_html($settings['social_twitter_url']) ?>" target="_blank"><i class="fa fa-twitter"></i></a></li><?php endif; ?>
                    <?php if(!empty($settings['social_instagram_url'])): ?><li><a href="<?= esc_html($settings['social_instagram_url']) ?>" target="_blank"><i class="fa fa-instagram"></i></a></li><?php endif; ?>
                    <?php if(!empty($settings['social_youtube_url'])): ?><li><a href="<?= esc_html($settings['social_youtube_url']) ?>" target="_blank"><i class="fa fa-youtube"></i></a></li><?php endif; ?>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="copyright">
                    <p><?= esc_html(get_site_setting('footer_copyright_text', 'Copyright © ' . date("Y") . ' ' . get_site_setting('site_name', 'Universitas Anda'))) ?></p>
                </div>
            </div>
        </div>
    </footer>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    
    <script src="<?php echo resolve_url('public/assets/js/main.js'); ?>"></script>

</body>
</html>