<?php
// public/includes/footer_public.php (Versi Final Lengkap & Dinamis)

global $pdo, $settings, $all_menus;

// Fallback untuk memastikan variabel menu ada, meskipun tidak digunakan di footer ini
if (!isset($all_menus) && isset($pdo)) {
    if (function_exists('get_all_public_menus')) {
        $all_menus = get_all_public_menus($pdo);
    }
}

// Logika untuk Latar Belakang Footer Dinamis
$default_footer_bg = resolve_url('public/assets/images/background-footer.jpg');
// $footer_bg_url_from_db = $settings['footer_background_url'] ?? null;
// Atur style awal, utamakan dari DB atau gunakan fallback
$footer_bg_style = 'background-image: url(\'' . ($footer_bg_url_from_db ? resolve_url($footer_bg_url_from_db) : $default_footer_bg) . '\');';

?>
</main> <footer id="footer" class="footer" 
        style="<?php echo $footer_bg_style; ?>"
        <?php
        // Tambahkan atribut data-wp-api jika tidak ada background dari DB, agar JS bisa mengambil dari WP
        if (!$footer_bg_url_from_db) {
            // echo 'data-wp-api-bg="https://wp.ugkmb.ac.id/wp-json/wp/v2/media?per_page=20&media_type=image"';
            echo ' data-fallback-bg="' . $default_footer_bg . '"';
        }
        ?>>
    
    <div class="footer-overlay"></div> <div class="footer-top">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-4 col-md-12 footer-info">
                    <a href="<?php echo resolve_url('index.php'); ?>" class="logo d-flex align-items-center">
                        <img src="<?php echo resolve_url($settings['site_logo_url'] ?? 'public/assets/images/logo_ugk.png'); ?>" alt="Logo UGKMB">
                        
                    </a>
                    <p><?php echo esc_html($settings['site_tagline'] ?? 'Mencetak generasi unggul, kreatif, dan berkarakter.'); ?></p>
                    <div class="social-links mt-3">
                        <a href="<?php echo esc_html($settings['social_twitter_url'] ?? '#'); ?>" class="twitter" target="_blank" rel="noopener noreferrer"><i class="fab fa-twitter"></i></a>
                        <a href="<?php echo esc_html($settings['social_facebook_url'] ?? '#'); ?>" class="facebook" target="_blank" rel="noopener noreferrer"><i class="fab fa-facebook"></i></a>
                        <a href="<?php echo esc_html($settings['social_instagram_url'] ?? '#'); ?>" class="instagram" target="_blank" rel="noopener noreferrer"><i class="fab fa-instagram"></i></a>
                        <a href="<?php echo esc_html($settings['social_youtube_url'] ?? '#'); ?>" class="youtube" target="_blank" rel="noopener noreferrer"><i class="fab fa-youtube"></i></a>
                    </div>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>Tautan Berguna</h4>
                    <ul id="footer-pages-links">
                        <li><div class="skeleton-text-footer"></div></li>
                        <li><div class="skeleton-text-footer"></div></li>
                        <li><div class="skeleton-text-footer"></div></li>
                        <li><div class="skeleton-text-footer"></div></li>
                    </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>Info Terbaru</h4>
                     <ul id="footer-posts-links">
                        <li><div class="skeleton-text-footer"></div></li>
                        <li><div class="skeleton-text-footer"></div></li>
                        <li><div class="skeleton-text-footer"></div></li>
                        <li><div class="skeleton-text-footer"></div></li>
                    </ul>
                </div>

                <div class="col-lg-4 col-md-12 footer-contact text-center text-md-start">
                    <h4>Hubungi Kami</h4>
                    <p>
                        <strong>Alamat:</strong><br>
                        <?php echo esc_html($settings['contact_address'] ?? 'Jl. Jenderal Sudirman, Kompleks Perkantoran'); ?><br>
                        <?php echo esc_html($settings['contact_city_province'] ?? 'Muara Bulian, Jambi'); ?><br><br>
                        <strong>Telepon:</strong> <?php echo esc_html($settings['contact_phone'] ?? '(0743) 123-456'); ?><br>
                        <strong>Email:</strong> <?php echo esc_html($settings['contact_email'] ?? 'info@ugkmb.ac.id'); ?><br>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="copyright">
            &copy; Hak Cipta <strong> <a href="http://mitrautamateknologi.co-id.id">CV MUT</a></strong> <?php echo date('Y'); ?>.
        </div>
    </div>
</footer>
<!--<button id="chat-toggle-button" title="Buka Chat">-->
<!--    <i class="fas fa-comments"></i>-->
<!--</button>-->
<!--<div id="chat-widget-container">-->
<!--    <iframe src="https://ugkmb.ac.id/public/ai.php" title="Chat Widget"></iframe>-->
<!--</div>-->

<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/68b5b2df109d7be2aa212021/1j42s5f5o';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->

<a href="#" class="scroll-to-top d-flex align-items-center justify-content-center"><i class="fas fa-arrow-up"></i></a>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<script src="<?php echo resolve_url('public/assets/js/main.js'); ?>"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    // Inisialisasi AOS (Animasi saat scroll)
    AOS.init({
        duration: 1000,
        once: true,
    });
    
    /**
     * Fungsi untuk mengambil data dari API dan merendernya ke elemen HTML
     */
    const fetchAndRenderFooterLinks = async (endpoint, containerId) => {
        const container = document.getElementById(containerId);
        if (!container) return;

        try {
            const response = await fetch(endpoint);
            if (!response.ok) throw new Error('Network response was not ok');
            const data = await response.json();
            
            if (data.length > 0) {
                let html = '';
                data.forEach(item => {
                    html += `<li><i class="fas fa-chevron-right"></i> <a href="${item.link}" target="_blank" rel="noopener noreferrer">${item.title.rendered}</a></li>`;
                });
                container.innerHTML = html;
            } else {
                container.innerHTML = '<li><span class="text-white-50 small">Tidak ada tautan.</span></li>';
            }
        } catch (error) {
            console.error(`Gagal memuat data untuk ${containerId}:`, error);
            container.innerHTML = '<li><span class="text-white-50 small">Gagal memuat.</span></li>';
        }
    };

    // Panggil fungsi untuk mengisi menu footer dari WordPress
    fetchAndRenderFooterLinks('https://wp.ugkmb.ac.id/wp-json/wp/v2/pages?per_page=5&orderby=menu_order&order=asc', 'footer-pages-links');
    fetchAndRenderFooterLinks('https://wp.ugkmb.ac.id/wp-json/wp/v2/posts?per_page=5', 'footer-posts-links');

    /**
     * Fungsi untuk mengambil dan mengatur background footer dari WP Media jika tidak ada dari DB
     */
    const setFooterBackgroundFromApi = async () => {
        const footer = document.getElementById('footer');
        const apiUrl = footer.getAttribute('data-wp-api-bg');
        
        if (!apiUrl) return; // Keluar jika atribut tidak ada (artinya BG sudah diatur dari DB)

        try {
            const response = await fetch(apiUrl);
            if (!response.ok) throw new Error('Network response was not ok');
            const media = await response.json();
            
            if (media.length > 0) {
                const randomImage = media[Math.floor(Math.random() * media.length)];
                if (randomImage.source_url) {
                    footer.style.backgroundImage = `url('${randomImage.source_url}')`;
                }
            }
        } catch (error) {
            console.error('Gagal mengambil background footer dari WordPress, menggunakan fallback:', error);
            // Biarkan gambar fallback dari CSS
        }
    };

    setFooterBackgroundFromApi();

});
</script>
</body>
</html>