<?php
// public/gallery.php (FINAL HYBRID VERSION)
// Displays local albums first, then adds a dynamic media gallery from WordPress.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
$project_root = dirname(__DIR__);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php'; // For resolve_url, esc_html

$site_title = "Galeri Foto & Video";
$meta_description = "Kumpulan album foto dan video kegiatan di UGKMB, serta galeri media terbaru.";

// ======================================================================
// KODE ASLI UNTUK MENGAMBIL ALBUM DARI DATABASE LOKAL (TIDAK DIUBAH)
// ======================================================================
$albums = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT ga.id, ga.title, ga.slug, ga.description, ga.cover_image_url, ga.album_date, 
                                  (SELECT COUNT(gi.id) FROM portal_gallery_items gi WHERE gi.album_id = ga.id) as item_count
                             FROM portal_gallery_albums ga
                             WHERE ga.is_published = 1
                             ORDER BY ga.album_date DESC, ga.created_at DESC");
        $albums = $stmt->fetchAll();
    } catch (\PDOException $e) {
        error_log("Error fetching gallery albums list: " . $e->getMessage());
    }
}

require_once $project_root . '/public/includes/header_public.php';
?>

<style>
    :root {
        --card-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        --card-shadow-hover: 0 8px 25px rgba(0, 0, 0, 0.1);
        --card-border-radius: 0.75rem;
        --transition-speed: 0.3s;
    }
    .gallery-album-card {
        border-radius: var(--card-border-radius);
        transition: box-shadow var(--transition-speed) ease, transform var(--transition-speed) ease;
        box-shadow: var(--card-shadow);
        border: none;
    }
    .gallery-album-card:hover {
        transform: translateY(-5px);
        box-shadow: var(--card-shadow-hover);
    }
    .gallery-album-cover {
        transition: transform var(--transition-speed) ease;
    }
    .gallery-album-card:hover .gallery-album-cover {
        transform: scale(1.05);
    }
    .wp-gallery-item img {
        aspect-ratio: 1 / 1;
        object-fit: cover;
        width: 100%;
        border-radius: var(--card-border-radius);
        transition: transform var(--transition-speed) ease, box-shadow var(--transition-speed) ease;
        box-shadow: var(--card-shadow);
    }
    .wp-gallery-item img:hover {
        transform: scale(1.03);
        box-shadow: var(--card-shadow-hover);
    }

    /* Skeleton Loader Styles */
    @keyframes skeleton-loading {
        0% { background-color: hsl(200, 20%, 80%); }
        100% { background-color: hsl(200, 20%, 95%); }
    }
    .skeleton {
        animation: skeleton-loading 1.5s linear infinite alternate;
        border-radius: var(--card-border-radius);
    }
</style>

<main class="container py-5">
    <header class="mb-5 text-center">
        <h1 class="display-4 fw-bold"><?php echo $site_title; ?></h1>
        <p class="lead text-muted"><?php echo $meta_description; ?></p>
    </header>

    <?php if (!empty($albums)): ?>
    <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 g-4">
        <?php foreach ($albums as $album): ?>
        <div class="col">
            <div class="card h-100 border-0 gallery-album-card">
                <a href="<?php echo resolve_url('album.php?slug=' . esc_html($album['slug'])); ?>" class="text-decoration-none overflow-hidden" style="border-top-left-radius: var(--card-border-radius); border-top-right-radius: var(--card-border-radius);">
                    <?php if (!empty($album['cover_image_url'])): ?>
                        <img src="<?php echo resolve_url(esc_html($album['cover_image_url'])); ?>" class="card-img-top gallery-album-cover" alt="Cover <?php echo esc_html($album['title']); ?>" style="height: 220px; object-fit: cover;">
                    <?php else: ?>
                        <div class="bg-secondary text-white d-flex align-items-center justify-content-center gallery-album-placeholder" style="height: 220px;">
                            <i class="fas fa-images fa-3x"></i>
                        </div>
                    <?php endif; ?>
                </a>
                <div class="card-body">
                    <h5 class="card-title mb-1">
                        <a href="<?php echo resolve_url('album.php?slug=' . esc_html($album['slug'])); ?>" class="text-decoration-none stretched-link album-title-link">
                            <?php echo esc_html($album['title']); ?>
                        </a>
                    </h5>
                    <?php if ($album['album_date']): ?>
                    <p class="card-text small text-muted mb-2"><i class="fas fa-calendar-alt me-1"></i><?php echo date('d F Y', strtotime($album['album_date'])); ?></p>
                    <?php endif; ?>
                </div>
                <div class="card-footer bg-transparent border-top-0 text-muted small">
                    <?php echo esc_html($album['item_count']); ?> item
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php else: ?>
    <div class="alert alert-info text-center" role="alert">
        Tidak ada album galeri yang tersedia saat ini di portal ini.
    </div>
    <?php endif; ?>

    <hr class="my-5">

    <section id="wordpress-gallery-section">
        <header class="mb-5 text-center">
            <h2 class="fw-bold custom-page-title">Galeri Media dari Situs Utama</h2>
            <p class="lead text-muted">Kumpulan gambar terbaru dari Media Library WordPress.</p>
        </header>

        <div id="wordpress-media-container" class="row row-cols-2 row-cols-sm-3 row-cols-md-4 g-3">
            <script>
                for(let i = 0; i < 12; i++) {
                    document.write(`
                        <div class="col" aria-hidden="true">
                            <div class="skeleton" style="aspect-ratio: 1/1;"></div>
                        </div>
                    `);
                }
            </script>
        </div>
    </section>
</main>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    const baseApiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2';
    const mediaContainer = document.getElementById('wordpress-media-container');

    const renderMedia = (media) => {
        return media.map(item => {
            // Pastikan item adalah gambar dan memiliki thumbnail
            if (item.media_type === 'image' && item.media_details?.sizes?.medium_large) {
                const thumbnailUrl = item.media_details.sizes.medium_large.source_url;
                const fullUrl = item.source_url;
                const altText = item.alt_text || item.title.rendered;

                return `
                    <div class="col wp-gallery-item">
                        <a href="${fullUrl}" target="_blank" rel="noopener noreferrer" data-bs-toggle="tooltip" title="${item.title.rendered}">
                            <img src="${thumbnailUrl}" alt="${altText}" loading="lazy">
                        </a>
                    </div>`;
            }
            return '';
        }).join('');
    };

    const fetchAndRender = async () => {
        if (!mediaContainer) return;

        try {
            // Mengambil 12 item gambar terbaru
            const response = await fetch(`${baseApiUrl}/media?per_page=12&media_type=image`);
            if (!response.ok) throw new Error('Gagal mengambil data dari WordPress.');
            
            const data = await response.json();
            
            if (data.length === 0) {
                mediaContainer.innerHTML = `<div class="col-12"><p class="text-muted text-center fst-italic">Tidak ada media yang bisa ditampilkan.</p></div>`;
            } else {
                // Beri jeda agar skeleton terlihat, lalu ganti dengan konten
                setTimeout(() => {
                    mediaContainer.innerHTML = renderMedia(data);
                    // Inisialisasi tooltip Bootstrap setelah gambar dimuat
                    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                        return new bootstrap.Tooltip(tooltipTriggerEl);
                    });
                }, 350);
            }
        } catch (error) {
            console.error("Error fetching WordPress media:", error);
            mediaContainer.innerHTML = `<div class="col-12"><p class="text-danger text-center fst-italic">Gagal memuat galeri dari situs utama.</p></div>`;
        }
    };

    // Panggil fungsi untuk memulai proses
    fetchAndRender();
});
</script>

<?php
require_once $project_root . '/includes/footer_public.php';
?>