<?php
// public/event.php (Detail of a single event)
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
$project_root = dirname(__DIR__);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php'; // For resolve_url, esc_html

$event_slug = $_GET['slug'] ?? null;
$event_data = null;
$site_title = "Detail Acara";
$meta_description = "Informasi detail mengenai acara.";

if (empty($event_slug)) {
    http_response_code(404);
    set_flash_message('danger', 'Acara tidak ditemukan (slug kosong).');
    // header("Location: " . resolve_url('events.php')); // Redirect to events list
    // exit;
    $site_title = "Acara Tidak Ditemukan";
}

if (isset($pdo) && !empty($event_slug)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_events 
                               WHERE slug = :slug AND is_published = 1 
                               LIMIT 1");
        // AND (start_date IS NULL OR start_date <= NOW()) -- Consider if past events should be viewable by direct link
        $stmt->bindParam(':slug', $event_slug);
        $stmt->execute();
        $event_data = $stmt->fetch();

        if ($event_data) {
            $site_title = esc_html($event_data['title']);
            $meta_description = !empty($event_data['description_html']) ? esc_html(substr(strip_tags($event_data['description_html']), 0, 160)) : "Detail acara " . esc_html($event_data['title']);
        } else {
            http_response_code(404);
            $site_title = "Acara Tidak Ditemukan";
            $meta_description = "Acara yang Anda cari tidak ditemukan atau belum dipublikasikan.";
        }
    } catch (\PDOException $e) {
        error_log("Error fetching event detail: " . $e->getMessage());
        http_response_code(500);
        $site_title = "Kesalahan Server";
        $meta_description = "Terjadi kesalahan saat memuat detail acara.";
    }
}

// Fetch global settings for header/footer
$settings = []; // Will be populated by header_public.php
$theme = $_COOKIE['theme'] ?? 'light-theme'; // For body class

// Include header
require_once $project_root . '/includes/header_public.php';
?>

<main class="container py-5">
    <div class="row">
        <div class="col-lg-10 mx-auto">
            <?php if ($event_data): ?>
                <article class="event-detail-article">
                    <header class="mb-4">
                        <h1 class="display-5 fw-bold event-title"><?php echo esc_html($event_data['title']); ?></h1>
                        <hr>
                        <div class="row g-3 text-muted event-meta">
                            <div class="col-md-6">
                                <p class="mb-1"><i class="fas fa-calendar-alt fa-fw me-2"></i><strong>Mulai:</strong> <?php echo date('d F Y, H:i', strtotime($event_data['start_datetime'])); ?></p>
                                <?php if ($event_data['end_datetime']): ?>
                                <p class="mb-1"><i class="fas fa-calendar-check fa-fw me-2"></i><strong>Selesai:</strong> <?php echo date('d F Y, H:i', strtotime($event_data['end_datetime'])); ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <?php if (!empty($event_data['location'])): ?>
                                <p class="mb-1"><i class="fas fa-map-marker-alt fa-fw me-2"></i><strong>Lokasi:</strong> <?php echo esc_html($event_data['location']); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($event_data['organizer'])): ?>
                                <p class="mb-1"><i class="fas fa-sitemap fa-fw me-2"></i><strong>Penyelenggara:</strong> <?php echo esc_html($event_data['organizer']); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                         <?php if (!empty($event_data['contact_person']) || !empty($event_data['contact_email']) || !empty($event_data['contact_phone'])): ?>
                        <div class="mt-3 pt-3 border-top">
                            <h5 class="mb-2">Informasi Kontak:</h5>
                            <ul class="list-unstyled">
                                <?php if (!empty($event_data['contact_person'])): ?>
                                    <li><i class="fas fa-user fa-fw me-2"></i><?php echo esc_html($event_data['contact_person']); ?></li>
                                <?php endif; ?>
                                <?php if (!empty($event_data['contact_email'])): ?>
                                    <li><i class="fas fa-envelope fa-fw me-2"></i><a href="mailto:<?php echo esc_html($event_data['contact_email']); ?>"><?php echo esc_html($event_data['contact_email']); ?></a></li>
                                <?php endif; ?>
                                <?php if (!empty($event_data['contact_phone'])): ?>
                                    <li><i class="fas fa-phone fa-fw me-2"></i><?php echo esc_html($event_data['contact_phone']); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </header>

                    <?php if (!empty($event_data['featured_image_url'])): ?>
                    <figure class="mb-4 text-center">
                        <img class="img-fluid rounded shadow-sm" src="<?php echo resolve_url(esc_html($event_data['featured_image_url'])); ?>" alt="<?php echo esc_html($event_data['title']); ?>" style="max-height: 500px;">
                    </figure>
                    <?php endif; ?>

                    <section class="mb-5 event-content-section entry-content">
                        <?php echo $event_data['description_html']; // Output HTML content, ensure sanitized on input ?>
                    </section>

                    <?php if (!empty($event_data['event_url'])): ?>
                    <div class="text-center mt-4 mb-5">
                        <a href="<?php echo esc_html($event_data['event_url']); ?>" class="btn btn-primary btn-lg" target="_blank" rel="noopener noreferrer">
                            <i class="fas fa-external-link-alt me-2"></i>Kunjungi Link Acara/Pendaftaran
                        </a>
                    </div>
                    <?php endif; ?>
                    
                    <hr>
                    <div class="text-center">
                         <a href="<?php echo resolve_url('events.php'); ?>" class="btn btn-outline-secondary"><i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar Acara</a>
                    </div>

                </article>
            <?php else: ?>
                <div class="alert alert-warning text-center" role="alert">
                    <h4 class="alert-heading">Acara Tidak Ditemukan</h4>
                    <p><?php echo $meta_description; ?></p>
                    <hr>
                    <p class="mb-0">Silakan kembali ke <a href="<?php echo resolve_url('events.php'); ?>" class="alert-link">daftar acara</a>.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php
require_once $project_root . '/includes/footer_public.php';
?>
