<?php
// public/berita.php

// Inisialisasi dasar dan koneksi database
require_once dirname(__DIR__) . '/config.php';

// Pengaturan untuk header halaman
$site_title = "Berita Terbaru";
$meta_description = "Kumpulan berita dan informasi terbaru dari Universitas Graha Karya Muara Bulian yang diambil dari situs WordPress kami.";

// Memuat header publik
require_once PROJECT_ROOT . '/public/includes/header_public.php';
?>

<div class="container py-5">
    <header class="mb-5 text-center">
        <h1 class="display-4 fw-bold">Berita & Informasi</h1>
        <p class="lead text-muted">Informasi terbaru dari situs WordPress kami.</p>
    </header>

    <div id="posts-container" class="row gy-4">
        <div id="loading-indicator" class="text-center">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Memuat...</span>
            </div>
            <p class="mt-2">Memuat postingan...</p>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // URL endpoint REST API WordPress Anda
    // Ganti 'https://ugkmb.ac.id' jika domain WordPress Anda berbeda
    const apiUrl = 'https://wp.ugkmb.ac.id/wp-json/wp/v2/posts?per_page=9&_embed';

    const postsContainer = document.getElementById('posts-container');
    const loadingIndicator = document.getElementById('loading-indicator');

    async function ambilPostinganWordPress() {
        try {
            const response = await fetch(apiUrl);
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            const posts = await response.json();

            // Sembunyikan indikator loading
            loadingIndicator.style.display = 'none';

            if (posts.length === 0) {
                postsContainer.innerHTML = '<p class="text-center text-muted">Belum ada postingan yang dapat ditampilkan.</p>';
                return;
            }

            // Loop setiap postingan dan tampilkan
            posts.forEach(post => {
                // Ekstrak gambar unggulan dari _embedded
                const featuredImage = post._embedded?.['wp:featuredmedia']?.[0]?.source_url || 'public/assets/images/default-placeholder.png'; // Ganti dengan gambar placeholder jika ada

                const postElement = document.createElement('div');
                postElement.classList.add('col-md-6', 'col-lg-4');

                postElement.innerHTML = `
                    <div class="card h-100 shadow-sm border-0 article-card-hover">
                        <a href="${post.link}" target="_blank" rel="noopener noreferrer">
                            <img src="${featuredImage}" class="card-img-top" alt="${post.title.rendered}" style="height: 200px; object-fit: cover;">
                        </a>
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title mb-2">
                                <a href="${post.link}" target="_blank" rel="noopener noreferrer" class="text-decoration-none stretched-link article-title-link">${post.title.rendered}</a>
                            </h5>
                            <div class="card-text small text-muted mb-2">
                                <i class="fas fa-calendar-alt me-1"></i>
                                ${new Date(post.date).toLocaleDateString('id-ID', { day: 'numeric', month: 'long', year: 'numeric' })}
                            </div>
                            <div class="card-text flex-grow-1 mb-3 article-excerpt">
                                ${post.excerpt.rendered}
                            </div>
                        </div>
                    </div>
                `;
                postsContainer.appendChild(postElement);
            });

        } catch (error) {
            console.error('Gagal mengambil data dari WordPress:', error);
            loadingIndicator.style.display = 'none';
            postsContainer.innerHTML = '<div class="alert alert-danger">Maaf, tidak dapat memuat postingan saat ini. Silakan coba lagi nanti.</div>';
        }
    }

    // Panggil fungsi untuk memulai proses
    ambilPostinganWordPress();
});
</script>

<?php
// Memuat footer publik
require_once PROJECT_ROOT . '/public/includes/footer_public.php';
?>