<?php
// public/ajax_search_handler.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
header('Content-Type: application/json');

$project_root = dirname(__DIR__);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php'; // Untuk esc_html, resolve_url

$response = ['success' => false, 'message' => 'Parameter pencarian tidak valid.'];

$search_query = trim($_GET['q'] ?? '');
$limit = isset($_GET['limit']) ? max(1, (int)$_GET['limit']) : 10;
$page = isset($_GET['page']) ? max(1, (int)$_GET['page']) : 1;
$offset = ($page - 1) * $limit;

if (!isset($pdo)) {
    $response['message'] = 'Koneksi database gagal.';
    echo json_encode($response);
    exit;
}

if (empty($search_query)) {
    $response['message'] = 'Kata kunci pencarian tidak boleh kosong.';
    $response['results_articles'] = [];
    $response['total_articles_found'] = 0;
    // $response['success'] = true; // Bisa diset true agar frontend menampilkan pesan ini
    echo json_encode($response);
    exit;
}

try {
    $search_term_like = "%" . $search_query . "%";
    // Untuk FTS, siapkan search term (misalnya, tambahkan '*' untuk boolean mode jika kata tidak lengkap)
    // Untuk natural language mode, query asli biasanya cukup.
    // Jika menggunakan boolean mode, Anda mungkin ingin memproses $search_query, misal:
    // $search_query_fts = "";
    // $words = preg_split('/\s+/', $search_query, -1, PREG_SPLIT_NO_EMPTY);
    // foreach ($words as $word) {
    //    $search_query_fts .= "+".$word."* "; // Semua kata harus ada, dengan wildcard di akhir
    // }
    // $search_query_fts = trim($search_query_fts);
    // Untuk kesederhanaan, kita akan gunakan natural language mode atau boolean mode sederhana.
    $search_query_fts = $search_query; // Untuk NATURAL LANGUAGE MODE atau basic BOOLEAN MODE


    // --- Count total matching articles ---
    // Menggunakan MATCH() AGAINST() untuk artikel, dan LIKE untuk kategori/tag
    $sql_count_articles = "SELECT COUNT(DISTINCT a.id) 
                           FROM portal_articles a
                           LEFT JOIN portal_categories cat ON a.category_id = cat.id
                           LEFT JOIN portal_article_tag pat ON a.id = pat.article_id
                           LEFT JOIN portal_tags t ON pat.tag_id = t.id
                           WHERE a.status = 'published' AND a.published_at <= NOW()
                           AND (
                                MATCH(a.title, a.content_html, a.excerpt) AGAINST (:search_query_fts IN NATURAL LANGUAGE MODE)
                                OR cat.name LIKE :search_like_cat 
                                OR t.name LIKE :search_like_tag
                           )";
    $stmt_count_articles = $pdo->prepare($sql_count_articles);
    $stmt_count_articles->bindParam(':search_query_fts', $search_query_fts, PDO::PARAM_STR);
    $stmt_count_articles->bindParam(':search_like_cat', $search_term_like, PDO::PARAM_STR);
    $stmt_count_articles->bindParam(':search_like_tag', $search_term_like, PDO::PARAM_STR);
    $stmt_count_articles->execute();
    $total_articles_found = (int)$stmt_count_articles->fetchColumn();

    $results_articles = [];
    if ($total_articles_found > 0) {
        // Tambahkan relevance score untuk ordering jika menggunakan FTS
        $sql_articles = "SELECT DISTINCT a.id, a.title, a.slug, a.excerpt, a.content_html, 
                                a.featured_image_url, a.published_at, 
                                c.name as category_name, c.slug as category_slug,
                                MATCH(a.title, a.content_html, a.excerpt) AGAINST (:search_query_fts_main IN NATURAL LANGUAGE MODE) as relevance_score
                         FROM portal_articles a
                         LEFT JOIN portal_categories c ON a.category_id = c.id
                         LEFT JOIN portal_article_tag pat ON a.id = pat.article_id
                         LEFT JOIN portal_tags t ON pat.tag_id = t.id
                         WHERE a.status = 'published' AND a.published_at <= NOW()
                         AND (
                            MATCH(a.title, a.content_html, a.excerpt) AGAINST (:search_query_fts_where IN NATURAL LANGUAGE MODE)
                            OR c.name LIKE :search_like_cat_main
                            OR t.name LIKE :search_like_tag_main
                         )
                         ORDER BY relevance_score DESC, a.published_at DESC
                         LIMIT :limit OFFSET :offset";
        
        $stmt_articles = $pdo->prepare($sql_articles);
        $stmt_articles->bindParam(':search_query_fts_main', $search_query_fts, PDO::PARAM_STR);
        $stmt_articles->bindParam(':search_query_fts_where', $search_query_fts, PDO::PARAM_STR);
        $stmt_articles->bindParam(':search_like_cat_main', $search_term_like, PDO::PARAM_STR);
        $stmt_articles->bindParam(':search_like_tag_main', $search_term_like, PDO::PARAM_STR);
        $stmt_articles->bindParam(':limit', $limit, PDO::PARAM_INT);
        $stmt_articles->bindParam(':offset', $offset, PDO::PARAM_INT);
        $stmt_articles->execute();
        $fetched_articles = $stmt_articles->fetchAll(PDO::FETCH_ASSOC);

        foreach ($fetched_articles as $article) {
            $content_to_excerpt = !empty($article['excerpt']) ? $article['excerpt'] : ($article['content_html'] ?? '');
            $clean_excerpt = strip_tags($content_to_excerpt);
            // Buat excerpt yang lebih pendek untuk tampilan AJAX
            $article['excerpt_display'] = substr($clean_excerpt, 0, 150) . (strlen($clean_excerpt) > 150 ? '...' : '');
            $results_articles[] = $article;
        }
    }

    $response['success'] = true;
    $response['message'] = 'Pencarian berhasil.';
    $response['results_articles'] = $results_articles;
    $response['total_articles_found'] = $total_articles_found;
    $response['limit'] = $limit;
    $response['current_page'] = $page;
    $response['base_url'] = (defined('BASE_URL') ? rtrim(BASE_URL, '/') . '/' : ''); 

} catch (\PDOException $e) {
    error_log("AJAX Search Error for query '{$search_query}': " . $e->getMessage());
    $response['message'] = 'Terjadi kesalahan teknis saat memproses pencarian Anda.';
    // $response['error_detail'] = $e->getMessage(); // JANGAN tampilkan detail error ke client di production
}

echo json_encode($response);
exit;
?>