<?php
// /includes/header_public.php

// Pastikan USE_TAILWIND_CDN_HEADER didefinisikan (fallback jika tidak ada di config)
// Untuk skenario ini, kita ingin header Bootstrap aktif, jadi pastikan ini false.
if (!defined('USE_TAILWIND_CDN_HEADER')) {
    define('USE_TAILWIND_CDN_HEADER', false); // Atau pastikan ini false di config.php
}

if (USE_TAILWIND_CDN_HEADER) {
    // BAGIAN HEADER TAILWIND (Tidak kita fokuskan sekarang, tapi harus ada)
    // ... (Kode header Tailwind Anda dari prompt sebelumnya ada di sini) ...
    // Pastikan ada penutup tag PHP jika ini adalah file PHP murni
    /*
    Contoh placeholder untuk bagian Tailwind:
    ?>
    <!DOCTYPE html>
    <html lang="id" id="htmlRoot">
    <head>
        <title>Tailwind Header</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"/>
        <script>
            // Fungsi applyThemePreference dari skrip Tailwind Anda
            function applyThemePreference(theme) {
                const htmlEl = document.getElementById('htmlRoot');
                const isDark = (theme === 'dark') || (theme === 'system' && window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches);
                if (isDark) { htmlEl.classList.add('dark'); } else { htmlEl.classList.remove('dark'); }
                localStorage.setItem('theme_preference', theme);
                document.cookie = "theme_preference=" + theme + ";path=/;max-age=" + (60*60*24*30) + ";SameSite=Lax";

                // Update ikon untuk Tailwind (contoh)
                const lightIcon = document.querySelector('.theme-icon-light'); // Selector untuk ikon sun Tailwind
                const darkIcon = document.querySelector('.theme-icon-dark');   // Selector untuk ikon moon Tailwind
                if (lightIcon && darkIcon) {
                    if (isDark) {
                        lightIcon.classList.remove('hidden');
                        darkIcon.classList.add('hidden');
                    } else {
                        lightIcon.classList.add('hidden');
                        darkIcon.classList.remove('hidden');
                    }
                }
            }
            const initialTheme = localStorage.getItem('theme_preference') || 'system';
            applyThemePreference(initialTheme);
            if (initialTheme === 'system') {
                window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', event => {
                    if (localStorage.getItem('theme_preference') === 'system') { applyThemePreference('system'); }
                });
            }
        </script>
    </head>
    <body class="bg-white dark:bg-gray-900">
        <header class="bg-gray-100 dark:bg-gray-800 p-4">
            <div class="container mx-auto flex justify-between items-center">
                <a href="#" class="text-xl font-bold text-blue-600 dark:text-blue-400">Logo (Tailwind)</a>
                <nav>
                    <a href="#" class="px-3 py-2 text-gray-700 dark:text-gray-300">Home</a>
                    <a href="#" class="px-3 py-2 text-gray-700 dark:text-gray-300">About</a>
                </nav>
                <div class="flex items-center">
                    <form class="d-flex me-2" role="search" action="<?php echo resolve_url('search.php'); ?>" method="GET">
                        <input class="form-control form-control-sm" type="search" name="q" placeholder="Cari (TW)..." aria-label="Search">
                        <button class="btn btn-sm btn-outline-primary ms-1" type="submit"><i class="fas fa-search"></i></button>
                    </form>
                    <button id="theme-toggle-button" title="Ganti Tema (TW)" class="p-2 rounded-md text-slate-500 dark:text-slate-400">
                        <i class="fas fa-sun theme-icon-light text-lg hidden"></i>
                        <i class="fas fa-moon theme-icon-dark text-lg"></i>
                    </button>
                </div>
            </div>
        </header>
        <div id="main-content">
    <?php
    */

} else { // AWAL DARI BLOK ELSE UNTUK HEADER BOOTSTRAP
    // Kode header Bootstrap Anda yang sudah ada sebelumnya...
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }
    if (!defined('PROJECT_ROOT')) {
        define('PROJECT_ROOT', dirname(__DIR__, 2));
    }
    if (!defined('BASE_URL')) {
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || (isset($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443)) ? "https://" : "http://";
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $script_name = $_SERVER['SCRIPT_NAME'];
        $public_pos = strpos($script_name, '/public/');
        $base_path_segment = ($public_pos !== false) ? substr($script_name, 0, $public_pos) : rtrim(dirname($script_name), '/\\');
        if ($base_path_segment === '/' || $base_path_segment === '\\') $base_path_segment = '';
        define('BASE_URL', rtrim($protocol . $host . $base_path_segment, '/'));
    }
    if(!function_exists('resolve_url')){ function resolve_url($path){ if (preg_match('~^(?:f|ht)tps?://~i', $path) || substr($path, 0, 2) === '//') return $path; return rtrim(BASE_URL, '/') . '/' . ltrim($path, '/');}}
    if(!function_exists('esc_html')){ function esc_html($string) { return htmlspecialchars((string)$string, ENT_QUOTES, 'UTF-8'); }}


    global $pdo, $settings, $site_title, $meta_description;

    if (!isset($settings) && isset($pdo)) {
        $settings = [];
        try {
            $stmt_header_settings = $pdo->query("SELECT setting_key, setting_value FROM portal_settings WHERE is_public = 1");
            while ($row_header_settings = $stmt_header_settings->fetch()) {
                $settings[$row_header_settings['setting_key']] = $row_header_settings['setting_value'];
            }
        } catch (\PDOException $e) {
            error_log("Error fetching settings for public header (Bootstrap): " . $e->getMessage());
        }
    }

    $current_theme = $_COOKIE['theme'] ?? 'light-theme';
    $site_name_display = esc_html($settings['site_name'] ?? 'UGKMB CMS');
    $site_logo_url_display = isset($settings['site_logo_url']) && !empty($settings['site_logo_url']) ? esc_html(resolve_url($settings['site_logo_url'])) : '';
    $site_favicon_url_display = isset($settings['site_favicon_url']) && !empty($settings['site_favicon_url']) ? esc_html(resolve_url($settings['site_favicon_url'])) : resolve_url('public/assets/images/favicon.ico'); // Perbaikan path jika Anda memindahkannya

    $page_title_display = isset($site_title) ? esc_html($site_title) : $site_name_display;
    if (isset($site_title) && isset($settings['site_name']) && $site_title !== $settings['site_name']) {
        $page_title_display = esc_html($site_title) . ' - ' . esc_html($settings['site_name']);
    }
    $page_meta_desc_display = isset($meta_description) ? esc_html($meta_description) : esc_html($settings['site_tagline'] ?? 'Deskripsi default situs.');

    $primary_menu_items = [];
    if (isset($pdo)) {
        try {
            $stmt_menu_group = $pdo->prepare("SELECT id FROM portal_menus WHERE location = 'primary_nav' LIMIT 1");
            $stmt_menu_group->execute();
            $menu_group_id = $stmt_menu_group->fetchColumn();
            if ($menu_group_id) {
                $stmt_menu_items = $pdo->prepare("SELECT * FROM portal_menu_items WHERE menu_id = :menu_id ORDER BY parent_id ASC, item_order ASC");
                $stmt_menu_items->execute([':menu_id' => $menu_group_id]);
                $raw_items = $stmt_menu_items->fetchAll(PDO::FETCH_ASSOC);
                if (!function_exists('build_public_menu_tree')) {
                    function build_public_menu_tree(array $elements, $parentId = null) { $branch = []; foreach ($elements as $element) { if ($element['parent_id'] == $parentId) { $children = build_public_menu_tree($elements, $element['id']); if ($children) { $element['children'] = $children; } $branch[$element['id']] = $element; } } return $branch; }
                }
                $primary_menu_items = build_public_menu_tree($raw_items);
            }
        } catch (\PDOException $e) { error_log("Error fetching primary_nav (Bootstrap): " . $e->getMessage()); }
    }

    if (!function_exists('render_public_menu_items')) {
        function render_public_menu_items($items, $is_submenu = false) {
            $html = ''; if (empty($items)) return $html;
            $ul_class = $is_submenu ? 'dropdown-menu shadow-sm' : 'navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center';
            $first_item_parent_id_for_label = ''; if ($is_submenu && !empty($items)) { $first_item = reset($items); $first_item_parent_id_for_label = $first_item['parent_id'] ?? rand(1000,9999); }
            $ul_attributes = $is_submenu ? ' aria-labelledby="navbarDropdownMenuLink' . $first_item_parent_id_for_label . '"' : '';
            $html .= '<ul class="' . $ul_class . '"' . $ul_attributes . '>';
            foreach ($items as $item) {
                $has_children = !empty($item['children']); $li_class = 'nav-item'; $a_class = 'nav-link px-lg-2';
                if ($is_submenu) { $li_class = ''; $a_class = 'dropdown-item'; }
                if ($has_children) { $li_class .= ' dropdown'; if (!$is_submenu) { $a_class .= ' dropdown-toggle'; } }
                // Active state logic (gunakan yang dari prompt sebelumnya jika sudah benar)
                $current_request_uri_path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
                $base_url_path = parse_url(BASE_URL, PHP_URL_PATH) ?? '';
                if ($base_url_path !== '' && strpos($current_request_uri_path, $base_url_path) === 0) {
                    $current_request_uri_path = substr($current_request_uri_path, strlen($base_url_path));
                }
                if (substr($current_request_uri_path, 0, 1) !== '/') $current_request_uri_path = '/' . $current_request_uri_path; // Pastikan diawali /
                
                $item_url_for_active_check = $item['url'];
                if (strpos($item_url_for_active_check, BASE_URL) === 0) {
                    $item_url_for_active_check = substr($item_url_for_active_check, strlen(BASE_URL));
                }
                if (substr($item_url_for_active_check, 0, 1) !== '/' && $item_url_for_active_check !== '#' && strpos($item_url_for_active_check, '://') === false) {
                    $item_url_for_active_check = '/' . $item_url_for_active_check;
                }
                $item_url_path_for_active_check = parse_url($item_url_for_active_check, PHP_URL_PATH);

                $is_active = false;
                if ($item_url_path_for_active_check && $item['url'] !== '#') {
                    if ($current_request_uri_path === $item_url_path_for_active_check ||
                        (rtrim($current_request_uri_path, '/') . '/') === (rtrim($item_url_path_for_active_check, '/') . '/') // Match jika satu dengan / dan satu tanpa
                    ) {
                        $is_active = true;
                    } elseif ($item_url_path_for_active_check !== '/' && strpos($current_request_uri_path, rtrim($item_url_path_for_active_check, '/') . '/') === 0) {
                        // Parent match, e.g., /articles is parent of /articles/my-post
                        $is_active = true;
                    }
                }
                if (($current_request_uri_path === '/' || basename($current_request_uri_path) === 'index.php') &&
                    ($item_url_path_for_active_check === '/' || ($item_url_path_for_active_check && basename($item_url_path_for_active_check) === 'index.php'))) {
                    $is_active = true;
                }
                if($is_active && !$is_submenu) $a_class .= ' active';

                $html .= '<li class="' . $li_class . '">';
                $item_url = (strpos($item['url'], 'http') === 0 || substr($item['url'], 0, 1) === '#') ? $item['url'] : resolve_url($item['url']);
                $html .= '<a class="' . $a_class . '" href="' . esc_html($item_url) . '" ';
                if ($has_children && !$is_submenu) { $html .= ' id="navbarDropdownMenuLink' . $item['id'] . '" role="button" data-bs-toggle="dropdown" aria-expanded="false"'; }
                if (!empty($item['target']) && $item['target'] === '_blank') { $html .= ' target="_blank" rel="noopener noreferrer"'; }
                $html .= '>'; if (!empty($item['icon_class'])) { $html .= '<i class="' . esc_html($item['icon_class']) . ' me-1"></i>'; }
                $html .= esc_html($item['title']); $html .= '</a>';
                if ($has_children) { $html .= render_public_menu_items($item['children'], true); }
                $html .= '</li>';
            } $html .= '</ul>'; return $html;
        }
    }
?>
<!DOCTYPE html>
<html lang="id" class="<?php echo esc_html($current_theme); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title_display; ?></title>
    <meta name="description" content="<?php echo $page_meta_desc_display; ?>">
    <?php if (isset($page_content) && !empty($page_content['meta_keywords'])): ?>
    <meta name="keywords" content="<?php echo esc_html($page_content['meta_keywords']); ?>">
    <?php elseif (isset($settings['site_meta_keywords_default']) && !empty($settings['site_meta_keywords_default'])): ?>
    <meta name="keywords" content="<?php echo esc_html($settings['site_meta_keywords_default']); ?>">
    <?php endif; ?>

    <link rel="icon" href="<?php echo $site_favicon_url_display; ?>" type="image/x-icon">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/theme.css'); ?>">
    <link rel="stylesheet" href="<?php echo resolve_url('public/assets/css/style.css'); ?>">

    <script>
        (function() {
            const theme = document.cookie.split('; ').find(row => row.startsWith('theme='))?.split('=')[1] || 
                          (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark-theme' : 'light-theme');
            document.documentElement.className = theme;
        })();
    </script>
    <style>
        body { padding-top: 70px; /* Sesuaikan dengan tinggi navbar Anda */ }
        .dropdown-menu .dropdown-item:hover, .dropdown-menu .dropdown-item:focus { background-color: var(--public-primary-color); color: #fff; }
        html.dark-theme .dropdown-menu { background-color: var(--public-card-bg-dark); border-color: var(--public-border-color-dark); }
        html.dark-theme .dropdown-menu .dropdown-item { color: var(--public-text-color-dark); }
        html.dark-theme .dropdown-menu .dropdown-item:hover, html.dark-theme .dropdown-menu .dropdown-item:focus { background-color: var(--public-link-color-dark); color: var(--public-bg-color-dark); }
    </style>
</head>
<body class="<?php echo esc_html($current_theme); ?>">
    <header data-bs-theme="<?php echo $current_theme === 'dark-theme' ? 'dark' : 'light'; ?>">
        <nav class="navbar navbar-expand-lg <?php echo $current_theme === 'dark-theme' ? 'navbar-dark bg-dark' : 'navbar-light bg-light'; ?> fixed-top shadow-sm">
            <div class="container">
                <a class="navbar-brand fw-bold" href="<?php echo resolve_url('index.php'); ?>">
                    <?php if ($site_logo_url_display): ?>
                        <img src="<?php echo $site_logo_url_display; ?>" alt="Logo <?php echo $site_name_display; ?>" height="40" class="d-inline-block align-top">
                    <?php else: ?>
                        <?php echo $site_name_display; ?>
                    <?php endif; ?>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNavPublic" aria-controls="navbarNavPublic" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarNavPublic">
                    <?php
                    if (!empty($primary_menu_items)) {
                        echo render_public_menu_items($primary_menu_items);
                    } else {
                        $current_page_basename_header = basename($_SERVER['PHP_SELF']);
                    ?>
                    <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center">
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo ($current_page_basename_header == 'index.php') ? 'active' : ''; ?>" href="<?php echo resolve_url('index.php'); ?>">Beranda</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['articles.php', 'article.php', 'category.php', 'tag.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('articles.php'); ?>">Berita</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['events.php', 'event.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('events.php'); ?>">Agenda</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['gallery.php', 'album.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('gallery.php'); ?>">Galeri</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo (in_array($current_page_basename_header, ['faculties.php', 'faculty.php', 'study_program.php'])) ? 'active' : ''; ?>" href="<?php echo resolve_url('faculties.php'); ?>">Akademik</a></li>
                        <li class="nav-item"><a class="nav-link px-lg-2 <?php echo ($current_page_basename_header == 'contact.php') ? 'active' : ''; ?>" href="<?php echo resolve_url('contact.php'); ?>">Kontak</a></li>
                    </ul>
                    <?php
                    }
                    ?>
                    <!-- KEMBALIKAN HTML UNTUK SEARCH DAN THEME TOGGLE -->
                    <!--<div class="d-flex align-items-center ms-lg-3 mt-2 mt-lg-0">-->
                    <!--    <form class="d-flex me-2" role="search" action="<?php echo resolve_url('search.php'); ?>" method="GET">-->
                    <!--        <input class="form-control form-control-sm" type="search" name="q" placeholder="Cari..." aria-label="Search" value="<?php echo isset($_GET['q']) ? esc_html($_GET['q']) : ''; ?>">-->
                    <!--        <button class="btn btn-sm btn-outline-primary ms-1" type="submit" aria-label="Tombol Cari"><i class="fas fa-search"></i></button>-->
                    <!--    </form>-->
                    <!--    <button class="btn btn-sm btn-outline-secondary" id="publicThemeToggleNav" title="Ganti Tema">-->
                    <!--        <i class="fas fa-moon" id="publicThemeIconMoon" style="display: <?php echo $current_theme === 'dark-theme' ? 'none' : 'inline-block'; ?>;"></i>-->
                    <!--        <i class="fas fa-sun" id="publicThemeIconSun" style="display: <?php echo $current_theme === 'dark-theme' ? 'inline-block' : 'none'; ?>;"></i>-->
                    <!--    </button>-->
                    <!--</div>-->
                </div>
            </div>
        </nav>
    </header>
    <!-- <div style="padding-top: 65px;"> --> <!-- Padding sudah dihandle oleh body { padding-top: 70px; } -->
    <div id="main-content"> <!-- Ini adalah pembuka div yang akan ditutup di footer_public.php -->
<?php
} // AKHIR DARI BLOK ELSE UNTUK HEADER BOOTSTRAP
// Skrip JavaScript universal untuk theme toggle (dari header Tailwind) BISA dipindah ke footer jika mau
// Namun, pastikan tidak konflik dengan skrip tema Bootstrap di footer.
// Untuk sekarang, kita biarkan skrip tema Bootstrap di footer.php dan skrip tema Tailwind di header Tailwind.
?>