<?php
// includes/footer.php (Root level - Placeholder atau untuk bagian situs yang berbeda)
if (!defined('PROJECT_ROOT')) { define('PROJECT_ROOT', dirname(__DIR__)); }

// Fungsi helper minimal jika file ini digunakan secara independen
if (!function_exists('root_esc_html_footer')) { // Nama unik
    function root_esc_html_footer($string) { return htmlspecialchars((string)$string, ENT_QUOTES, 'UTF-8'); }
}
if (!function_exists('root_resolve_url_footer')) { // Nama unik
    function root_resolve_url_footer($path) {
        if (empty($path)) return '';
        if (preg_match('~^(?:f|ht)tps?://~i', $path) || substr($path, 0, 2) === '//') return $path;
        return rtrim(defined('BASE_URL') ? BASE_URL : '', '/') . '/' . ltrim($path, '/');
    }
}

global $settings_page_footer, $public_page_specific_scripts; // Variabel yang mungkin di-pass
$current_theme_root_footer = $_COOKIE['theme'] ?? 'light-theme';

if (!isset($settings_page_footer) || empty($settings_page_footer)) {
    $settings_page_footer = ['site_name' => 'My Generic Site'];
}
?>
    </div> <!-- Penutup div offset navbar dari header.php -->
    <footer class="py-4 mt-auto <?php echo $current_theme_root_footer === 'dark-theme' ? 'bg-dark text-white-50' : 'bg-light text-muted'; ?>">
        <div class="container text-center">
            <p>© <?php echo date('Y'); ?> <?php echo root_esc_html_footer($settings_page_footer['site_name']); ?>. All Rights Reserved.</p>
        </div>
    </footer>

    <!-- CDN JS Umum -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    
    <!-- JS Lokal -->
    <script src="<?php echo root_resolve_url_footer('assets/js/main.js'); ?>"></script>

    <?php
    if (isset($public_page_specific_scripts) && is_array($public_page_specific_scripts)) {
        foreach ($public_page_specific_scripts as $script_url) {
            echo '<script src="' . root_resolve_url_footer($script_url) . '"></script>' . "\n";
        }
    }
    ?>
</body>
</html>