<?php
// admin/modules/users/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Pengguna";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$users = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT id, username, email, full_name, role, is_active, created_at
                             FROM portal_users
                             ORDER BY username ASC");
        $users = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data pengguna: ' . $e->getMessage());
        error_log("Error fetching users: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Pengguna'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-user-plus me-1"></i> Tambah Pengguna Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-users me-1"></i>
            Daftar Pengguna
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableUsers" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Username</th>
                            <th>Nama Lengkap</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Status</th>
                            <th>Tgl Dibuat</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($users) > 0): ?>
                            <?php foreach ($users as $index => $user): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo esc_html($user['username']); ?></td>
                                <td><?php echo esc_html($user['full_name'] ?? 'N/A'); ?></td>
                                <td><?php echo esc_html($user['email']); ?></td>
                                <td class="text-center"><span class="badge bg-info text-dark"><?php echo ucfirst(esc_html($user['role'])); ?></span></td>
                                <td class="text-center">
                                    <?php if ($user['is_active']): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Nonaktif</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo date('d M Y, H:i', strtotime($user['created_at'])); ?></td>
                                <td class="text-center">
                                    <a href="edit.php?id=<?php echo $user['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if ($_SESSION['user_id'] != $user['id'] && $user['id'] != 1): // Prevent self-delete and deleting superadmin (ID 1) ?>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-user"
                                            data-id="<?php echo $user['id']; ?>"
                                            data-username="<?php echo esc_html(addslashes($user['username'])); ?>"
                                            data-url="process_user.php?action=delete&id=<?php echo $user['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                    <?php else: ?>
                                        <button class="btn btn-sm btn-secondary mb-1" title="Tidak dapat dihapus" disabled><i class="fas fa-trash"></i></button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Belum ada pengguna.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableUsers').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 1, \"asc\" ]] // Order by Username
        });

        // AJAX Delete untuk User
        $('#dataTableUsers').on('click', '.btn-delete-user', function() {
            const button = $(this);
            const username = button.data('username');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus pengguna: ' + username + '? Aksi ini tidak dapat dibatalkan.')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus pengguna.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus pengguna.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>