<?php
// admin/modules/users/edit.php

// Pastikan config.php dimuat paling awal dan hanya sekali
// dan session_start() sudah ada di config.php
if (file_exists(dirname(__DIR__, 3) . '/config.php')) {
    require_once dirname(__DIR__, 3) . '/config.php';
} elseif (file_exists(dirname(__FILE__, 4) . '/config.php')) { 
    require_once dirname(__FILE__, 4) . '/config.php';
} else {
    // error_log("CRITICAL FAILURE: config.php not found from users/edit.php."); // Sebaiknya error_log
    die("Konfigurasi sistem tidak ditemukan. Harap hubungi administrator. (edit.php)");
}

// Autentikasi dan Otorisasi
if (!isset($_SESSION['user_id']) || !isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    set_flash_message('danger', 'Akses ditolak. Anda tidak memiliki izin untuk halaman ini.');
    if (!headers_sent()) {
        header('Location: ' . admin_url('login.php')); 
    }
    exit;
}

$page_title = "Edit Pengguna";
$user_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($user_id_to_edit <= 0) {
    set_flash_message('danger', 'ID pengguna tidak valid atau tidak disediakan.');
    if (!headers_sent()) {
        header('Location: ' . admin_url('modules/users/index.php'));
    }
    exit;
}

// Fetch user data from DB for editing
$user_db_data_for_edit_form = null;
if (!isset($pdo)) {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
    // Tidak redirect di sini, biarkan halaman render dengan pesan error
} else {
    try {
        $stmt_fetch_user = $pdo->prepare("SELECT id, username, email, full_name, role, is_active FROM portal_users WHERE id = :id");
        $stmt_fetch_user->bindParam(':id', $user_id_to_edit, PDO::PARAM_INT);
        $stmt_fetch_user->execute();
        $user_db_data_for_edit_form = $stmt_fetch_user->fetch(PDO::FETCH_ASSOC);

        if (!$user_db_data_for_edit_form) {
            set_flash_message('danger', 'Pengguna dengan ID ' . esc_html($user_id_to_edit) . ' tidak ditemukan.');
            if (!headers_sent()) {
                header('Location: ' . admin_url('modules/users/index.php'));
            }
            exit;
        }
        // Jika ditemukan, update page_title
        $page_title = "Edit Pengguna: " . esc_html($user_db_data_for_edit_form['username']);

    } catch (\PDOException $e_fetch) {
        error_log("Error fetching user for edit (ID: $user_id_to_edit): " . $e_fetch->getMessage());
        set_flash_message('danger', 'Gagal mengambil data pengguna: Terjadi kesalahan database.');
        // Tidak redirect di sini, biarkan halaman render dengan pesan error
        $user_db_data_for_edit_form = null; // Tandai data tidak ada
    }
}


// Data for form repopulation (from session on error, or from DB)
$default_form_values_edit = [
    'username' => $user_db_data_for_edit_form['username'] ?? '',
    'email' => $user_db_data_for_edit_form['email'] ?? '',
    'full_name' => $user_db_data_for_edit_form['full_name'] ?? '',
    'role' => $user_db_data_for_edit_form['role'] ?? 'author',
    'is_active' => $user_db_data_for_edit_form['is_active'] ?? 1,
    'password' => '', 
    'confirm_password' => ''
];
// Gunakan nama session yang konsisten dengan yang di-set di process_user.php untuk aksi 'edit'
$form_values_edit_user = $_SESSION['form_data_user_admin_edit'] ?? $default_form_values_edit;
$form_errors_edit_user = $_SESSION['form_errors_user_admin_edit'] ?? [];

// Hapus dari session setelah diambil
unset($_SESSION['form_data_user_admin_edit']);
unset($_SESSION['form_errors_user_admin_edit']);

// Tentukan apakah role dan status fields harus di-disable
// Tidak bisa edit diri sendiri (role & status) atau superadmin (ID 1)
$can_change_sensitive_fields = false; // Default tidak bisa
if ($user_db_data_for_edit_form) { // Hanya jika data pengguna ada
    $can_change_sensitive_fields = !($user_db_data_for_edit_form['id'] == $_SESSION['user_id'] || $user_db_data_for_edit_form['id'] == 1);
}

require_once PROJECT_ROOT . '/admin/includes/header.php';
// sidebar.php di-include oleh header.php
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => admin_url('index.php')],
        ['label' => 'Manajemen Pengguna', 'url' => admin_url('modules/users/index.php')],
        $page_title // Judul halaman saat ini
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <hr class="mb-4">
    <?php echo display_flash_message(); ?>

    <?php if ($user_db_data_for_edit_form): // Hanya tampilkan form jika data pengguna berhasil diambil ?>
    <div class="card shadow-sm">
        <div class="card-header">
            <i class="fas fa-edit me-1"></i>
            Formulir Edit Pengguna: <strong><?php echo esc_html($user_db_data_for_edit_form['username']); ?></strong>
        </div>
        <div class="card-body">
            <form action="<?php echo admin_url('modules/users/process_user.php'); ?>" method="POST" id="editUserForm">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" name="id" value="<?php echo esc_html($user_db_data_for_edit_form['id']); ?>">
                <input type="hidden" name="csrf_token" id="csrf_token_edit_user_page" value="<?php echo generate_csrf_token(); ?>">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="username" class="form-label">Username <span class="text-danger">*</span></label>
                        <input type="text" 
                               class="form-control <?php echo isset($form_errors_edit_user['username']) ? 'is-invalid' : ''; ?>" 
                               id="username" name="username" 
                               value="<?php echo esc_html($form_values_edit_user['username']); ?>" required maxlength="50">
                        <?php if (isset($form_errors_edit_user['username'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_edit_user['username']); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                        <input type="email" 
                               class="form-control <?php echo isset($form_errors_edit_user['email']) ? 'is-invalid' : ''; ?>" 
                               id="email" name="email" 
                               value="<?php echo esc_html($form_values_edit_user['email']); ?>" required maxlength="100">
                        <?php if (isset($form_errors_edit_user['email'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_edit_user['email']); ?></div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mb-3">
                    <label for="full_name" class="form-label">Nama Lengkap <span class="text-danger">*</span></label>
                    <input type="text" 
                           class="form-control <?php echo isset($form_errors_edit_user['full_name']) ? 'is-invalid' : ''; ?>" 
                           id="full_name" name="full_name" 
                           value="<?php echo esc_html($form_values_edit_user['full_name']); ?>" required maxlength="100">
                    <?php if (isset($form_errors_edit_user['full_name'])): ?>
                        <div class="invalid-feedback"><?php echo esc_html($form_errors_edit_user['full_name']); ?></div>
                    <?php endif; ?>
                </div>

                <hr class="my-4">
                <p class="text-muted small"><strong>Perubahan Password (Opsional):</strong> Kosongkan field di bawah ini jika Anda tidak ingin mengubah password pengguna ini.</p>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="password" class="form-label">Password Baru</label>
                        <input type="password" 
                               class="form-control <?php echo isset($form_errors_edit_user['password']) ? 'is-invalid' : ''; ?>" 
                               id="password" name="password" 
                               placeholder="Isi untuk mengubah password" minlength="6">
                        <div class="form-text">Minimal 6 karakter jika diisi.</div>
                        <?php if (isset($form_errors_edit_user['password'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_edit_user['password']); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="confirm_password" class="form-label">Konfirmasi Password Baru</label>
                        <input type="password" 
                               class="form-control <?php echo isset($form_errors_edit_user['confirm_password']) ? 'is-invalid' : ''; ?>" 
                               id="confirm_password" name="confirm_password"
                               placeholder="Ulangi password baru">
                        <?php if (isset($form_errors_edit_user['confirm_password'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_edit_user['confirm_password']); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <hr class="my-4">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="role" class="form-label">Role <span class="text-danger">*</span></label>
                        <select class="form-select <?php echo isset($form_errors_edit_user['role']) ? 'is-invalid' : ''; ?>" 
                                id="role" name="role" required 
                                <?php echo !$can_change_sensitive_fields ? 'disabled title="Role tidak dapat diubah untuk pengguna ini"' : ''; ?>>
                            <option value="author" <?php echo ($form_values_edit_user['role'] === 'author') ? 'selected' : ''; ?>>Author</option>
                            <option value="editor" <?php echo ($form_values_edit_user['role'] === 'editor') ? 'selected' : ''; ?>>Editor</option>
                            <option value="admin" <?php echo ($form_values_edit_user['role'] === 'admin') ? 'selected' : ''; ?>>Admin</option>
                        </select>
                        <?php if (!$can_change_sensitive_fields): ?>
                            <input type="hidden" name="role" value="<?php echo esc_html($form_values_edit_user['role']); ?>">
                            <div class="form-text text-warning mt-1"><i class="fas fa-lock fa-xs"></i> Role pengguna ini tidak dapat diubah.</div>
                        <?php endif; ?>
                        <?php if (isset($form_errors_edit_user['role'])): ?>
                            <div class="invalid-feedback"><?php echo esc_html($form_errors_edit_user['role']); ?></div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label d-block">Status Akun <span class="text-danger">*</span></label>
                        <div class="form-check form-switch pt-1">
                            <input class="form-check-input" type="checkbox" role="switch" 
                                   id="is_active" name="is_active" value="1" 
                                   <?php echo (isset($form_values_edit_user['is_active']) && $form_values_edit_user['is_active'] == 1) ? 'checked' : ''; ?> 
                                   <?php echo !$can_change_sensitive_fields ? 'disabled title="Status tidak dapat diubah untuk pengguna ini"' : ''; ?>>
                            <label class="form-check-label" for="is_active" id="is_active_label">
                                <?php echo (isset($form_values_edit_user['is_active']) && $form_values_edit_user['is_active'] == 1) ? 'Aktif' : 'Nonaktif'; ?>
                            </label>
                        </div>
                        <?php if (!$can_change_sensitive_fields): ?>
                            <input type="hidden" name="is_active" value="<?php echo esc_html($form_values_edit_user['is_active']); ?>">
                            <div class="form-text text-warning mt-1"><i class="fas fa-lock fa-xs"></i> Status akun pengguna ini tidak dapat diubah.</div>
                        <?php endif; ?>
                         <?php if (isset($form_errors_edit_user['is_active'])): ?>
                            <div class="text-danger small mt-1 d-block"><?php echo esc_html($form_errors_edit_user['is_active']); ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div id="generalFormErrors" class="mb-3 text-danger small">
                     <?php if (isset($form_errors_edit_user['_general'])): ?>
                        <div class="alert alert-danger p-2"><?php echo esc_html($form_errors_edit_user['_general']); ?></div>
                    <?php endif; ?>
                </div>

                <div class="mt-4 pt-3 border-top">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="<?php echo admin_url('modules/users/index.php'); ?>" class="btn btn-outline-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
    <?php else: ?>
        <?php // Bagian ini akan dijalankan jika $user_db_data_for_edit_form adalah null atau false ?>
        <?php // Flash message seharusnya sudah di-set jika redirect dari atas, atau jika $pdo null ?>
        <?php if (!isset($pdo)): ?>
            <div class="alert alert-danger text-center" role="alert">
                <h4 class="alert-heading">Koneksi Database Gagal</h4>
                <p>Tidak dapat memuat data pengguna karena masalah koneksi database.</p>
            </div>
        <?php elseif (!$user_db_data_for_edit_form && $user_id_to_edit > 0): ?>
            <?php // Ini seharusnya tidak tercapai jika redirect di atas sudah benar, tapi sebagai fallback ?>
            <div class="alert alert-warning text-center" role="alert">
                <h4 class="alert-heading">Pengguna Tidak Ditemukan</h4>
                <p>Data pengguna yang Anda coba edit tidak ditemukan dalam sistem.</p>
                <hr>
                <p class="mb-0">Silakan kembali ke <a href="<?php echo admin_url('modules/users/index.php'); ?>" class="alert-link">daftar pengguna</a>.</p>
            </div>
        <?php endif; ?>
    <?php endif; // Akhir dari if ($user_db_data_for_edit_form) ?>
</div>
<?php
// --- JavaScript ---
$page_scripts = []; // Inisialisasi array untuk script khusus halaman ini

// Menggunakan json_encode untuk variabel PHP yang akan dimasukkan ke JavaScript dengan aman
$js_initial_csrf_token_edit_user = json_encode(generate_csrf_token());

$page_scripts[] = <<<JS_EDIT_USER_FORM
<script>
    // Fallback functions jika admin-global.js belum termuat
    if (typeof showAdminNotification === 'undefined') { function showAdminNotification(type, message) { console.warn('showAdminNotification fallback:', type, message); alert(type + ': ' + message); } }
    if (typeof displayAdminFormErrors === 'undefined') { function displayAdminFormErrors(form, errors) { console.warn('displayAdminFormErrors fallback', errors); if(errors && errors._general) alert('Error: ' + errors._general); else if(errors) console.log('Form errors:', errors); } }

    let currentEditUserFormCsrfToken = $js_initial_csrf_token_edit_user;

    function updateEditUserFormCsrf(newToken) {
        currentEditUserFormCsrfToken = newToken;
        $('#csrf_token_edit_user_page').val(newToken); // Pastikan ID field CSRF di form ini unik jika perlu
    }

    $(document).ready(function() {
        // Update label checkbox 'is_active' saat statusnya berubah
        $('#is_active').change(function() {
            const label = $('#is_active_label'); // Gunakan ID untuk label
            if ($(this).is(':checked')) {
                label.text('Aktif');
            } else {
                label.text('Nonaktif');
            }
        });

        // Jika Anda memutuskan untuk menggunakan AJAX submit untuk form edit ini:
        $('#editUserForm').submit(function(e) {
            e.preventDefault();
            const form = $(this);
            const button = form.find('button[type="submit"]');
            const originalButtonHtml = button.html();

            button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Menyimpan...');
            form.find('.is-invalid').removeClass('is-invalid');
            form.find('.invalid-feedback').empty();
            $('#generalFormErrors').empty().hide();

            // Pastikan CSRF token terbaru digunakan
            form.find('input[name="csrf_token"]').val(currentEditUserFormCsrfToken);
            
            // Jika ada field yang disabled (role, is_active), nilainya tidak akan terkirim via serialize().
            // Kita perlu mengambilnya manual jika nilainya penting untuk dikirim ulang (meskipun server mungkin mengabaikannya).
            // Namun, karena kita sudah menambahkan input hidden untuk field disabled, serialize() akan mengambilnya.
            
            $.ajax({
                url: form.attr('action'),
                method: form.attr('method'),
                data: form.serialize(),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        showAdminNotification('success', response.message || 'Perubahan berhasil disimpan.');
                        if (response.redirect_url) {
                            // Beri jeda agar notifikasi terlihat sebelum redirect
                            setTimeout(function() {
                                window.location.href = response.redirect_url;
                            }, 1500);
                        } else {
                            // Jika tidak ada redirect_url, mungkin hanya reload atau update UI di tempat
                            // location.reload(); // Opsi: reload halaman
                        }
                    } else {
                        showAdminNotification('danger', response.message || 'Terjadi kesalahan validasi.');
                        if (response.errors) {
                            if (typeof displayAdminFormErrors === 'function') {
                                displayAdminFormErrors(form, response.errors);
                            } else {
                                console.error("displayAdminFormErrors function is not defined. Errors:", response.errors);
                            }
                        } else if (response.message) {
                             $('#generalFormErrors').html(response.message).show();
                        }
                    }
                    if (response.new_csrf_token) {
                        updateEditUserFormCsrf(response.new_csrf_token);
                    }
                },
                error: function(jqXHR) {
                    let errorMsg = 'Kesalahan server. Tidak dapat mengirim permintaan.';
                    if (jqXHR.responseJSON && jqXHR.responseJSON.message) {
                        errorMsg = jqXHR.responseJSON.message;
                    } else if (jqXHR.statusText && jqXHR.status) {
                        errorMsg = 'Error: ' + jqXHR.status + ' - ' + jqXHR.statusText;
                    }
                    showAdminNotification('danger', errorMsg);
                    $('#generalFormErrors').html(errorMsg).show();
                    console.error("AJAX edit user form submission error:", jqXHR.responseText);
                },
                complete: function() {
                    button.prop('disabled', false).html(originalButtonHtml);
                }
            });
        });
    });
</script>
JS_EDIT_USER_FORM;

$page_scripts[] = $inline_script_content; // Tambahkan blok script ke array $page_scripts
require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>