<?php
// admin/modules/tags/process_tag.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3));
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

function is_ajax_request_tag() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';
}
$is_ajax = is_ajax_request_tag();
if ($is_ajax) {
    header('Content-Type: application/json');
}

$module_redirect_url_base = 'index.php';

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Akses ditolak.']); exit; }
    set_flash_message('danger', 'Anda tidak memiliki izin untuk aksi ini.'); header('Location: ../../login.php'); exit;
}
if (!isset($pdo)) {
    if ($is_ajax) { http_response_code(503); echo json_encode(['success' => false, 'message' => 'Koneksi database gagal.']); exit; }
    set_flash_message('danger', 'Koneksi database gagal.'); header('Location: ' . $module_redirect_url_base); exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        if ($is_ajax) { http_response_code(403); echo json_encode(['success' => false, 'message' => 'Kesalahan CSRF.']); exit; }
        set_flash_message('danger', 'Kesalahan CSRF token.');
        $action_redirect = $_POST['action'] ?? 'create'; $id_redirect = $_POST['id'] ?? null;
        header('Location: ' . ($action_redirect === 'edit' && $id_redirect ? 'edit.php?id=' . $id_redirect : 'create.php')); exit;
    }

    $action = $_POST['action'] ?? null;
    $tag_id = isset($_POST['id']) ? (int)$_POST['id'] : null;
    $redirect_on_error_url = ($action === 'edit' && $tag_id ? 'edit.php?id=' . $tag_id : 'create.php');

    $name = trim($_POST['name'] ?? '');
    $slug_input = trim($_POST['slug'] ?? '');
    $errors = [];

    if (empty($name)) { $errors['name'] = 'Nama tag wajib diisi.'; }
    elseif (strlen($name) > 100) { $errors['name'] = 'Nama tag maksimal 100 karakter.';}
    $slug = !empty($slug_input) ? generate_slug($slug_input) : generate_slug($name);
    if (empty($slug)) { $errors['slug'] = 'Slug tidak boleh kosong.';}
    elseif (strlen($slug) > 120) { $errors['slug'] = 'Slug maksimal 120 karakter.';}
    else {
        $stmt_check_slug = $pdo->prepare("SELECT id FROM portal_tags WHERE slug = :slug" . ($tag_id ? " AND id != :id_tag" : ""));
        $params_check_slug = [':slug' => $slug]; if ($tag_id) $params_check_slug[':id_tag'] = $tag_id;
        $stmt_check_slug->execute($params_check_slug);
        if ($stmt_check_slug->fetch()) { $errors['slug'] = 'Slug "' . esc_html($slug) . '" sudah digunakan.';}
    }

    if (!empty($errors)) {
        if ($is_ajax) { http_response_code(422); echo json_encode(['success' => false, 'message' => 'Validasi gagal.', 'errors' => $errors]); }
        else {
            $_SESSION['form_errors'] = $errors; $_SESSION['form_data'] = $_POST;
            set_flash_message('danger', 'Gagal menyimpan tag.'); header('Location: ' . $redirect_on_error_url);
        }
        exit;
    }

    try {
        if ($action === 'create') {
            $sql = "INSERT INTO portal_tags (name, slug, created_at, updated_at) VALUES (:name, :slug, NOW(), NOW())";
            $stmt = $pdo->prepare($sql);
        } elseif ($action === 'edit' && $tag_id) {
            $sql = "UPDATE portal_tags SET name = :name, slug = :slug, updated_at = NOW() WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $tag_id, PDO::PARAM_INT);
        } else { throw new Exception("Aksi tidak valid."); }
        $stmt->bindParam(':name', $name); $stmt->bindParam(':slug', $slug);
        $stmt->execute();

        if ($is_ajax) { echo json_encode(['success' => true, 'message' => 'Tag berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.', 'redirect_url' => $module_redirect_url_base]); }
        else { set_flash_message('success', 'Tag berhasil ' . ($action === 'create' ? 'dibuat' : 'diperbarui') . '.'); header('Location: ' . $module_redirect_url_base); }
        exit;
    } catch (PDOException | Exception $e) {
        // ... (handle error) ...
    }

} elseif ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'delete') {
    // ... (validasi CSRF dan ID) ...
    if (!isset($_GET['csrf_token']) || !validate_csrf_token($_GET['csrf_token'])) { /* ... */ }
    $tag_id_to_delete = isset($_GET['id']) ? (int)$_GET['id'] : 0;
    if ($tag_id_to_delete <= 0) { /* ... */ }

    try {
        $pdo->beginTransaction();
        $stmt_delete_assoc = $pdo->prepare("DELETE FROM portal_article_tag WHERE tag_id = :tag_id");
        $stmt_delete_assoc->execute([':tag_id' => $tag_id_to_delete]);
        $stmt_delete_tag = $pdo->prepare("DELETE FROM portal_tags WHERE id = :id");
        $stmt_delete_tag->execute([':id' => $tag_id_to_delete]);

        if ($stmt_delete_tag->rowCount() > 0) {
            $pdo->commit();
            if ($is_ajax) { echo json_encode(['success' => true, 'message' => 'Tag berhasil dihapus.']); }
            else { set_flash_message('success', 'Tag berhasil dihapus.'); header('Location: ' . $module_redirect_url_base); }
        } else {
            $pdo->rollBack();
            if ($is_ajax) { echo json_encode(['success' => false, 'message' => 'Tag tidak ditemukan.']); }
            else { set_flash_message('warning', 'Tag tidak ditemukan.'); header('Location: ' . $module_redirect_url_base); }
        }
    } catch (PDOException $e) {
        // ... (handle error) ...
    }
    exit;
} else {
    // ... (handle permintaan tidak valid) ...
}
?>