<?php
// admin/modules/sliders/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Slider Homepage";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$sliders = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT id, title, image_url_desktop, image_url_mobile, link_url, slide_order, is_active, start_date, end_date
                             FROM portal_sliders
                             ORDER BY slide_order ASC, created_at DESC");
        $sliders = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data slider: ' . $e->getMessage());
        error_log("Error fetching sliders: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Slider Homepage'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Slider Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-images me-1"></i>
            Daftar Slider
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableSliders" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Gambar</th>

                            <th>Judul</th>
                            <th>Link URL</th>
                            <th>Urutan</th>
                            <th>Status</th>
                            <th>Jadwal Tayang</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($sliders) > 0): ?>
                            <?php foreach ($sliders as $index => $slider): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td class="text-center">
                                    <?php if (!empty($slider['image_url_desktop'])): ?>
                                        <img src="<?php echo resolve_url(esc_html($slider['image_url_desktop'])); ?>" alt="Desktop: <?php echo esc_html($slider['title']); ?>" style="width: 120px; max-height: 60px; object-fit: cover; border-radius: 0.25rem;">
                                    <?php else: ?>
                                        <span class="text-muted small fst-italic">N/A</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo esc_html($slider['title']); ?></td>
                                <td>
                                    <?php if (!empty($slider['link_url'])): ?>
                                        <a href="<?php echo esc_html($slider['link_url']); ?>" target="_blank" rel="noopener noreferrer" title="<?php echo esc_html($slider['link_url']); ?>">
                                            <?php echo esc_html(substr($slider['link_url'], 0, 25)) . (strlen($slider['link_url']) > 25 ? '...' : ''); ?>
                                        </a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo esc_html($slider['slide_order']); ?></td>
                                <td class="text-center">
                                    <?php if ($slider['is_active']): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Nonaktif</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php
                                    $schedule = '';
                                    if ($slider['start_date']) $schedule .= "Mulai: " . date('d M Y H:i', strtotime($slider['start_date']));
                                    if ($slider['end_date']) $schedule .= ($schedule ? "<br>" : "") . "Selesai: " . date('d M Y H:i', strtotime($slider['end_date']));
                                    echo $schedule ?: '-';
                                    ?>
                                </td>
                                <td class="text-center">
                                    <a href="edit.php?id=<?php echo $slider['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-slider"
                                            data-id="<?php echo $slider['id']; ?>"
                                            data-title="<?php echo esc_html(addslashes($slider['title'])); ?>"
                                            data-url="process_slider.php?action=delete&id=<?php echo $slider['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Belum ada slider.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <p class="text-muted small mt-2">Untuk mengubah urutan, edit masing-masing slider dan set nilai "Urutan Slide".</p>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableSliders').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 5, \"asc\" ]] // Order by Urutan
        });

        // AJAX Delete untuk Slider
        $('#dataTableSliders').on('click', '.btn-delete-slider', function() {
            const button = $(this);
            const sliderTitle = button.data('title');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus slider: ' + sliderTitle + '?')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus slider.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus slider.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>