<?php
// admin/modules/sliders/create.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php'; // Pastikan semua fungsi (old_form_data, get_form_error, dll) ada di sini

$module_base_path = '../../';
$page_title = "Tambah Slider Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => '', 'description' => '', 'link_url' => '', 'button_text' => '',
    'slide_order' => 0, 'is_active' => 1, 'start_date' => '', 'end_date' => ''
];
$form_errors = $_SESSION['form_errors'] ?? [];
// Fungsi clear_form_session_data() harus ada di functions.php
if (function_exists('clear_form_session_data')) {
    clear_form_session_data();
} else {
    // Fallback jika fungsi tidak ada
    unset($_SESSION['form_data']);
    unset($_SESSION['form_errors']);
}
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Slider Homepage', 'url' => 'index.php'],
        'Tambah Slider Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_slider.php" method="POST" enctype="multipart/form-data" id="sliderForm">
        <input type="hidden" name="action" value="create">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-info-circle me-1"></i> Informasi Dasar Slider</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="title" class="form-label">Judul Slider <span class="text-danger">*</span></label>
                    <input type="text" class="form-control <?php echo isset($form_errors['title']) ? 'is-invalid' : ''; ?>" id="title" name="title" value="<?php echo old_form_data('title', '', $form_data); ?>" required>
                    <?php echo get_form_error('title', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi Singkat (Opsional)</label>
                    <textarea class="form-control <?php echo isset($form_errors['description']) ? 'is-invalid' : ''; ?>" id="description" name="description" rows="3"><?php echo old_form_data('description', '', $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
            </div>
        </div>

        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-image me-1"></i> Gambar Slider</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="image_file_desktop" class="form-label">Gambar Desktop <span class="text-danger">*</span></label>
                        <img id="imagePreviewDesktop" src="#" alt="Preview Gambar Desktop" class="img-thumbnail mb-2" style="max-height: 100px; display: none;">
                        <input type="file" class="form-control <?php echo isset($form_errors['image_url_desktop']) ? 'is-invalid' : ''; ?>" id="image_file_desktop" name="image_file_desktop" accept="image/jpeg, image/png, image/gif, image/webp" required>
                        <div class="form-text">Rekomendasi: 1920x700px. Maks 2MB.</div>
                        <?php echo get_form_error('image_url_desktop', $form_errors); // Nama error key adalah image_url_desktop ?>
                    </div>
                    <!--<div class="col-md-6 mb-3">-->
                    <!--    <label for="image_file_mobile" class="form-label">Gambar Mobile (Opsional)</label>-->
                    <!--    <img id="imagePreviewMobile" src="#" alt="Preview Gambar Mobile" class="img-thumbnail mb-2" style="max-height: 100px; display: none;">-->
                    <!--    <input type="file" class="form-control <?php echo isset($form_errors['image_url_mobile']) ? 'is-invalid' : ''; ?>" id="image_file_mobile" name="image_file_mobile" accept="image/jpeg, image/png, image/gif, image/webp">-->
                    <!--    <div class="form-text">Rekomendasi: 768x500px. Maks 1MB. Jika kosong, gambar desktop akan dipertimbangkan.</div>-->
                    <!--    <?php echo get_form_error('image_url_mobile', $form_errors); ?>-->
                    <!--</div>-->
                </div>
            </div>
        </div>
        
        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-link me-1"></i> Tautan & Tombol (Opsional)</div>
            <div class="card-body">
                <div class="mb-3">
                    <label for="link_url" class="form-label">URL Tujuan Klik</label>
                    <input type="url" class="form-control <?php echo isset($form_errors['link_url']) ? 'is-invalid' : ''; ?>" id="link_url" name="link_url" value="<?php echo old_form_data('link_url', '', $form_data); ?>" placeholder="https://ugkmb.ac.id/halaman-tujuan">
                    <?php echo get_form_error('link_url', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="button_text" class="form-label">Teks Tombol</label>
                    <input type="text" class="form-control <?php echo isset($form_errors['button_text']) ? 'is-invalid' : ''; ?>" id="button_text" name="button_text" value="<?php echo old_form_data('button_text', '', $form_data); ?>" placeholder="Contoh: Selengkapnya">
                    <div class="form-text">Akan tampil jika URL Tujuan Klik diisi.</div>
                    <?php echo get_form_error('button_text', $form_errors); ?>
                </div>
            </div>
        </div>

        <div class="card mb-4 shadow-sm">
            <div class="card-header"><i class="fas fa-cog me-1"></i> Pengaturan & Penjadwalan</div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="slide_order" class="form-label">Urutan Slide <span class="text-danger">*</span></label>
                        <input type="number" class="form-control <?php echo isset($form_errors['slide_order']) ? 'is-invalid' : ''; ?>" id="slide_order" name="slide_order" value="<?php echo old_form_data('slide_order', '0', $form_data); ?>" min="0" required>
                        <div class="form-text">Angka lebih kecil akan tampil lebih dulu.</div>
                        <?php echo get_form_error('slide_order', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="is_active" class="form-label">Status Slider <span class="text-danger">*</span></label>
                        <select class="form-select <?php echo isset($form_errors['is_active']) ? 'is-invalid' : ''; ?>" id="is_active" name="is_active" required>
                            <option value="1" <?php echo (old_form_data('is_active', '1', $form_data) == '1') ? 'selected' : ''; ?>>Aktif</option>
                            <option value="0" <?php echo (old_form_data('is_active', '1', $form_data) == '0') ? 'selected' : ''; ?>>Nonaktif</option>
                        </select>
                        <?php echo get_form_error('is_active', $form_errors); ?>
                    </div>
                </div>
                <h6 class="mt-3 mb-2 text-muted">Penjadwalan Tayang (Opsional)</h6>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="start_date" class="form-label">Tanggal & Waktu Mulai Tayang</label>
                        <input type="datetime-local" class="form-control <?php echo isset($form_errors['start_date']) ? 'is-invalid' : ''; ?>" id="start_date" name="start_date" value="<?php echo old_form_data('start_date', '', $form_data); ?>">
                        <?php echo get_form_error('start_date', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="end_date" class="form-label">Tanggal & Waktu Selesai Tayang</label>
                        <input type="datetime-local" class="form-control <?php echo isset($form_errors['end_date']) ? 'is-invalid' : ''; ?>" id="end_date" name="end_date" value="<?php echo old_form_data('end_date', '', $form_data); ?>">
                        <?php echo get_form_error('end_date', $form_errors); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="mt-3 mb-5">
            <button type="submit" class="btn btn-primary" id="saveSliderButton"><i class="fas fa-save me-1"></i> Simpan Slider</button>
            <a href="index.php" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
<?php
$page_scripts = []; // Pastikan ini didefinisikan sebagai array
$page_scripts[] = "<script>
// Fungsi untuk menampilkan error form dari AJAX, jika belum ada di global JS
if (typeof displayAdminFormErrors !== 'function') {
    function displayAdminFormErrors(formElement, errors) {
        console.log('Displaying form errors:', errors); // Log untuk debug
        // Hapus error lama dulu
        formElement.find('.is-invalid').removeClass('is-invalid');
        // Menghapus div.invalid-feedback yang dibuat secara dinamis sebelumnya agar tidak duplikat
        formElement.find('.invalid-feedback.custom-error-ajax').remove(); 
        // Kosongkan pesan error bawaan Bootstrap yang mungkin sudah ada dari server-side render (jika ada)
        formElement.find('.invalid-feedback:not(.custom-error-ajax)').html('');

        $.each(errors, function(field, message) {
            const inputField = formElement.find('[name=\"' + field + '\"]');
            if (inputField.length) {
                inputField.addClass('is-invalid');
                // Coba cari .invalid-feedback yang sudah ada (biasanya dari Bootstrap)
                let errorContainer = inputField.siblings('.invalid-feedback'); // Cek sibling dulu
                if (!errorContainer.length) { // Jika tidak ada sibling, cek parent jika input ada di dalam .input-group atau sejenisnya
                     errorContainer = inputField.closest('.mb-3, .col-md-6').find('.invalid-feedback');
                }

                if (errorContainer.length && !errorContainer.hasClass('custom-error-ajax')) {
                    errorContainer.html(message).show(); // Isi container yang sudah ada
                } else {
                    // Jika tidak ada sama sekali, atau yang ada adalah custom-ajax (yang sudah dihapus), buat baru
                    inputField.after('<div class=\"invalid-feedback custom-error-ajax d-block\">' + message + '</div>');
                }
            } else {
                console.warn('Error untuk field \"' + field + '\" tidak dapat ditampilkan karena field tidak ditemukan di form.');
                // Sebagai fallback, tampilkan error umum jika field tidak ditemukan
                if (typeof showAdminNotification === 'function') {
                     showAdminNotification('warning', 'Error validasi pada field \"' + field + '\": ' + message);
                }
            }
        });
    }
}

// Fungsi untuk preview gambar, jika belum ada di global JS
if (typeof initializeImagePreview !== 'function') {
    function initializeImagePreview(inputId, previewId) {
        const inputElement = document.getElementById(inputId);
        const previewElement = document.getElementById(previewId);

        if (inputElement && previewElement) {
            inputElement.addEventListener('change', function(event) {
                const file = event.target.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = function(e) {
                        previewElement.src = e.target.result;
                        previewElement.style.display = 'block';
                    }
                    reader.readAsDataURL(file);
                } else {
                    previewElement.src = '#';
                    previewElement.style.display = 'none';
                }
            });
        }
    }
}


$(document).ready(function() {
    // Inisialisasi image preview
    initializeImagePreview('image_file_desktop', 'imagePreviewDesktop');
    initializeImagePreview('image_file_mobile', 'imagePreviewMobile');

    $('#sliderForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveSliderButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        const formData = new FormData(this); // Kirim sebagai FormData untuk file upload

        // Hapus error sebelumnya
        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error-ajax').remove();
        form.find('.invalid-feedback:not(.custom-error-ajax)').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,  // Penting untuk FormData
            contentType: false, // Penting untuk FormData
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    if (typeof showAdminNotification === 'function') {
                        showAdminNotification('success', response.message || 'Slider berhasil disimpan.');
                    } else {
                        alert(response.message || 'Slider berhasil disimpan.');
                    }
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        // Jika tidak ada redirect, reset form (untuk create)
                        form[0].reset();
                        $('#imagePreviewDesktop').hide().attr('src', '#');
                        $('#imagePreviewMobile').hide().attr('src', '#');
                    }
                } else {
                    const mainMessage = response.message || 'Gagal menyimpan. Periksa error di form.';
                    if (typeof showAdminNotification === 'function') {
                        showAdminNotification('danger', mainMessage);
                    } else {
                        alert(mainMessage);
                    }
                    
                    if (response.errors) {
                        displayAdminFormErrors(form, response.errors);
                    } else {
                        console.error('AJAX success, but server indicated failure without specific field errors:', response);
                    }
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.error('AJAX Error:', textStatus, errorThrown, jqXHR.responseText);
                let errorMsg = 'Kesalahan server saat menyimpan slider.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { 
                    errorMsg = jqXHR.responseJSON.message; 
                } else if (jqXHR.status === 422 && jqXHR.responseText) {
                    // Jika 422 dan ada responseText, coba parse sebagai JSON
                    try {
                        const errResponse = JSON.parse(jqXHR.responseText);
                        if (errResponse.message) errorMsg = errResponse.message;
                        if (errResponse.errors) {
                            displayAdminFormErrors(form, errResponse.errors);
                            // Jangan tampilkan notifikasi umum jika error field sudah ditampilkan
                            errorMsg = errResponse.message || 'Terdapat kesalahan pada input Anda.'; 
                        }
                    } catch (e) {
                        errorMsg = 'Gagal memproses respons error dari server (422).';
                        console.error('Gagal parse JSON dari 422 response:', jqXHR.responseText);
                    }
                } else if (jqXHR.responseText) {
                     // Untuk error lain (misal 500), responseText mungkin HTML error PHP
                     // Anda bisa menampilkannya di console untuk debug, tapi jangan ke user
                     errorMsg += ' (Lihat console log untuk detail teknis).';
                }

                if (typeof showAdminNotification === 'function') {
                    showAdminNotification('danger', errorMsg);
                } else {
                    alert(errorMsg);
                }
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>