<?php
// admin/modules/settings/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Pengaturan Website";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$settings_grouped = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT setting_key, setting_value, description, input_type, setting_group 
                              FROM portal_settings 
                              ORDER BY setting_group ASC, setting_key ASC");
        $all_settings = $stmt->fetchAll();
        foreach ($all_settings as $s) {
            $settings_grouped[$s['setting_group']][$s['setting_key']] = $s;
        }
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data pengaturan: ' . $e->getMessage());
        error_log("Error fetching settings: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Pengaturan Website'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <form action="process_settings.php" method="POST" enctype="multipart/form-data" id="settingsForm">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

        <?php if (empty($settings_grouped)): ?>
            <div class="alert alert-warning">Belum ada pengaturan yang tersedia di database.</div>
        <?php else: ?>
            <?php foreach ($settings_grouped as $group_name => $settings_in_group): ?>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header">
                        <i class="fas fa-cogs me-1"></i>
                        <?php echo esc_html(ucwords(str_replace('_', ' ', $group_name))); ?>
                    </div>
                    <div class="card-body">
                        <?php foreach ($settings_in_group as $key => $setting): ?>
                            <div class="mb-3 row align-items-center">
                                <label for="setting_<?php echo esc_html($key); ?>" class="col-sm-3 col-form-label">
                                    <?php echo esc_html(ucwords(str_replace(['_', 'url'], [' ', ' URL'], $key))); ?>
                                </label>
                                <div class="col-sm-9">
                                    <?php
                                    $value = $setting['setting_value'] ?? '';
                                    $inputType = $setting['input_type'] ?? 'text';
                                    $description = esc_html($setting['description'] ?? '');
                                    $input_name = "settings[" . esc_html($key) . "]";
                                    $file_input_name = "setting_files[" . esc_html($key) . "]"; // Untuk file uploads
                                    ?>

                                    <?php if ($inputType === 'textarea'): ?>
                                        <textarea class="form-control" id="setting_<?php echo esc_html($key); ?>" name="<?php echo $input_name; ?>" rows="3"><?php echo esc_html($value); ?></textarea>
                                    <?php elseif ($inputType === 'boolean'): ?>
                                        <select class="form-select form-select-sm" id="setting_<?php echo esc_html($key); ?>" name="<?php echo $input_name; ?>">
                                            <option value="1" <?php echo ($value == '1' || strtolower($value) === 'true') ? 'selected' : ''; ?>>Ya (Aktif/True)</option>
                                            <option value="0" <?php echo ($value == '0' || strtolower($value) === 'false' || $value === '') ? 'selected' : ''; ?>>Tidak (Nonaktif/False)</option>
                                        </select>
                                    <?php elseif ($inputType === 'image_url' || $inputType === 'file_url'): ?>
                                        <div class="current-file-preview-container mb-2" id="preview_container_<?php echo esc_html($key); ?>">
                                            <?php if (!empty($value)): ?>
                                                <?php
                                                $file_exists_on_server = file_exists($project_root . '/' . $value);
                                                if ($file_exists_on_server):
                                                ?>
                                                    <?php if ($inputType === 'image_url'): ?>
                                                        <img src="<?php echo resolve_url(esc_html($value)); ?>" alt="Preview <?php echo esc_html($key); ?>" class="img-thumbnail me-2" style="max-height: 60px; max-width: 150px;">
                                                    <?php else: // file_url ?>
                                                        <a href="<?php echo resolve_url(esc_html($value)); ?>" target="_blank" rel="noopener noreferrer" class="me-2"><i class="fas fa-file-alt me-1"></i><?php echo basename(esc_html($value)); ?></a>
                                                    <?php endif; ?>
                                                    <button type="button" class="btn btn-sm btn-outline-danger remove-file-btn" data-setting-key="<?php echo esc_html($key); ?>" title="Hapus file saat ini"><i class="fas fa-times"></i></button>
                                                <?php else: ?>
                                                    <span class="text-muted small fst-italic">File (<?php echo esc_html($value); ?>) tidak ditemukan.</span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="text-muted small fst-italic">Belum ada file.</span>
                                            <?php endif; ?>
                                        </div>
                                        <input type="file" class="form-control form-control-sm" id="setting_<?php echo esc_html($key); ?>" name="<?php echo $file_input_name; ?>" onchange="previewSettingFile(event, '<?php echo esc_html($key); ?>', '<?php echo $inputType; ?>')">
                                        <input type="hidden" name="<?php echo $input_name; ?>" value="<?php echo esc_html($value); ?>" id="hidden_setting_<?php echo esc_html($key); ?>">
                                        <div class="form-text small">Upload file baru untuk mengganti.</div>
                                    <?php else: ?>
                                        <input type="<?php echo esc_html($inputType); ?>" class="form-control form-control-sm" id="setting_<?php echo esc_html($key); ?>" name="<?php echo $input_name; ?>" value="<?php echo esc_html($value); ?>">
                                    <?php endif; ?>

                                    <?php if (!empty($description)): ?>
                                        <div class="form-text text-muted small mt-1"><?php echo $description; ?></div>
                                    <?php endif; ?>
                                    <div id="error_<?php echo esc_html($key); ?>" class="invalid-feedback custom-error"></div> </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>

        <div class="mt-4 mb-5">
            <button type="submit" class="btn btn-primary btn-lg" id="saveSettingsButton"><i class="fas fa-save me-1"></i> Simpan Semua Pengaturan</button>
        </div>
    </form>
</div>

<?php
$page_scripts = []; // Reset
$page_scripts[] = "<script>
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.remove-file-btn').forEach(button => {
        button.addEventListener('click', function() {
            const settingKey = this.dataset.settingKey;
            const hiddenInput = document.getElementById('hidden_setting_' + settingKey);
            const previewContainer = document.getElementById('preview_container_' + settingKey); 
            const fileInput = document.getElementById('setting_' + settingKey); 

            if (confirm('Anda yakin ingin menghapus file ini? Perubahan akan disimpan saat Anda klik \\'Simpan Semua Pengaturan\\'.')) {
                if (hiddenInput) {
                    hiddenInput.value = ''; 
                }
                if (previewContainer) {
                    previewContainer.innerHTML = '<p class=\"small text-danger fst-italic\">File akan dihapus saat disimpan.</p>';
                }
                if (fileInput) {
                   fileInput.value = ''; 
                }
            }
        });
    });

    window.previewSettingFile = function(event, settingKey, inputType) {
        const file = event.target.files[0];
        if (!file) return;

        const previewContainer = document.getElementById('preview_container_' + settingKey);
        const hiddenInput = document.getElementById('hidden_setting_' + settingKey);
        
        previewContainer.innerHTML = ''; 

        if (inputType === 'image_url' && file.type.startsWith('image/')) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.alt = 'Preview baru';
                img.className = 'img-thumbnail me-2';
                img.style.maxHeight = '60px';
                img.style.maxWidth = '150px';
                previewContainer.appendChild(img);
            }
            reader.readAsDataURL(file);
        } else if (inputType === 'file_url') {
            const p = document.createElement('p');
            p.className = 'small text-info fst-italic';
            p.innerHTML = '<i class=\"fas fa-file-alt me-1\"></i> File baru dipilih: ' + escapeHtml(file.name);
            previewContainer.appendChild(p);
        }
    }

    function escapeHtml(unsafe) {
        if (typeof unsafe !== 'string') {
            return '';
        }
        return unsafe
            .replace(/&/g, \"&amp;\")
            .replace(/</g, \"&lt;\")
            .replace(/>/g, \"&gt;\")
            .replace(/\\\"/g, \"&quot;\") 
            .replace(/'/g, \"&#039;\");
    }

    $('#settingsForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveSettingsButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        const formData = new FormData(this);

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.upload_errors && response.upload_errors.length > 0) {
                        let uploadErrorMsg = 'Beberapa file gagal diunggah:<br>';
                        // Corrected line below
                        response.upload_errors.forEach(err_msg => uploadErrorMsg += `- \${err_msg}<br>`);
                        showAdminNotification('warning', uploadErrorMsg);
                    }
                    setTimeout(function() { window.location.reload(); }, 2000);
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan pengaturan.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        let errorHtml = '';
                        $.each(response.errors, function(key, value) {
                            errorHtml += `<p class='text-danger small'><strong>\${key}:</strong> \${value}</p>`;
                            $('#setting_' + key).addClass('is-invalid');
                            $('#error_' + key).html(value).show();
                        });
                        if(errorHtml) {
                            $('#saveSettingsButton').after('<div class=\"mt-2 server-form-errors\">' + errorHtml + '</div>');
                        }
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan pengaturan.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>