<?php
// admin/modules/quick_links/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Tautan Cepat";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$quick_links = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT id, title, url, icon_class, link_order, is_active, group_key, open_in_new_tab, description
                             FROM portal_quick_links
                             ORDER BY group_key ASC, link_order ASC, title ASC");
        $quick_links = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data tautan cepat: ' . $e->getMessage());
        error_log("Error fetching quick links: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Tautan Cepat'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Tautan Cepat Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-link me-1"></i>
            Daftar Tautan Cepat
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableQuickLinks" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Judul</th>
                            <th>URL</th>
                            <th>Ikon</th>
                            <th>Grup</th>
                            <th>Urutan</th>
                            <th>Status</th>
                            <th>Tab Baru</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($quick_links) > 0): ?>
                            <?php foreach ($quick_links as $index => $link): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <?php echo esc_html($link['title']); ?>
                                    <?php if(!empty($link['description'])): ?>
                                        <small class="d-block text-muted" title="<?php echo esc_html($link['description']); ?>">
                                            <?php echo esc_html(substr($link['description'], 0, 50)) . (strlen($link['description']) > 50 ? '...' : ''); ?>
                                        </small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo esc_html($link['url']); ?>" target="_blank" rel="noopener noreferrer" title="<?php echo esc_html($link['url']); ?>">
                                        <?php echo esc_html(substr($link['url'], 0, 30)) . (strlen($link['url']) > 30 ? '...' : ''); ?>
                                    </a>
                                </td>
                                <td class="text-center">
                                    <?php if (!empty($link['icon_class'])): ?>
                                        <i class="<?php echo esc_html($link['icon_class']); ?>" title="<?php echo esc_html($link['icon_class']); ?>"></i>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td><?php echo esc_html($link['group_key'] ?? 'general'); ?></td>
                                <td class="text-center"><?php echo esc_html($link['link_order']); ?></td>
                                <td class="text-center">
                                    <?php if ($link['is_active']): ?>
                                        <span class="badge bg-success">Aktif</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Nonaktif</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo $link['open_in_new_tab'] ? 'Ya' : 'Tidak'; ?></td>
                                <td class="text-center">
                                    <a href="edit.php?id=<?php echo $link['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-quicklink"
                                            data-id="<?php echo $link['id']; ?>"
                                            data-title="<?php echo esc_html(addslashes($link['title'])); ?>"
                                            data-url="process_quick_link.php?action=delete&id=<?php echo $link['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                       <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" class="text-center">Belum ada tautan cepat.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <p class="text-muted small mt-2">Pengelompokan berdasarkan "Kunci Grup". Urutan berdasarkan nilai "Urutan Tautan" (lebih kecil tampil lebih dulu).</p>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableQuickLinks').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 4, \"asc\" ], [ 5, \"asc\" ]] // Order by Grup, then Urutan
        });

        // AJAX Delete untuk Tautan Cepat
        $('#dataTableQuickLinks').on('click', '.btn-delete-quicklink', function() {
            const button = $(this);
            const linkTitle = button.data('title');
            const deleteUrl = button.data('url');

            if (confirm('Anda yakin ingin menghapus tautan cepat: ' + linkTitle + '?')) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus tautan.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus tautan.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>