<?php
// admin/modules/pages/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Halaman Statis";
$page_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($page_id_to_edit <= 0) { /* ... handle error ... */ }
$page_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_pages WHERE id = :id");
        $stmt->execute([':id' => $page_id_to_edit]);
        $page_db_data = $stmt->fetch();
    } catch (\PDOException $e) { /* ... error handling ... */ }
}
if (!$page_db_data) { /* ... handle not found ... */ }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => $page_db_data['title'], 'slug' => $page_db_data['slug'],
    'content_html' => $page_db_data['content_html'], 'status' => $page_db_data['status'],
    'published_at' => $page_db_data['published_at'] ? date('Y-m-d\TH:i', strtotime($page_db_data['published_at'])) : '',
    'meta_keywords' => $page_db_data['meta_keywords'], 'meta_description' => $page_db_data['meta_description'],
    'template' => $page_db_data['template'], 'page_order' => $page_db_data['page_order']
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?>: <?php echo esc_html($page_db_data['title']); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_page.php" method="POST" id="pageForm">
        <input type="hidden" name="action" value="edit">
        <input type="hidden" name="id" value="<?php echo $page_db_data['id']; ?>">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

        <!-- Struktur Row dan Card sama seperti create.php, value dari $page_db_data -->
        <div class="row">
            <div class="col-lg-9">
                 <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-file-alt me-1"></i> Konten Halaman</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', $page_db_data['title'], $form_data); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label for="slug" class="form-label">Slug</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', $page_db_data['slug'], $form_data); ?>">
                        </div>
                        <div class="mb-3">
                            <label for="content_html" class="form-label">Isi <span class="text-danger">*</span></label>
                            <textarea class="form-control tinymce-full-pages" id="content_html" name="content_html" rows="20"><?php echo old_form_data('content_html', $page_db_data['content_html'], $form_data); ?></textarea>
                        </div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-search-dollar me-1"></i> SEO</div>
                    <div class="card-body">
                         <div class="mb-3"><label for="meta_keywords" class="form-label">Keywords</label><input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo old_form_data('meta_keywords', $page_db_data['meta_keywords'], $form_data); ?>"></div>
                        <div class="mb-3"><label for="meta_description" class="form-label">Description</label><textarea class="form-control" id="meta_description" name="meta_description" rows="3" maxlength="160"><?php echo old_form_data('meta_description', $page_db_data['meta_description'], $form_data); ?></textarea></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="card mb-4 shadow-sm sticky-lg-top" style="top: 70px;">
                    <div class="card-header"><i class="fas fa-cogs me-1"></i> Publikasi</div>
                    <div class="card-body">
                        <div class="mb-3"><label for="status" class="form-label">Status <span class="text-danger">*</span></label><select class="form-select" id="status" name="status" required>
                             <option value="draft" <?php echo (old_form_data('status', $page_db_data['status'], $form_data) == 'draft') ? 'selected' : ''; ?>>Draft</option>
                             <option value="published" <?php echo (old_form_data('status', $page_db_data['status'], $form_data) == 'published') ? 'selected' : ''; ?>>Published</option>
                             <option value="pending" <?php echo (old_form_data('status', $page_db_data['status'], $form_data) == 'pending') ? 'selected' : ''; ?>>Pending</option>
                        </select></div>
                        <div class="mb-3"><label for="published_at" class="form-label">Tgl Publikasi</label><input type="datetime-local" class="form-control" id="published_at" name="published_at" value="<?php echo old_form_data('published_at', $page_db_data['published_at'] ? date('Y-m-d\TH:i', strtotime($page_db_data['published_at'])) : '', $form_data); ?>"></div>
                        <button type="submit" class="btn btn-primary w-100" id="savePageButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    </div>
                </div>
                 <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-puzzle-piece me-1"></i> Atribut</div>
                    <div class="card-body">
                        <div class="mb-3"><label for="template" class="form-label">Template</label><input type="text" class="form-control" id="template" name="template" value="<?php echo old_form_data('template', $page_db_data['template'], $form_data); ?>"></div>
                        <div class="mb-3"><label for="page_order" class="form-label">Urutan</label><input type="number" class="form-control" id="page_order" name="page_order" value="<?php echo old_form_data('page_order', $page_db_data['page_order'], $form_data); ?>" min="0"></div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php
// Skrip AJAX, TinyMCE, slug sama seperti di create.php untuk pages
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js";
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof tinymce !== 'undefined') { tinymce.init({ selector: 'textarea.tinymce-full-pages', /* ... Konfig TinyMCE ... */ }); }
    if (typeof initializeSlugGenerator === 'function') { initializeSlugGenerator('title', 'slug'); }
    $('#pageForm').on('submit', function(e) { /* ... AJAX submit logic ... */ });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>