<?php
// admin/modules/menus/process_menu.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Definisikan path absolut dan muat file yang diperlukan
if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3));
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

// Cek hak akses dan koneksi database
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin' || !isset($pdo)) {
    // Untuk request AJAX, kirim error JSON. Untuk request biasa, redirect.
    if (!empty($_SERVER['HTTP_X_REQUESTED_WITH'])) {
        http_response_code(403);
        echo json_encode(['success' => false, 'message' => 'Akses ditolak atau koneksi database gagal.']);
    } else {
        set_flash_message('danger', 'Akses ditolak atau koneksi database gagal.');
        header('Location: ../../login.php');
    }
    exit;
}

// Ambil aksi dari POST atau GET
$action = $_POST['action'] ?? $_GET['action'] ?? null;

// Validasi CSRF Token untuk semua aksi yang mengubah data
$csrf_token = $_POST['csrf_token'] ?? $_GET['csrf_token'] ?? null;
$actions_that_need_csrf = [
    'create_group', 'edit_group', 'delete_group', 
    'add_item', 'edit_item', 'delete_item', 'save_order'
];

if (in_array($action, $actions_that_need_csrf)) {
    if (!$csrf_token || !validate_csrf_token($csrf_token)) {
        $message = "Kesalahan keamanan: CSRF Token tidak valid.";
        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH'])) {
            http_response_code(403);
            echo json_encode(['success' => false, 'message' => $message]);
        } else {
            set_flash_message('danger', $message);
            header('Location: index.php');
        }
        exit;
    }
}

$is_ajax = !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest';

// --- ROUTER AKSI ---
try {
    switch ($action) {
        // --- AKSI UNTUK GRUP MENU (dari kode lama, sudah benar) ---
        case 'create_group':
        case 'edit_group':
            // Logika ini sudah benar, jadi kita pertahankan
            $name = trim($_POST['name'] ?? '');
            $location = trim($_POST['location'] ?? '');
            $description = trim($_POST['description'] ?? '');
            $id = (int)($_POST['id'] ?? 0);
            // Anda bisa menambahkan validasi di sini jika perlu
            if ($action === 'create_group') {
                $stmt = $pdo->prepare("INSERT INTO portal_menus (name, location, description) VALUES (?, ?, ?)");
                $stmt->execute([$name, $location, $description]);
                $id = $pdo->lastInsertId();
            } else {
                $stmt = $pdo->prepare("UPDATE portal_menus SET name = ?, location = ?, description = ? WHERE id = ?");
                $stmt->execute([$name, $location, $description, $id]);
            }
            set_flash_message('success', 'Grup menu berhasil disimpan.');
            header('Location: manage_menu_items.php?menu_id=' . $id);
            exit;

        case 'delete_group':
            $id = (int)($_GET['id'] ?? 0);
            // Pastikan ON DELETE CASCADE aktif pada foreign key di tabel portal_menu_items
            $stmt = $pdo->prepare("DELETE FROM portal_menus WHERE id = ?");
            $stmt->execute([$id]);
            set_flash_message('success', 'Grup menu berhasil dihapus.');
            header('Location: index.php');
            exit;

        // --- LOGIKA BARU UNTUK ITEM MENU ---
        case 'add_item':
            $menu_id = (int)($_POST['menu_id'] ?? 0);
            $stmt = $pdo->prepare(
                "INSERT INTO portal_menu_items (menu_id, title, url, target, css_class, icon_class, item_order) VALUES (?, ?, ?, ?, ?, ?, 999)"
            );
            $stmt->execute([
                $menu_id,
                trim($_POST['title']),
                trim($_POST['url']),
                $_POST['target'],
                trim($_POST['css_class']),
                trim($_POST['icon_class'])
            ]);
            set_flash_message('success', 'Item menu berhasil ditambahkan.');
            header('Location: manage_menu_items.php?menu_id=' . $menu_id);
            exit;

        case 'edit_item':
            $menu_id = (int)($_POST['menu_id'] ?? 0);
            $stmt = $pdo->prepare(
                "UPDATE portal_menu_items SET title = ?, url = ?, target = ?, css_class = ?, icon_class = ? WHERE id = ?"
            );
            $stmt->execute([
                trim($_POST['title']),
                trim($_POST['url']),
                $_POST['target'],
                trim($_POST['css_class']),
                trim($_POST['icon_class']),
                (int)$_POST['id']
            ]);
            set_flash_message('success', 'Item menu berhasil diperbarui.');
            header('Location: manage_menu_items.php?menu_id=' . $menu_id);
            exit;

        case 'delete_item':
            $id = (int)($_GET['id'] ?? 0);
            $menu_id = (int)($_GET['menu_id'] ?? 0);
            // Fungsi rekursif untuk menghapus item beserta semua turunannya
            function delete_item_recursive($pdo, $item_id) {
                $stmt_children = $pdo->prepare("SELECT id FROM portal_menu_items WHERE parent_id = ?");
                $stmt_children->execute([$item_id]);
                $children = $stmt_children->fetchAll(PDO::FETCH_COLUMN);
                foreach ($children as $child_id) {
                    delete_item_recursive($pdo, $child_id); // Hapus anak dari anak
                }
                // Hapus item itu sendiri
                $stmt_delete = $pdo->prepare("DELETE FROM portal_menu_items WHERE id = ?");
                $stmt_delete->execute([$item_id]);
            }
            if ($id > 0) {
                delete_item_recursive($pdo, $id);
            }
            set_flash_message('success', 'Item menu dan semua submenunya berhasil dihapus.');
            header('Location: manage_menu_items.php?menu_id=' . $menu_id);
            exit;

        case 'save_order':
            // Ini adalah logika kunci untuk menangani hasil drag-and-drop
            if (!$is_ajax) die('Aksi ini hanya bisa diakses via AJAX.');

            $order_data = json_decode($_POST['order'], true);
            
            if (is_array($order_data)) {
                $pdo->beginTransaction(); // Mulai transaksi untuk memastikan semua query berhasil
                
                // Fungsi rekursif untuk memperbarui database
                function update_order_recursive($items, $parent_id, $pdo) {
                    foreach ($items as $index => $item) {
                        // Ambil ID dari array yang diserialisasi
                        $item_id = (int)($item['item_id'] ?? $item['id']);
                        if ($item_id == 0) continue; // Lewati jika ID tidak valid

                        // Update parent_id dan item_order untuk item ini
                        $stmt = $pdo->prepare("UPDATE portal_menu_items SET parent_id = ?, item_order = ? WHERE id = ?");
                        $stmt->execute([$parent_id, $index, $item_id]);

                        // Jika ada anak, panggil fungsi ini lagi untuk mereka
                        if (isset($item['children']) && is_array($item['children'])) {
                            update_order_recursive($item['children'], $item_id, $pdo);
                        }
                    }
                }
                
                // Mulai proses update dari level teratas (yang tidak punya induk)
                update_order_recursive($order_data, null, $pdo);
                
                $pdo->commit(); // Selesaikan transaksi jika semua query berhasil
                
                header('Content-Type: application/json');
                echo json_encode(['success' => true]);
            } else {
                header('Content-Type: application/json');
                http_response_code(400); // Bad Request
                echo json_encode(['success' => false, 'message' => 'Data order tidak valid.']);
            }
            exit;

        default:
            header('Location: index.php');
            exit;
    }
} catch (PDOException $e) {
    if (isset($pdo) && $pdo->inTransaction()) {
        $pdo->rollBack(); // Batalkan transaksi jika terjadi error
    }
    error_log("Menu Processing Error: " . $e->getMessage());
    if ($is_ajax) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Terjadi kesalahan pada database.']);
    } else {
        set_flash_message('danger', 'Terjadi kesalahan pada database. Silakan coba lagi.');
        $redirect_id = $_POST['menu_id'] ?? $_GET['menu_id'] ?? 0;
        header('Location: ' . ($redirect_id ? 'manage_menu_items.php?menu_id=' . $redirect_id : 'index.php'));
    }
    exit;
}