<?php
// admin/modules/menus/edit.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Edit Grup Menu";
$group_id_to_edit = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($group_id_to_edit <= 0) { set_flash_message('danger', 'ID Grup Menu tidak valid.'); header('Location: index.php'); exit; }
$group_db_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_menus WHERE id = :id");
        $stmt->execute([':id' => $group_id_to_edit]);
        $group_db_data = $stmt->fetch();
    } catch (\PDOException $e) { set_flash_message('danger', 'Gagal mengambil data: ' . $e->getMessage()); error_log($e->getMessage());}
}
if (!$group_db_data) { set_flash_message('danger', 'Grup menu tidak ditemukan.'); header('Location: index.php'); exit; }

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'name' => $group_db_data['name'], 'location' => $group_db_data['location'],
    'description' => $group_db_data['description']
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Grup Menu', 'url' => 'index.php'],
        'Edit Grup Menu: ' . esc_html($group_db_data['name'])
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <div class="mb-3">
        <a href="manage_menu_items.php?menu_id=<?php echo $group_db_data['id']; ?>" class="btn btn-info"><i class="fas fa-list-ul me-1"></i> Kelola Item untuk Menu Ini</a>
    </div>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-edit me-1"></i> Formulir Edit Grup Menu: <?php echo esc_html($group_db_data['name']); ?></div>
        <div class="card-body">
            <form action="process_menu.php" method="POST" id="menuGroupForm">
                <input type="hidden" name="action" value="edit_group">
                <input type="hidden" name="id" value="<?php echo $group_db_data['id']; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Grup Menu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo old_form_data('name', $group_db_data['name'], $form_data); ?>" required>
                    <?php echo get_form_error('name', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="location" class="form-label">Kunci Lokasi (Identifier Tema) <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="location" name="location" value="<?php echo old_form_data('location', $group_db_data['location'], $form_data); ?>" required>
                    <?php echo get_form_error('location', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi (Opsional)</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo old_form_data('description', $group_db_data['description'], $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveMenuGroupButton"><i class="fas fa-save me-1"></i> Simpan Perubahan</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
// Skrip AJAX sama seperti di create.php untuk menu group
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    $('#menuGroupForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveMenuGroupButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    // Untuk edit, biasanya tidak redirect, tapi bisa jika ingin kembali ke index
                    // Jika redirect_url dikirim dari backend (misal ke manage_items), ikuti itu
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1000);
                    }
                    // Mungkin update judul halaman jika nama grup berubah
                    if(form.find('#name').length > 0) {
                        const newName = form.find('#name').val();
                        $('h1.mt-4.mb-4').text('Edit Grup Menu: ' + escapeHtmlJs(newName));
                        $('.card-header:contains(\"Formulir Edit Grup Menu\")').html('<i class=\"fas fa-edit me-1\"></i> Formulir Edit Grup Menu: ' + escapeHtmlJs(newName));
                    }

                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan grup menu.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
    function escapeHtmlJs(unsafe) { /* ... implementasi ... */ }
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>