<?php
// admin/modules/menus/create.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Grup Menu Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? ['name' => '', 'location' => '', 'description' => ''];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Grup Menu', 'url' => 'index.php'],
        'Tambah Grup Menu Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Formulir Grup Menu Baru</div>
        <div class="card-body">
            <form action="process_menu.php" method="POST" id="menuGroupForm">
                <input type="hidden" name="action" value="create_group">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Grup Menu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo old_form_data('name', '', $form_data); ?>" required>
                    <div class="form-text">Contoh: Navigasi Utama, Menu Footer.</div>
                    <?php echo get_form_error('name', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="location" class="form-label">Kunci Lokasi (Identifier Tema) <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="location" name="location" value="<?php echo old_form_data('location', '', $form_data); ?>" placeholder="Contoh: primary_nav, footer_links" required>
                    <div class="form-text">Unik, huruf kecil, angka, underscore (_). Digunakan tema.</div>
                    <?php echo get_form_error('location', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi (Opsional)</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo old_form_data('description', '', $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveMenuGroupButton"><i class="fas fa-save me-1"></i> Simpan Grup Menu</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    $('#menuGroupForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveMenuGroupButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) { // process_menu.php akan redirect ke manage_menu_items.php
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1000);
                    } else {
                        form[0].reset(); // Reset form jika tidak ada redirect
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan grup menu.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>