<?php
// admin/modules/menus/create_edit_menu.php - Form Tambah/Edit Grup Menu

// Pastikan config.php dimuat paling awal
if (file_exists(dirname(__DIR__, 3) . '/config.php')) {
    require_once dirname(__DIR__, 3) . '/config.php';
} else {
    if (file_exists(dirname(__FILE__, 4) . '/config.php')) {
        require_once dirname(__FILE__, 4) . '/config.php';
    } else {
        die("CRITICAL FAILURE: config.php not found from create_edit_menu.php");
    }
}

// Cek otentikasi dan otorisasi
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    set_flash_message('danger', 'Anda tidak memiliki izin untuk mengakses halaman ini.');
    header('Location: ' . admin_url('login.php')); 
    exit;
}

// Inisialisasi variabel
$menu_group_id = isset($_GET['id']) ? (int)$_GET['id'] : null;
$menu_data_for_form = [ // Default data untuk form tambah
    'name' => '', 
    'location' => '', 
    'description' => ''
];
$form_action_to_process = 'create_group'; // Aksi default untuk process_menu.php
$page_title_action_label = "Tambah"; // Label untuk judul halaman dan tombol

// Jika ini adalah mode edit, ambil data grup menu dari database
if ($menu_group_id && isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT id, name, location, description FROM portal_menus WHERE id = :id");
        $stmt->execute([':id' => $menu_group_id]);
        $fetched_menu_data = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($fetched_menu_data) {
            $menu_data_for_form = $fetched_menu_data;
            $form_action_to_process = 'edit_group';
            $page_title_action_label = "Edit";
        } else {
            set_flash_message('danger', 'Grup menu yang akan diedit tidak ditemukan.');
            header('Location: ' . admin_url('modules/menus/index.php')); 
            exit;
        }
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data grup menu untuk diedit: Terjadi kesalahan database.');
        error_log("Error fetching menu group for edit (ID: $menu_group_id): " . $e->getMessage());
        header('Location: ' . admin_url('modules/menus/index.php')); 
        exit;
    }
} elseif ($menu_group_id === 0 && isset($_GET['id'])) { // Jika id=0 atau tidak valid di URL
    set_flash_message('danger', 'ID Grup menu tidak valid.');
    header('Location: ' . admin_url('modules/menus/index.php')); 
    exit;
}


$page_title = $page_title_action_label . " Grup Menu";

// Ambil data form dari session jika ada error validasi sebelumnya (untuk repopulate form)
if (isset($_SESSION['form_data_menu_group'])) {
    $menu_data_for_form = array_merge($menu_data_for_form, $_SESSION['form_data_menu_group']);
    unset($_SESSION['form_data_menu_group']);
}
$form_errors_from_session = $_SESSION['form_errors_menu_group'] ?? [];
if (isset($_SESSION['form_errors_menu_group'])) {
    unset($_SESSION['form_errors_menu_group']);
}

// Include header admin
require_once PROJECT_ROOT . '/admin/includes/header.php';
?>

<div class="container-fluid px-4">
    <?php 
    echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => admin_url('index.php')],
        ['label' => 'Manajemen Menu', 'url' => admin_url('modules/menus/index.php')],
        ['label' => 'Daftar Grup Menu', 'url' => admin_url('modules/menus/index.php')],
        $page_title_action_label . ' Grup Menu'
    ]); 
    ?>

    <h1 class="mt-4 mb-4"><?php echo esc_html($page_title); ?></h1>
    <hr class="mb-4">

    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header">
            <i class="fas fa-list-alt me-1"></i> Form <?php echo esc_html($page_title_action_label); ?> Grup Menu
        </div>
        <div class="card-body">
            <form action="<?php echo admin_url('modules/menus/process_menu.php'); ?>" method="POST" id="menuGroupForm">
                <input type="hidden" name="action" value="<?php echo $form_action_to_process; ?>">
                <?php if ($menu_group_id): // Hanya ada jika mode edit ?>
                    <input type="hidden" name="menu_group_id" value="<?php echo $menu_group_id; ?>">
                <?php endif; ?>
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Grup Menu <span class="text-danger">*</span></label>
                    <input type="text" class="form-control <?php echo isset($form_errors_from_session['name']) ? 'is-invalid' : ''; ?>" 
                           id="name" name="name" 
                           value="<?php echo esc_html($menu_data_for_form['name']); ?>" required>
                    <?php if (isset($form_errors_from_session['name'])): ?>
                        <div class="invalid-feedback"><?php echo esc_html($form_errors_from_session['name']); ?></div>
                    <?php endif; ?>
                </div>

                <div class="mb-3">
                    <label for="location" class="form-label">Kunci Lokasi <span class="text-danger">*</span></label>
                    <input type="text" class="form-control <?php echo isset($form_errors_from_session['location']) ? 'is-invalid' : ''; ?>" 
                           id="location" name="location" 
                           value="<?php echo esc_html($menu_data_for_form['location']); ?>" 
                           placeholder="e.g., primary_nav_public, footer_links" 
                           pattern="[a-z0-9_]+" 
                           title="Hanya huruf kecil, angka, dan underscore (_)."
                           required>
                    <div class="form-text">
                        Kunci unik ini digunakan oleh tema untuk menampilkan menu di lokasi yang benar. 
                        Hanya gunakan huruf kecil, angka, dan underscore (contoh: <code>primary_nav</code>).
                    </div>
                    <?php if (isset($form_errors_from_session['location'])): ?>
                        <div class="invalid-feedback"><?php echo esc_html($form_errors_from_session['location']); ?></div>
                    <?php endif; ?>
                </div>

                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi (Opsional)</label>
                    <textarea class="form-control <?php echo isset($form_errors_from_session['description']) ? 'is-invalid' : ''; ?>" 
                              id="description" name="description" 
                              rows="3"><?php echo esc_html($menu_data_for_form['description']); ?></textarea>
                    <?php if (isset($form_errors_from_session['description'])): ?>
                        <div class="invalid-feedback"><?php echo esc_html($form_errors_from_session['description']); ?></div>
                    <?php endif; ?>
                </div>
                
                <div class="d-flex justify-content-between align-items-center pt-3 border-top mt-4">
                    <a href="<?php echo admin_url('modules/menus/index.php'); ?>" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar
                    </a>
                    <button type="submit" class="btn btn-primary" id="submitMenuGroupButton">
                        <i class="fas fa-save me-1"></i> <?php echo $menu_group_id ? 'Simpan Perubahan' : 'Buat Grup Menu'; ?>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
$page_scripts = [];
// Script untuk validasi client-side sederhana (opsional, karena validasi utama di server)
$page_scripts[] = "<script>
    $(document).ready(function() {
        // Validasi form sederhana (bisa menggunakan Bootstrap validation atau library lain)
        $('#menuGroupForm').on('submit', function(event) {
            let isValid = true;
            // Hapus error sebelumnya
            $('.is-invalid').removeClass('is-invalid');
            $('.invalid-feedback').text('');

            const nameField = $('#name');
            if (nameField.val().trim() === '') {
                nameField.addClass('is-invalid').siblings('.invalid-feedback').text('Nama grup menu wajib diisi.');
                isValid = false;
            }

            const locationField = $('#location');
            if (locationField.val().trim() === '') {
                locationField.addClass('is-invalid').siblings('.invalid-feedback').text('Kunci lokasi wajib diisi.');
                isValid = false;
            } else if (!/^[a-z0-9_]+$/.test(locationField.val().trim())) {
                locationField.addClass('is-invalid').siblings('.invalid-feedback').text('Kunci lokasi hanya boleh berisi huruf kecil, angka, dan underscore.');
                isValid = false;
            }
            
            if (!isValid) {
                event.preventDefault(); // Hentikan submit jika tidak valid
                showAdminNotification('warning', 'Harap periksa kembali input Anda. Ada field yang belum terisi dengan benar.');
            } else {
                $('#submitMenuGroupButton').prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\" role=\"status\" aria-hidden=\"true\"></span> Memproses...');
            }
        });
    });
</script>";

require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>