<?php
// admin/modules/gallery_albums/manage_items.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$album_id = isset($_GET['album_id']) ? (int)$_GET['album_id'] : 0;

if ($album_id <= 0) {
    set_flash_message('danger', 'ID Album tidak valid.');
    header('Location: index.php'); // Redirect to albums list
    exit;
}

$album = null;
$gallery_items = [];

if (isset($pdo)) {
    try {
        $stmt_album = $pdo->prepare("SELECT id, title FROM portal_gallery_albums WHERE id = :id");
        $stmt_album->execute([':id' => $album_id]);
        $album = $stmt_album->fetch();

        if ($album) {
            $stmt_items = $pdo->prepare("SELECT * FROM portal_gallery_items WHERE album_id = :album_id ORDER BY item_order ASC, created_at ASC");
            $stmt_items->execute([':album_id' => $album_id]);
            $gallery_items = $stmt_items->fetchAll();
        } else {
            set_flash_message('danger', 'Album tidak ditemukan.');
            header('Location: index.php');
            exit;
        }
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data: ' . $e->getMessage());
        error_log("Error in manage_items.php: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}

$page_title = "Kelola Item Galeri: " . esc_html($album['title'] ?? 'Album Tidak Diketahui');
require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

// For add item form repopulation
$form_data_item_add = $_SESSION['form_data_item_add'] ?? [
    'item_type' => 'image', 'item_url_embed' => '', 'item_title' => '',
    'item_caption' => '', 'item_order' => 0
];
$form_errors_item_add = $_SESSION['form_errors_item_add'] ?? [];
if (isset($_SESSION['form_data_item_add'])) unset($_SESSION['form_data_item_add']);
if (isset($_SESSION['form_errors_item_add'])) unset($_SESSION['form_errors_item_add']);

// For edit item modal repopulation (less direct, usually handled by JS, but can prime if redirect with error)
$form_data_item_edit = $_SESSION['form_data_item_edit'] ?? [];
$form_errors_item_edit = $_SESSION['form_errors_item_edit'] ?? [];
if (isset($_SESSION['form_data_item_edit'])) unset($_SESSION['form_data_item_edit']);
if (isset($_SESSION['form_errors_item_edit'])) unset($_SESSION['form_errors_item_edit']);

?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Album Galeri', 'url' => 'index.php'],
        ['label' => esc_html($album['title']), 'url' => 'edit.php?id=' . $album_id],
        'Kelola Item'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo $page_title; ?></h1>
    <div class="mb-3">
        <a href="edit.php?id=<?php echo $album_id; ?>" class="btn btn-outline-secondary"><i class="fas fa-arrow-left me-1"></i> Kembali ke Edit Album</a>
    </div>

    <?php echo display_flash_message(); ?>

    <div class="card mb-4">
        <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Tambah Item ke Album</div>
        <div class="card-body">
            <form action="process_gallery_item.php" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add_item">
                <input type="hidden" name="album_id" value="<?php echo $album_id; ?>">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="add_item_type" class="form-label">Tipe Item <span class="text-danger">*</span></label>
                        <select class="form-select <?php echo isset($form_errors_item_add['item_type']) ? 'is-invalid' : ''; ?>" id="add_item_type" name="item_type" required>
                            <option value="image" <?php echo (old_form_data('item_type', 'image', $form_data_item_add) == 'image') ? 'selected' : ''; ?>>Gambar</option>
                            <option value="video_embed" <?php echo (old_form_data('item_type', 'image', $form_data_item_add) == 'video_embed') ? 'selected' : ''; ?>>Embed Video (YouTube/Vimeo)</option>
                        </select>
                        <?php echo get_form_error('item_type', $form_errors_item_add); ?>
                    </div>
                    <div class="col-md-6 mb-3" id="add_item_file_container">
                        <label for="add_item_file" class="form-label">Upload File Gambar</label>
                        <input type="file" class="form-control <?php echo isset($form_errors_item_add['item_file']) ? 'is-invalid' : ''; ?>" id="add_item_file" name="item_file" accept="image/jpeg, image/png, image/gif, image/webp">
                        <?php echo get_form_error('item_file', $form_errors_item_add); ?>
                    </div>
                </div>
                <div class="mb-3" id="add_item_url_embed_container" style="display:none;">
                    <label for="add_item_url_embed" class="form-label">URL Embed Video</label>
                    <input type="url" class="form-control <?php echo isset($form_errors_item_add['item_url_embed']) ? 'is-invalid' : ''; ?>" id="add_item_url_embed" name="item_url_embed" value="<?php echo old_form_data('item_url_embed', '', $form_data_item_add); ?>" placeholder="Contoh: https://www.youtube.com/embed/VIDEO_ID/embed/VIDEO_ID">
                    <div class="form-text">Pastikan URL adalah URL embed yang valid dari YouTube atau Vimeo.</div>
                    <?php echo get_form_error('item_url_embed', $form_errors_item_add); ?>
                </div>
                <div class="mb-3">
                    <label for="add_item_title" class="form-label">Judul Item (Opsional)</label>
                    <input type="text" class="form-control <?php echo isset($form_errors_item_add['item_title']) ? 'is-invalid' : ''; ?>" id="add_item_title" name="item_title" value="<?php echo old_form_data('item_title', '', $form_data_item_add); ?>">
                    <?php echo get_form_error('item_title', $form_errors_item_add); ?>
                </div>
                <div class="mb-3">
                    <label for="add_item_caption" class="form-label">Keterangan/Caption (Opsional)</label>
                    <textarea class="form-control <?php echo isset($form_errors_item_add['item_caption']) ? 'is-invalid' : ''; ?>" id="add_item_caption" name="item_caption" rows="2"><?php echo old_form_data('item_caption', '', $form_data_item_add); ?></textarea>
                    <?php echo get_form_error('item_caption', $form_errors_item_add); ?>
                </div>
                <div class="mb-3">
                    <label for="add_item_order" class="form-label">Urutan Item</label>
                    <input type="number" class="form-control <?php echo isset($form_errors_item_add['item_order']) ? 'is-invalid' : ''; ?>" id="add_item_order" name="item_order" value="<?php echo old_form_data('item_order', '0', $form_data_item_add); ?>" min="0">
                    <div class="form-text">Angka lebih kecil akan tampil lebih dulu.</div>
                    <?php echo get_form_error('item_order', $form_errors_item_add); ?>
                </div>
                <button type="submit" class="btn btn-primary">Tambah Item</button>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header"><i class="fas fa-list me-1"></i> Item dalam Album Ini</div>
        <div class="card-body">
            <?php if (count($gallery_items) > 0): ?>
            <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 g-4">
                <?php foreach ($gallery_items as $item): ?>
                <div class="col">
                    <div class="card h-100 shadow-sm">
                        <?php if ($item['item_type'] === 'image' && !empty($item['item_url'])): ?>
                            <img src="<?php echo resolve_url(esc_html($item['item_url'])); ?>" class="card-img-top" alt="<?php echo esc_html($item['title'] ?? 'Gallery Item'); ?>" style="height: 180px; object-fit: cover;">
                        <?php elseif ($item['item_type'] === 'video_embed' && !empty($item['item_url'])): ?>
                            <div class="ratio ratio-16x9">
                                <?php
                                $allowed_video_hosts = ['youtube.com', 'youtube-nocookie.com', 'vimeo.com'];
                                $parsed_url = parse_url($item['item_url']);
                                $is_allowed_video = false;
                                if (isset($parsed_url['host'])) {
                                    foreach ($allowed_video_hosts as $allowed_host) {
                                        if (strpos($parsed_url['host'], $allowed_host) !== false) {
                                            $is_allowed_video = true;
                                            break;
                                        }
                                    }
                                }
                                if ($is_allowed_video):
                                ?>
                                <iframe src="<?php echo esc_html($item['item_url']); ?>" title="<?php echo esc_html($item['title'] ?? 'Video Embed'); ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                <?php else: ?>
                                    <div class="p-3 text-center text-danger d-flex align-items-center justify-content-center" style="height: 180px; background-color:#f8d7da;">URL Video tidak diizinkan atau tidak valid.</div>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="p-3 text-center text-muted d-flex align-items-center justify-content-center" style="height: 180px; background-color:#e9ecef;">Tidak ada preview</div>
                        <?php endif; ?>
                        <div class="card-body">
                            <h6 class="card-title mb-1"><?php echo esc_html($item['title'] ?? 'Tanpa Judul'); ?></h6>
                            <?php if (!empty($item['caption'])): ?>
                                <p class="card-text small text-muted mb-1"><?php echo nl2br(esc_html($item['caption'])); ?></p>
                            <?php endif; ?>
                            <p class="card-text small">Urutan: <?php echo esc_html($item['item_order']); ?></p>
                        </div>
                        <div class="card-footer bg-light d-flex justify-content-between">
                            <button type="button" class="btn btn-sm btn-outline-warning edit-item-btn"
                                    data-bs-toggle="modal" data-bs-target="#editItemModal"
                                    data-item-id="<?php echo $item['id']; ?>"
                                    data-item-type="<?php echo esc_html($item['item_type']); ?>"
                                    data-item-url="<?php echo esc_html($item['item_url']); ?>"
                                    data-item-title="<?php echo esc_html($item['title'] ?? ''); ?>"
                                    data-item-caption="<?php echo esc_html($item['caption'] ?? ''); ?>"
                                    data-item-order="<?php echo esc_html($item['item_order']); ?>">
                                <i class="fas fa-edit"></i> Edit
                            </button>
                            <a href="process_gallery_item.php?action=delete_item&id=<?php echo $item['id']; ?>&album_id=<?php echo $album_id; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                               class="btn btn-sm btn-outline-danger"
                               onclick="return confirm('Anda yakin ingin menghapus item ini?');">
                               <i class="fas fa-trash"></i> Hapus
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php else: ?>
            <p class="text-center text-muted">Belum ada item di album ini. Silakan tambahkan item baru menggunakan formulir di atas.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="modal fade" id="editItemModal" tabindex="-1" aria-labelledby="editItemModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editItemModalLabel">Edit Item Galeri</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="process_gallery_item.php" method="POST" enctype="multipart/form-data" id="editItemForm">
        <div class="modal-body">
            <input type="hidden" name="action" value="edit_item">
            <input type="hidden" name="album_id" value="<?php echo $album_id; ?>">
            <input type="hidden" name="item_id" id="edit_item_id">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <input type="hidden" name="old_item_url" id="edit_old_item_url">

            <div class="mb-3">
                <label for="edit_item_type" class="form-label">Tipe Item <span class="text-danger">*</span></label>
                <select class="form-select" id="edit_item_type" name="item_type" required>
                    <option value="image">Gambar</option>
                    <option value="video_embed">Embed Video</option>
                </select>
            </div>

            <div class="mb-3" id="edit_item_file_container">
                <label for="edit_item_file" class="form-label">Upload File Gambar Baru (Opsional)</label>
                <input type="file" class="form-control" id="edit_item_file" name="item_file" accept="image/jpeg, image/png, image/gif, image/webp">
                <div class="form-text">Upload untuk mengganti gambar yang ada. Biarkan kosong jika tidak ingin mengubah.</div>
                <div class="mt-2" id="edit_current_image_preview_container" style="display:none;">
                    <p class="mb-1 small">Gambar saat ini:</p>
                    <img id="edit_current_image_preview" src="#" alt="Current Image" style="max-height: 100px; border: 1px solid #ddd; border-radius: 0.25rem;">
                </div>
            </div>

            <div class="mb-3" id="edit_item_url_embed_container" style="display:none;">
                <label for="edit_item_url_embed" class="form-label">URL Embed Video</label>
                <input type="url" class="form-control" id="edit_item_url_embed" name="item_url_embed" placeholder="Contoh: https://www.youtube.com/embed/VIDEO_ID/embed/VIDEO_ID">
            </div>

            <div class="mb-3">
                <label for="edit_item_title" class="form-label">Judul Item (Opsional)</label>
                <input type="text" class="form-control" id="edit_item_title" name="item_title">
            </div>
            <div class="mb-3">
                <label for="edit_item_caption" class="form-label">Keterangan/Caption (Opsional)</label>
                <textarea class="form-control" id="edit_item_caption" name="item_caption" rows="2"></textarea>
            </div>
            <div class="mb-3">
                <label for="edit_item_order" class="form-label">Urutan Item</label>
                <input type="number" class="form-control" id="edit_item_order" name="item_order" value="0" min="0">
            </div>
            <div id="editItemFormErrors" class="text-danger small"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary">Simpan Perubahan Item</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php
$page_scripts[] = "<script>
document.addEventListener('DOMContentLoaded', function () {
    // --- Logic for Add Item Form ---
    const addItemTypeSelect = document.getElementById('add_item_type');
    const addItemFileContainer = document.getElementById('add_item_file_container');
    const addItemUrlEmbedContainer = document.getElementById('add_item_url_embed_container');
    const addItemFileInput = document.getElementById('add_item_file');
    const addItemUrlEmbedInput = document.getElementById('add_item_url_embed');

    function toggleAddItemFields() {
        if (!addItemTypeSelect) return;
        if (addItemTypeSelect.value === 'image') {
            if(addItemFileContainer) addItemFileContainer.style.display = 'block';
            if(addItemUrlEmbedContainer) addItemUrlEmbedContainer.style.display = 'none';
            if(addItemFileInput) addItemFileInput.required = true;
            if(addItemUrlEmbedInput) addItemUrlEmbedInput.required = false;
        } else { // video_embed
            if(addItemFileContainer) addItemFileContainer.style.display = 'none';
            if(addItemUrlEmbedContainer) addItemUrlEmbedContainer.style.display = 'block';
            if(addItemFileInput) addItemFileInput.required = false;
            if(addItemUrlEmbedInput) addItemUrlEmbedInput.required = true;
        }
    }
    if (addItemTypeSelect) {
        addItemTypeSelect.addEventListener('change', toggleAddItemFields);
        toggleAddItemFields(); // Initial call
    }

    // --- Logic for Edit Item Modal ---
    const editItemModal = document.getElementById('editItemModal');
    const editItemTypeSelect = document.getElementById('edit_item_type');
    const editItemFileContainer = document.getElementById('edit_item_file_container');
    const editItemUrlEmbedContainer = document.getElementById('edit_item_url_embed_container');
    const editItemFileInput = document.getElementById('edit_item_file');
    const editItemUrlEmbedInput = document.getElementById('edit_item_url_embed');
    const editCurrentImagePreview = document.getElementById('edit_current_image_preview');
    const editCurrentImagePreviewContainer = document.getElementById('edit_current_image_preview_container');

    function toggleEditItemFields() {
        if (!editItemTypeSelect) return;
        const isImage = editItemTypeSelect.value === 'image';
        if(editItemFileContainer) editItemFileContainer.style.display = isImage ? 'block' : 'none';
        if(editItemUrlEmbedContainer) editItemUrlEmbedContainer.style.display = isImage ? 'none' : 'block';
        // Required attribute is tricky with hidden fields, rely on server-side validation primarily
        // if(editItemFileInput) editItemFileInput.required = isImage; 
        // if(editItemUrlEmbedInput) editItemUrlEmbedInput.required = !isImage;

        if (isImage && editCurrentImagePreview && editCurrentImagePreview.src && editCurrentImagePreview.src !== '#' && editCurrentImagePreview.src !== window.location.href ) {
           if(editCurrentImagePreviewContainer) editCurrentImagePreviewContainer.style.display = 'block';
        } else {
           if(editCurrentImagePreviewContainer) editCurrentImagePreviewContainer.style.display = 'none';
        }
    }

    if (editItemTypeSelect) {
        editItemTypeSelect.addEventListener('change', toggleEditItemFields);
    }

    if (editItemModal) {
        editItemModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            document.getElementById('edit_item_id').value = button.getAttribute('data-item-id');
            document.getElementById('edit_old_item_url').value = button.getAttribute('data-item-url');
            document.getElementById('edit_item_title').value = button.getAttribute('data-item-title');
            document.getElementById('edit_item_caption').value = button.getAttribute('data-item-caption');
            document.getElementById('edit_item_order').value = button.getAttribute('data-item-order');
            
            const itemType = button.getAttribute('data-item-type');
            editItemTypeSelect.value = itemType;

            const itemUrl = button.getAttribute('data-item-url');
            if (itemType === 'image') {
                if (itemUrl && itemUrl !== 'null' && itemUrl.trim() !== '') {
                    editCurrentImagePreview.src = '" . resolve_url('') . "' + itemUrl; // Use resolve_url base
                    if(editCurrentImagePreviewContainer) editCurrentImagePreviewContainer.style.display = 'block';
                } else {
                    if(editCurrentImagePreviewContainer) editCurrentImagePreviewContainer.style.display = 'none';
                    editCurrentImagePreview.src = '#';
                }
                editItemUrlEmbedInput.value = '';
            } else { // video_embed
                editItemUrlEmbedInput.value = itemUrl;
                if(editCurrentImagePreviewContainer) editCurrentImagePreviewContainer.style.display = 'none';
                 editCurrentImagePreview.src = '#';
            }
            toggleEditItemFields(); // Call to set initial visibility
            document.getElementById('editItemFormErrors').innerHTML = ''; // Clear previous errors
        });
    }
    
    // Clear file input when modal is hidden (optional, good UX)
    // editItemModal.addEventListener('hidden.bs.modal', function () {
    //    if(editItemFileInput) editItemFileInput.value = ''; 
    // });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>
