<?php
// admin/modules/gallery_albums/create.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Album Galeri Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'title' => '', 'slug' => '', 'description' => '',
    'album_date' => date('Y-m-d'), 'is_published' => 1
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Album Galeri', 'url' => 'index.php'],
        'Tambah Album Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Formulir Album Galeri Baru</div>
        <div class="card-body">
            <form action="process_album.php" method="POST" enctype="multipart/form-data" id="galleryAlbumForm">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="title" class="form-label">Judul Album <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', '', $form_data); ?>" required>
                    <?php echo get_form_error('title', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="slug" class="form-label">Slug (URL Friendly)</label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', '', $form_data); ?>" placeholder="Otomatis jika kosong">
                    <div class="form-text">Hanya huruf kecil, angka, dan tanda hubung (-).</div>
                    <?php echo get_form_error('slug', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="description" class="form-label">Deskripsi Album (Opsional)</label>
                    <textarea class="form-control" id="description" name="description" rows="3"><?php echo old_form_data('description', '', $form_data); ?></textarea>
                    <?php echo get_form_error('description', $form_errors); ?>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="cover_image_file" class="form-label">Gambar Sampul (Opsional)</label>
                        <img id="coverImagePreview" src="#" alt="Preview Gambar Sampul" class="img-thumbnail mb-2" style="max-height: 150px; display: none;">
                        <input type="file" class="form-control form-control-sm" id="cover_image_file" name="cover_image_file" accept="image/jpeg, image/png, image/gif, image/webp">
                        <div class="form-text">Rekomendasi: 800x600px. Maks 1MB.</div>
                        <?php echo get_form_error('cover_image_file', $form_errors); // Key disamakan dengan nama input file ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="album_date" class="form-label">Tanggal Album (Opsional)</label>
                        <input type="date" class="form-control" id="album_date" name="album_date" value="<?php echo old_form_data('album_date', date('Y-m-d'), $form_data); ?>">
                        <?php echo get_form_error('album_date', $form_errors); ?>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="is_published" class="form-label">Status Publikasi <span class="text-danger">*</span></label>
                    <select class="form-select" id="is_published" name="is_published" required>
                        <option value="1" <?php echo (old_form_data('is_published', '1', $form_data) == '1') ? 'selected' : ''; ?>>Publikasikan</option>
                        <option value="0" <?php echo (old_form_data('is_published', '1', $form_data) == '0') ? 'selected' : ''; ?>>Simpan sebagai Draft</option>
                    </select>
                    <?php echo get_form_error('is_published', $form_errors); ?>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveAlbumButton"><i class="fas fa-save me-1"></i> Simpan Album & Kelola Item</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
$page_scripts = [];
$page_scripts[] = "<script>
$(document).ready(function() {
    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('title', 'slug');
    }
    if (typeof initializeImagePreview === 'function') {
        initializeImagePreview('cover_image_file', 'coverImagePreview');
    }

    $('#galleryAlbumForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveAlbumButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        
        const formData = new FormData(this);

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) { // process_album.php akan redirect ke manage_items.php
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        form[0].reset();
                        $('#slug').val('');
                        $('#coverImagePreview').hide().attr('src', '#');
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan album.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>