<?php
// admin/modules/faculties/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Fakultas";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$faculties = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT f.id, f.name, f.slug, f.dean_name, f.website_url, f.faculty_order, COUNT(sp.id) as study_program_count
                             FROM portal_faculties f
                             LEFT JOIN portal_study_programs sp ON f.id = sp.faculty_id AND sp.is_active = 1
                             GROUP BY f.id, f.name, f.slug, f.dean_name, f.website_url, f.faculty_order
                             ORDER BY f.faculty_order ASC, f.name ASC");
        $faculties = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data fakultas: ' . $e->getMessage());
        error_log("Error fetching faculties: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Fakultas'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Fakultas Baru</a>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-university me-1"></i>
            Daftar Fakultas
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableFaculties" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Fakultas</th>
                            <th>Slug</th>
                            <th>Nama Dekan</th>
                            <th>Website</th>
                            <th>Urutan</th>
                            <th>Jml. Prodi Aktif</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($faculties) > 0): ?>
                            <?php foreach ($faculties as $index => $faculty): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo esc_html($faculty['name']); ?></td>
                                <td><?php echo esc_html($faculty['slug']); ?></td>
                                <td><?php echo esc_html($faculty['dean_name'] ?? 'N/A'); ?></td>
                                <td>
                                    <?php if (!empty($faculty['website_url'])): ?>
                                        <a href="<?php echo esc_html($faculty['website_url']); ?>" target="_blank" rel="noopener noreferrer">
                                            <?php echo esc_html(substr($faculty['website_url'], 0, 30)) . (strlen($faculty['website_url']) > 30 ? '...' : ''); ?>
                                        </a>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                                <td class="text-center"><?php echo esc_html($faculty['faculty_order']); ?></td>
                                <td class="text-center"><?php echo esc_html($faculty['study_program_count']); ?></td>
                                <td class="text-center">
                                    <a href="edit.php?id=<?php echo $faculty['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-faculty"
                                            data-id="<?php echo $faculty['id']; ?>"
                                            data-name="<?php echo esc_html(addslashes($faculty['name'])); ?>"
                                            data-sp-count="<?php echo $faculty['study_program_count']; ?>"
                                            data-url="process_faculty.php?action=delete&id=<?php echo $faculty['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">Belum ada fakultas.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <p class="text-muted small mt-2">Untuk mengubah urutan, edit masing-masing fakultas dan set nilai "Urutan Fakultas".</p>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableFaculties').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ },
            \"order\": [[ 5, \"asc\" ], [ 1, \"asc\" ]] // Order by Urutan ASC, then Nama Fakultas ASC
        });

        // AJAX Delete untuk Fakultas
        $('#dataTableFaculties').on('click', '.btn-delete-faculty', function() {
            const button = $(this);
            const facultyName = button.data('name');
            const spCount = button.data('sp-count');
            const deleteUrl = button.data('url');

            let confirmMsg = 'Anda yakin ingin menghapus fakultas: ' + facultyName + '?';
            if (spCount > 0) {
                confirmMsg += '\\nPERHATIAN: Fakultas ini memiliki ' + spCount + ' program studi terkait. Menghapus fakultas akan mengatur ulang afiliasi fakultas untuk program studi tersebut (faculty_id akan menjadi NULL).';
            }

            if (confirm(confirmMsg)) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus fakultas.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus fakultas.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>