<?php
// admin/modules/faculties/create.php
if (session_status() == PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') { header('Location: ../../login.php'); exit; }

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Tambah Fakultas Baru";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$form_data = $_SESSION['form_data'] ?? [
    'name' => '', 'slug' => '', 'description_html' => '', 'dean_name' => '',
    'website_url' => '', 'faculty_order' => 0
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([ /* ... */ ]); ?>
    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <div class="card shadow-sm">
        <div class="card-header"><i class="fas fa-plus-circle me-1"></i> Formulir Fakultas Baru</div>
        <div class="card-body">
            <form action="process_faculty.php" method="POST" id="facultyForm">
                <input type="hidden" name="action" value="create">
                <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

                <div class="mb-3">
                    <label for="name" class="form-label">Nama Fakultas <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="name" name="name" value="<?php echo old_form_data('name', '', $form_data); ?>" required>
                    <?php echo get_form_error('name', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="slug" class="form-label">Slug (URL Friendly)</label>
                    <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', '', $form_data); ?>" placeholder="Otomatis jika kosong">
                    <?php echo get_form_error('slug', $form_errors); ?>
                </div>
                <div class="mb-3">
                    <label for="description_html" class="form-label">Deskripsi Fakultas (Opsional)</label>
                    <textarea class="form-control" id="description_html" name="description_html" rows="5"><?php echo old_form_data('description_html', '', $form_data); ?></textarea>
                    <?php echo get_form_error('description_html', $form_errors); ?>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="dean_name" class="form-label">Nama Dekan (Opsional)</label>
                        <input type="text" class="form-control" id="dean_name" name="dean_name" value="<?php echo old_form_data('dean_name', '', $form_data); ?>">
                        <?php echo get_form_error('dean_name', $form_errors); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="website_url" class="form-label">URL Website Fakultas (Opsional)</label>
                        <input type="url" class="form-control" id="website_url" name="website_url" value="<?php echo old_form_data('website_url', '', $form_data); ?>" placeholder="https://fakultas.ugkmb.ac.id">
                        <?php echo get_form_error('website_url', $form_errors); ?>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="faculty_order" class="form-label">Urutan Fakultas <span class="text-danger">*</span></label>
                    <input type="number" class="form-control" id="faculty_order" name="faculty_order" value="<?php echo old_form_data('faculty_order', '0', $form_data); ?>" min="0" required>
                    <div class="form-text">Angka lebih kecil akan tampil lebih dulu.</div>
                    <?php echo get_form_error('faculty_order', $form_errors); ?>
                </div>
                <div class="mt-4">
                    <button type="submit" class="btn btn-primary" id="saveFacultyButton"><i class="fas fa-save me-1"></i> Simpan Fakultas</button>
                    <a href="index.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php
$page_scripts = [];
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js";
$page_scripts[] = "<script>
$(document).ready(function() {
    tinymce.init({ selector: 'textarea#description_html', /* ... konfig TinyMCE ... */ });
    if (typeof initializeSlugGenerator === 'function') { initializeSlugGenerator('name', 'slug'); }

    $('#facultyForm').on('submit', function(e) { /* ... AJAX submit logic ... */
        e.preventDefault();
        const form = $(this); const submitButton = $('#saveFacultyButton'); const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        if (typeof tinymce !== 'undefined' && tinymce.get('description_html')) { tinymce.get('description_html').save(); }
        const formData = new FormData(this); // FormData untuk jika ada file upload di masa depan
        form.find('.is-invalid').removeClass('is-invalid'); form.find('.invalid-feedback.custom-error').remove(); form.find('.invalid-feedback').html('');
        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: formData,
            processData: false, contentType: false, dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) { setTimeout(function() { window.location.href = response.redirect_url; }, 1500); }
                    else { form[0].reset(); if (tinymce.get('description_html')) tinymce.get('description_html').setContent(''); $('#slug').val('');}
                } else { /* ... handle error ... */ }
            },
            error: function(jqXHR) { /* ... handle error ... */ },
            complete: function() { submitButton.prop('disabled', false).html(originalButtonText); }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>