<?php
// admin/modules/contact_messages/view.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Fungsi helper sederhana untuk escape JS, idealnya ada di functions.php
if (!function_exists('esc_js')) {
    function esc_js($string) {
        return json_encode($string ?? '');
    }
}

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Detail Pesan Kontak";

$message_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($message_id <= 0) {
    set_flash_message('danger', 'ID Pesan tidak valid.');
    header('Location: index.php');
    exit;
}

$message_data = null;
if (isset($pdo)) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM portal_contact_messages WHERE id = :id");
        $stmt->bindParam(':id', $message_id, PDO::PARAM_INT);
        $stmt->execute();
        $message_data = $stmt->fetch();

        if ($message_data && !$message_data['is_read']) {
            $stmt_mark_read = $pdo->prepare("UPDATE portal_contact_messages SET is_read = 1, read_at = NOW() WHERE id = :id");
            $stmt_mark_read->bindParam(':id', $message_id, PDO::PARAM_INT);
            $stmt_mark_read->execute();
            $message_data['is_read'] = 1;
            $message_data['read_at'] = date('Y-m-d H:i:s'); 
        }

    } catch (\PDOException $e) {
        error_log("Error fetching contact message detail: " . $e->getMessage());
        set_flash_message('danger', 'Gagal mengambil detail pesan: ' . $e->getMessage());
        header('Location: index.php');
        exit;
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
    header('Location: index.php');
    exit;
}

if (!$message_data) {
    set_flash_message('danger', 'Pesan dengan ID yang diminta tidak ditemukan atau telah dihapus.');
}

if (!$message_data) {
    $page_title = "Pesan Tidak Ditemukan";
}

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';
?>

<div class="container-fluid px-4">
    <?php 
    if ($message_data) {
        echo generate_breadcrumbs([
            ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
            ['label' => 'Manajemen Pesan Kontak', 'url' => 'index.php' . ($message_data['is_archived'] ? '?archived=1' : '')],
            'Detail Pesan' 
        ]);
    } else {
        echo generate_breadcrumbs([
            ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
            ['label' => 'Manajemen Pesan Kontak', 'url' => 'index.php'],
            'Pesan Tidak Ditemukan'
        ]);
    }
    ?>

    <h1 class="mt-4 mb-1"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php if ($message_data): ?>
        <p class="text-muted mb-4">Subjek: <strong><?php echo esc_html($message_data['subject']); ?></strong></p>
    <?php endif; ?>

    <?php echo display_flash_message(); ?>

    <?php if ($message_data): ?>
    <div class="card shadow-sm mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span><i class="fas fa-envelope-open-text me-1"></i> Detail Pesan</span>
            <a href="index.php<?php echo $message_data['is_archived'] ? '?archived=1' : ''; ?>" class="btn btn-sm btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i> Kembali ke Daftar
            </a>
        </div>
        <div class="card-body">
            <dl class="row gy-2">
                <dt class="col-sm-3 col-lg-2">Nama Pengirim:</dt>
                <dd class="col-sm-9 col-lg-10"><?php echo esc_html($message_data['sender_name']); ?></dd>

                <dt class="col-sm-3 col-lg-2">Email Pengirim:</dt>
                <dd class="col-sm-9 col-lg-10"><a href="mailto:<?php echo esc_html($message_data['sender_email']); ?>"><?php echo esc_html($message_data['sender_email']); ?></a></dd>

                <?php if (!empty($message_data['sender_phone'])): ?>
                <dt class="col-sm-3 col-lg-2">Telepon Pengirim:</dt>
                <dd class="col-sm-9 col-lg-10"><?php echo esc_html($message_data['sender_phone']); ?></dd>
                <?php endif; ?>

                <dt class="col-sm-3 col-lg-2">Tanggal Diterima:</dt>
                <dd class="col-sm-9 col-lg-10"><?php echo date('d F Y, H:i:s', strtotime($message_data['created_at'])); ?></dd>
                
                <dt class="col-sm-3 col-lg-2">Status:</dt>
                <dd class="col-sm-9 col-lg-10">
                    <span id="messageStatusRead" class="badge <?php echo $message_data['is_read'] ? 'bg-secondary' : 'bg-primary'; ?>">
                        <?php echo $message_data['is_read'] ? 'Sudah Dibaca' : 'Baru'; ?>
                    </span>
                    <?php if ($message_data['is_read'] && !empty($message_data['read_at'])): ?>
                        <small class="text-muted ms-1">(pada <?php echo date('d M Y H:i', strtotime($message_data['read_at'])); ?>)</small>
                    <?php endif; ?>
                    <?php if ($message_data['is_archived']): ?>
                        <span id="messageStatusArchived" class="badge bg-warning text-dark ms-1">Diarsipkan</span>
                         <?php if (!empty($message_data['archived_at'])): ?>
                            <small class="text-muted ms-1">(pada <?php echo date('d M Y H:i', strtotime($message_data['archived_at'])); ?>)</small>
                        <?php endif; ?>
                    <?php endif; ?>
                </dd>

                <dt class="col-sm-3 col-lg-2">Alamat IP:</dt>
                <dd class="col-sm-9 col-lg-10"><?php echo esc_html($message_data['ip_address'] ?? 'N/A'); ?></dd>
                
                <dt class="col-sm-3 col-lg-2">User Agent:</dt>
                <dd class="col-sm-9 col-lg-10"><small class="text-muted"><?php echo esc_html($message_data['user_agent'] ?? 'N/A'); ?></small></dd>
            </dl>
            <hr>
            <h5>Isi Pesan:</h5>
            <div class="p-3 bg-light border rounded pre-scrollable" style="white-space: pre-wrap; max-height: 400px;"><?php echo nl2br(esc_html($message_data['message_content'])); ?></div>
            
            <?php if(!empty($message_data['notes'])): ?>
            <hr>
            <h5>Catatan Internal:</h5>
            <div class="p-3 bg-white border rounded pre-scrollable" style="white-space: pre-wrap; max-height: 200px;" id="internalNotesDisplay">
                <?php echo nl2br(esc_html($message_data['notes'])); ?>
            </div>
            <?php endif; ?>

            <div class="mt-4 pt-3 border-top">
                <h5>Tindakan Lanjut:</h5>
                 <?php 
                $sender_phone_cleaned = '';
                if (!empty($message_data['sender_phone'])) {
                    $phone = preg_replace('/[^0-9+]/', '', $message_data['sender_phone']);
                    if (strpos($phone, '0') === 0) {
                        $phone = '62' . substr($phone, 1); // Ganti '62' dengan kode negara Anda
                    }
                    $phone = ltrim($phone, '+');
                    if (strlen($phone) >= 9 && strlen($phone) <= 15) { // Validasi panjang sederhana
                        $sender_phone_cleaned = $phone;
                    }
                }
                ?>
                <?php if (!empty($sender_phone_cleaned)): ?>
                    <?php
                    $whatsapp_message = "Halo " . esc_html($message_data['sender_name']) . ",\n\n";
                    $whatsapp_message .= "Menanggapi pesan Anda dengan subjek: \"" . esc_html($message_data['subject']) . "\"\n\n";
                    $whatsapp_message .= "[Ketik balasan Anda di sini]\n\n";
                    $whatsapp_message .= "---\n";
                    $whatsapp_message .= "Pesan Asli Anda:\n";
                    $whatsapp_message .= esc_html($message_data['message_content']); // Pesan WA tidak perlu nl2br
                    
                    $whatsapp_url = "https://wa.me/" . $sender_phone_cleaned . "?text=" . rawurlencode($whatsapp_message);
                    ?>
                    <a href="<?php echo $whatsapp_url; ?>" class="btn btn-outline-success me-2" target="_blank" title="Balas via WhatsApp ke <?php echo esc_html($message_data['sender_phone']); ?>">
                        <i class="fab fa-whatsapp me-1"></i> Balas via WhatsApp
                    </a>
                <?php else: ?>
                    <button type="button" class="btn btn-outline-success me-2" disabled title="Nomor telepon pengirim tidak tersedia atau tidak valid untuk WhatsApp">
                        <i class="fab fa-whatsapp me-1"></i> Balas via WhatsApp
                    </button>
                <?php endif; ?>

                <button type="button" class="btn btn-outline-info" data-bs-toggle="modal" data-bs-target="#addNoteModal">
                    <i class="fas fa-sticky-note me-1"></i> Tambah Catatan Internal
                </button>
            </div>
        </div>
        <div class="card-footer text-muted d-flex flex-wrap justify-content-end gap-2">
            <?php if ($message_data['is_read']): ?>
                 <a href="process_message.php?action=mark_unread&id=<?php echo $message_data['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>" class="btn btn-sm btn-outline-secondary btn-action-message" data-action="mark_unread" data-subject="<?php echo esc_html(addslashes($message_data['subject'])); ?>"><i class="fas fa-envelope me-1"></i> Tandai Belum Dibaca</a>
            <?php else: ?>
                 <a href="process_message.php?action=mark_read&id=<?php echo $message_data['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>" class="btn btn-sm btn-outline-success btn-action-message" data-action="mark_read" data-subject="<?php echo esc_html(addslashes($message_data['subject'])); ?>"><i class="fas fa-check-circle me-1"></i> Tandai Sudah Dibaca</a>
            <?php endif; ?>

            <?php if (!$message_data['is_archived']): ?>
            <a href="process_message.php?action=archive&id=<?php echo $message_data['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>" class="btn btn-sm btn-outline-warning btn-action-message" data-action="archive" data-subject="<?php echo esc_html(addslashes($message_data['subject'])); ?>"><i class="fas fa-archive me-1"></i> Arsipkan</a>
            <?php else: ?>
             <a href="process_message.php?action=unarchive&id=<?php echo $message_data['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>&archived_view=1" class="btn btn-sm btn-outline-success btn-action-message" data-action="unarchive" data-subject="<?php echo esc_html(addslashes($message_data['subject'])); ?>"><i class="fas fa-box-open me-1"></i> Batal Arsip</a>
            <?php endif; ?>
             <a href="process_message.php?action=delete&id=<?php echo $message_data['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>&archived_view=<?php echo $message_data['is_archived'] ? '1' : '0'; ?>" class="btn btn-sm btn-danger btn-action-message" data-action="delete" data-subject="<?php echo esc_html(addslashes($message_data['subject'])); ?>"><i class="fas fa-trash me-1"></i> Hapus</a>
        </div>
    </div>
    <?php else: ?>
        <div class="alert alert-danger text-center mt-4">
            <h4>Pesan Tidak Ditemukan</h4>
            <p>Pesan yang Anda coba akses tidak ada atau mungkin telah dihapus.</p>
            <a href="index.php" class="btn btn-primary mt-2">Kembali ke Daftar Pesan</a>
        </div>
    <?php endif; ?>
</div>

<!-- Modal Tambah Catatan -->
<?php if ($message_data): ?>
<div class="modal fade" id="addNoteModal" tabindex="-1" aria-labelledby="addNoteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addNoteModalLabel">Tambah Catatan Internal</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form id="addNoteForm" action="process_message.php" method="POST">
        <div class="modal-body">
            <input type="hidden" name="action" value="add_note">
            <input type="hidden" name="message_id" value="<?php echo $message_data['id']; ?>">
            <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">
            <div class="mb-3">
                <label for="note_content_modal" class="form-label">Isi Catatan <span class="text-danger">*</span></label> <!-- Ganti ID agar unik jika ada #note_content lain -->
                <textarea class="form-control" id="note_content_modal" name="note_content" rows="4" required></textarea>
                <div class="invalid-feedback" id="error_note_content_modal"></div>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary" id="saveNoteButton"><i class="fas fa-save me-1"></i> Simpan Catatan</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php endif; ?>

<?php
$page_scripts = []; 
$page_scripts[] = "<script>
$(document).ready(function() {
    function storeOriginalButtonHtml(button) {
        if (!button.data('original-html')) {
            button.data('original-html', button.html());
        }
    }
    function restoreOriginalButtonHtml(button) {
        if (button.data('original-html')) {
            button.html(button.data('original-html'));
        }
    }

    $('.btn-action-message').on('click', function(e) {
        e.preventDefault();
        const button = $(this);
        storeOriginalButtonHtml(button); 
        const action = button.data('action');
        const actionUrl = button.attr('href');
        let confirmMsg = 'Apakah Anda yakin?';

        if (action === 'archive') { confirmMsg = 'Anda yakin ingin mengarsipkan pesan ini?'; }
        else if (action === 'unarchive') { confirmMsg = 'Anda yakin ingin membatalkan pengarsipan pesan ini?'; }
        else if (action === 'delete') { confirmMsg = 'Anda yakin ingin menghapus permanen pesan ini?'; }
        
        if (action !== 'mark_read' && action !== 'mark_unread' && !confirm(confirmMsg)) {
            return; 
        }
        
        button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Mohon tunggu...');
        
        $.ajax({
            url: actionUrl, method: 'GET', dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message || 'Aksi berhasil.');
                    const newCsrfToken = response.new_csrf_token || button.attr('href').split('csrf_token=')[1];
                    
                    if (action === 'delete') {
                        window.location.href = 'index.php" . ($message_data['is_archived'] ? "?archived=1" : "") . "';
                    } else if (action === 'archive') {
                        window.location.href = 'index.php';
                    } else if (action === 'unarchive') {
                        window.location.href = 'index.php?archived=1';
                    } else if (action === 'mark_read' || action === 'mark_unread') {
                        $('#messageStatusRead').removeClass('bg-primary bg-secondary')
                            .addClass(action === 'mark_read' ? 'bg-secondary' : 'bg-primary')
                            .text(action === 'mark_read' ? 'Sudah Dibaca' : 'Baru');
                        
                        let newAction, newButtonText, newButtonClass, oldButtonClass;
                        if(action === 'mark_read') {
                            newAction = 'mark_unread';
                            newButtonText = '<i class=\"fas fa-envelope me-1\"></i> Tandai Belum Dibaca';
                            newButtonClass = 'btn-outline-secondary'; oldButtonClass = 'btn-outline-success';
                        } else { 
                            newAction = 'mark_read';
                            newButtonText = '<i class=\"fas fa-check-circle me-1\"></i> Tandai Sudah Dibaca';
                            newButtonClass = 'btn-outline-success'; oldButtonClass = 'btn-outline-secondary';
                        }
                        button.attr('href', `process_message.php?action=\${newAction}&id=" . $message_id . "&csrf_token=\${newCsrfToken}`)
                              .data('action', newAction)
                              .removeClass(oldButtonClass).addClass(newButtonClass)
                              .html(newButtonText);
                        button.data('original-html', button.html()); 
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Aksi gagal.');
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                else if (jqXHR.responseText) { try { const err = JSON.parse(jqXHR.responseText); if(err.message) errorMsg = err.message; } catch(e){} }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                button.prop('disabled', false);
                if (action !== 'mark_read' && action !== 'mark_unread') { // Hanya restore jika bukan tombol toggle status baca
                    restoreOriginalButtonHtml(button);
                }
            }
        });
    });

    $('#addNoteForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveNoteButton');
        storeOriginalButtonHtml(submitButton);
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');
        form.find('.is-invalid').removeClass('is-invalid');
        $('#error_note_content_modal').html('').hide();

        $.ajax({
            url: form.attr('action'), method: form.attr('method'), data: form.serialize(), dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message || 'Catatan berhasil disimpan.');
                    $('#addNoteModal').modal('hide');
                    form[0].reset();
                    setTimeout(function(){ window.location.reload(); }, 1200);
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menambah catatan.');
                    if (response.errors && response.errors.note_content) {
                        $('#note_content_modal').addClass('is-invalid');
                        $('#error_note_content_modal').html(response.errors.note_content).show();
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menambah catatan.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false); 
                restoreOriginalButtonHtml(submitButton);
            }
        });
    });
});
</script>";
require_once $project_root . '/admin/includes/footer.php';
?>