<?php
// admin/modules/categories/index.php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id'])) { // Semua role yang login bisa lihat, tapi hanya admin yang bisa CRUD via process_category.php
    header('Location: ../../login.php');
    exit;
}

$project_root = dirname(__DIR__, 3);
require_once $project_root . '/includes/db_connect.php';
require_once $project_root . '/admin/includes/functions.php';

$module_base_path = '../../';
$page_title = "Manajemen Kategori Artikel";

require_once $project_root . '/admin/includes/header.php';
require_once $project_root . '/admin/includes/sidebar.php';

$categories = [];
if (isset($pdo)) {
    try {
        $stmt = $pdo->query("SELECT c.id, c.name, c.slug, c.description, p.name as parent_name, COUNT(a.id) as article_count
                             FROM portal_categories c
                             LEFT JOIN portal_categories p ON c.parent_id = p.id
                             LEFT JOIN portal_articles a ON a.category_id = c.id
                             GROUP BY c.id, c.name, c.slug, c.description, p.name
                             ORDER BY c.name ASC");
        $categories = $stmt->fetchAll();
    } catch (\PDOException $e) {
        set_flash_message('danger', 'Gagal mengambil data kategori: ' . $e->getMessage());
        error_log("Error fetching categories: " . $e->getMessage());
    }
} else {
    set_flash_message('danger', 'Koneksi database tidak tersedia.');
}
?>

<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        'Manajemen Kategori'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>

    <?php echo display_flash_message(); ?>

    <div class="mb-3">
        <?php if ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'editor'): // Editor bisa tambah kategori ?>
        <a href="create.php" class="btn btn-primary"><i class="fas fa-plus me-1"></i> Tambah Kategori Baru</a>
        <?php endif; ?>
    </div>

    <div class="card mb-4 shadow-sm">
        <div class="card-header">
            <i class="fas fa-folder-open me-1"></i>
            Daftar Kategori
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover table-striped" id="dataTableCategories" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Kategori</th>
                            <th>Slug</th>
                            <th>Parent Kategori</th>
                            <th>Deskripsi</th>
                            <th>Jumlah Artikel</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($categories) > 0): ?>
                            <?php foreach ($categories as $index => $category): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td><?php echo esc_html($category['name']); ?></td>
                                <td><?php echo esc_html($category['slug']); ?></td>
                                <td><?php echo esc_html($category['parent_name'] ?? '<em>Tidak Ada</em>'); ?></td>
                                <td><?php echo esc_html(substr($category['description'] ?? '', 0, 70)) . (strlen($category['description'] ?? '') > 70 ? '...' : ''); ?></td>
                                <td class="text-center"><?php echo esc_html($category['article_count']); ?></td>
                                <td class="text-center">
                                    <?php if ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'editor'): ?>
                                    <a href="edit.php?id=<?php echo $category['id']; ?>" class="btn btn-sm btn-warning mb-1" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                        <?php if ($_SESSION['role'] === 'admin'): // Hanya admin yang bisa delete kategori ?>
                                            <button type="button" class="btn btn-sm btn-danger mb-1 btn-delete-category"
                                                    data-id="<?php echo $category['id']; ?>"
                                                    data-name="<?php echo esc_html(addslashes($category['name'])); ?>"
                                                    data-article-count="<?php echo $category['article_count']; ?>"
                                                    data-url="process_category.php?action=delete&id=<?php echo $category['id']; ?>&csrf_token=<?php echo generate_csrf_token(); ?>"
                                                    title="Hapus">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        <?php endif; ?>
                                    <?php else: echo '-'; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">Belum ada kategori.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php
$page_scripts[] = "<script>
    $(document).ready(function() {
        $('#dataTableCategories').DataTable({
            responsive: true,
            language: { /* ... bahasa Indonesia ... */ }
        });

        // AJAX Delete untuk Kategori
        $('#dataTableCategories').on('click', '.btn-delete-category', function() {
            const button = $(this);
            const categoryId = button.data('id');
            const categoryName = button.data('name');
            const articleCount = button.data('article-count');
            const deleteUrl = button.data('url');

            let confirmMsg = 'Anda yakin ingin menghapus kategori: ' + categoryName + '?';
            if (articleCount > 0) {
                confirmMsg += '\\nPERHATIAN: Kategori ini memiliki ' + articleCount + ' artikel terkait. Menghapus kategori akan membuat artikel tersebut tidak memiliki kategori (atau sesuai aturan ON DELETE di DB).';
            }
            // Tambahan cek sub-kategori jika diperlukan (perlu query tambahan atau data-* attribute dari PHP)

            if (confirm(confirmMsg)) {
                button.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span>');
                $.ajax({
                    url: deleteUrl,
                    method: 'GET', // Sesuai process_category.php
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            showAdminNotification('success', response.message);
                            button.closest('table').DataTable().row(button.closest('tr')).remove().draw(false);
                        } else {
                            showAdminNotification('danger', response.message || 'Gagal menghapus kategori.');
                            button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                        }
                    },
                    error: function() {
                        showAdminNotification('danger', 'Kesalahan server saat menghapus kategori.');
                        button.prop('disabled', false).html('<i class=\"fas fa-trash\"></i>');
                    }
                });
            }
        });
    });
</script>";

require_once $project_root . '/admin/includes/footer.php';
?>