<?php
// admin/modules/articles/create.php
if (session_status() == PHP_SESSION_NONE) {
    // Session management will be handled by header.php or config.php
}

if (!defined('PROJECT_ROOT')) {
    define('PROJECT_ROOT', dirname(__DIR__, 3));
}
require_once PROJECT_ROOT . '/includes/db_connect.php';
require_once PROJECT_ROOT . '/admin/includes/functions.php';

$page_title = "Tambah Artikel Baru";
$module_base_path = '../../';

if (!isset($_SESSION['user_id']) || !in_array($_SESSION['role'], ['admin', 'editor'])) {
    set_flash_message('danger', 'Anda tidak memiliki izin untuk mengakses halaman ini.');
    header('Location: ' . $module_base_path . 'login.php');
    exit;
}

require_once PROJECT_ROOT . '/admin/includes/header.php';
require_once PROJECT_ROOT . '/admin/includes/sidebar.php';

$categories = [];
if (isset($pdo)) {
    try {
        $stmt_cat = $pdo->query("SELECT id, name FROM portal_categories ORDER BY name ASC");
        $categories = $stmt_cat->fetchAll();
    } catch (\PDOException $e) { set_flash_message('danger', 'Gagal mengambil daftar kategori: ' . $e->getMessage()); }
}

$tags_available = [];
if (isset($pdo)) {
    try {
        $stmt_tags_all = $pdo->query("SELECT id, name FROM portal_tags ORDER BY name ASC");
        $tags_available = $stmt_tags_all->fetchAll();
    } catch (\PDOException $e) { set_flash_message('danger', 'Gagal mengambil daftar tag: ' . $e->getMessage()); }
}

$form_data = $_SESSION['form_data'] ?? [
    'title' => '', 'slug' => '', 'category_id' => '', 'content_html' => '',
    'excerpt' => '', 'status' => 'draft', 'published_at' => date('Y-m-d\TH:i'),
    'meta_keywords' => '', 'meta_description' => '', 'allow_comments' => 1, 'tags' => []
];
$form_errors = $_SESSION['form_errors'] ?? [];
clear_form_session_data();
?>
<div class="container-fluid px-4">
    <?php echo generate_breadcrumbs([
        ['label' => 'Dashboard', 'url' => $module_base_path . 'index.php'],
        ['label' => 'Manajemen Artikel', 'url' => 'index.php'],
        'Tambah Artikel Baru'
    ]); ?>

    <h1 class="mt-4 mb-4"><?php echo htmlspecialchars($page_title); ?></h1>
    <?php echo display_flash_message(); ?>

    <form action="process_article.php" method="POST" enctype="multipart/form-data" id="articleForm">
        <input type="hidden" name="action" value="create">
        <input type="hidden" name="csrf_token" value="<?php echo generate_csrf_token(); ?>">

        <div class="row">
            <div class="col-lg-9">
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-file-alt me-1"></i> Informasi Artikel</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="title" class="form-label">Judul Artikel <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="title" name="title" value="<?php echo old_form_data('title', '', $form_data); ?>" required>
                            <?php echo get_form_error('title', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="slug" class="form-label">Slug (URL Friendly)</label>
                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo old_form_data('slug', '', $form_data); ?>" placeholder="Otomatis jika kosong">
                            <div class="form-text">Hanya huruf kecil, angka, dan tanda hubung (-). Biarkan kosong untuk otomatis.</div>
                            <?php echo get_form_error('slug', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="content_html" class="form-label">Konten Artikel <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="content_html" name="content_html" rows="18"><?php echo old_form_data('content_html', '', $form_data); ?></textarea>
                            <?php echo get_form_error('content_html', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="excerpt" class="form-label">Kutipan Singkat (Excerpt)</label>
                            <textarea class="form-control" id="excerpt" name="excerpt" rows="4"><?php echo old_form_data('excerpt', '', $form_data); ?></textarea>
                            <div class="form-text">Ringkasan singkat artikel. Akan digunakan untuk meta description jika kolom meta description di bawah ini kosong.</div>
                            <?php echo get_form_error('excerpt', $form_errors); ?>
                        </div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-search-dollar me-1"></i> Pengaturan SEO (Opsional)</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="meta_keywords" class="form-label">Meta Keywords</label>
                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo old_form_data('meta_keywords', '', $form_data); ?>" placeholder="keyword1, keyword2, keyword3">
                            <div class="form-text">Pisahkan dengan koma.</div>
                            <?php echo get_form_error('meta_keywords', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="meta_description" class="form-label">Meta Description</label>
                            <textarea class="form-control" id="meta_description" name="meta_description" rows="3" maxlength="160"><?php echo old_form_data('meta_description', '', $form_data); ?></textarea>
                            <div class="form-text">Deskripsi singkat untuk mesin pencari (optimal 150-160 karakter).</div>
                            <?php echo get_form_error('meta_description', $form_errors); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3">
                <div class="card mb-4 shadow-sm sticky-lg-top" style="top: 70px;">
                    <div class="card-header"><i class="fas fa-cogs me-1"></i> Publikasi</div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select" id="status" name="status" required>
                                <option value="draft" <?php echo (old_form_data('status', 'draft', $form_data) == 'draft') ? 'selected' : ''; ?>>Draft</option>
                                <option value="published" <?php echo (old_form_data('status', 'draft', $form_data) == 'published') ? 'selected' : ''; ?>>Published</option>
                                <option value="pending" <?php echo (old_form_data('status', 'draft', $form_data) == 'pending') ? 'selected' : ''; ?>>Pending Review</option>
                            </select>
                            <?php echo get_form_error('status', $form_errors); ?>
                        </div>
                        <div class="mb-3">
                            <label for="published_at" class="form-label">Tanggal Publikasi</label>
                            <input type="datetime-local" class="form-control" id="published_at" name="published_at" value="<?php echo old_form_data('published_at', date('Y-m-d\TH:i'), $form_data); ?>">
                            <div class="form-text">Kosongkan untuk publikasi segera saat status 'Published'.</div>
                            <?php echo get_form_error('published_at', $form_errors); ?>
                        </div>
                         <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" value="1" id="allow_comments" name="allow_comments" <?php echo (old_form_data('allow_comments', '1', $form_data) == 1) ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="allow_comments">Izinkan Komentar</label>
                        </div>
                        <button type="submit" class="btn btn-primary w-100" id="saveArticleButton"><i class="fas fa-save me-1"></i> Simpan Artikel</button>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-folder-open me-1"></i> Kategori <span class="text-danger">*</span></div>
                    <div class="card-body">
                        <select class="form-select" id="category_id" name="category_id" required>
                            <option value="">-- Pilih Kategori --</option>
                            <?php foreach ($categories as $category): ?>
                            <option value="<?php echo $category['id']; ?>" <?php echo (old_form_data('category_id', '', $form_data) == $category['id']) ? 'selected' : ''; ?>>
                                <?php echo esc_html($category['name']); ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                        <?php echo get_form_error('category_id', $form_errors); ?>
                        <div class="mt-2"><a href="<?php echo $module_base_path; ?>modules/categories/create.php" target="_blank" class="small text-decoration-none"><i class="fas fa-plus-circle fa-xs"></i> Tambah Kategori Baru</a></div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-tags me-1"></i> Tags (Opsional)</div>
                    <div class="card-body" style="max-height: 250px; overflow-y: auto;">
                        <?php if(!empty($tags_available)): ?>
                        <?php foreach ($tags_available as $tag): ?>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="tags[]" value="<?php echo $tag['id']; ?>" id="tag_<?php echo $tag['id']; ?>"
                                    <?php echo in_array($tag['id'], (array)old_form_data('tags', [], $form_data)) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="tag_<?php echo $tag['id']; ?>"><?php echo esc_html($tag['name']); ?></label>
                            </div>
                        <?php endforeach; ?>
                        <?php else: ?> <p class="small text-muted">Belum ada tag tersedia.</p> <?php endif; ?>
                        <?php echo get_form_error('tags', $form_errors); ?>
                        <div class="mt-2"><a href="<?php echo $module_base_path; ?>modules/tags/create.php" target="_blank" class="small text-decoration-none"><i class="fas fa-plus-circle fa-xs"></i> Tambah Tag Baru</a></div>
                    </div>
                </div>
                <div class="card mb-4 shadow-sm">
                    <div class="card-header"><i class="fas fa-image me-1"></i> Gambar Unggulan (Opsional)</div>
                    <div class="card-body text-center">
                        <img id="featuredImagePreview" src="#" alt="Preview Gambar Unggulan" class="img-thumbnail mb-2" style="max-height: 150px; display: none;">
                        <input type="file" class="form-control form-control-sm" id="featured_image_file" name="featured_image_file" accept="image/jpeg, image/png, image/gif, image/webp">
                        <div class="form-text">Rekomendasi: min. 800x450px. Maks 2MB.</div>
                        <?php echo get_form_error('featured_image_file', $form_errors); ?>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<?php
$page_scripts = []; // Reset atau inisialisasi
$page_scripts[] = "https://cdn.tiny.cloud/1/qlw978ky0kcpi9tdpmnoih6myrw4usd6crxwdzms7b9jm9ic/tinymce/6/tinymce.min.js"; // Ganti API Key
$page_scripts[] = "<script>
$(document).ready(function() {
    tinymce.init({
      selector: 'textarea#content_html',
      plugins: 'lists link image table code help wordcount autoresize preview fullscreen media visualblocks charmap anchor pagebreak searchreplace visualchars',
      toolbar1: 'undo redo | styles | bold italic underline strikethrough | alignleft aligncenter alignright alignjustify | fontfamily fontsize blocks',
      toolbar2: 'bullist numlist outdent indent | link image media | table charmap | forecolor backcolor removeformat | pagebreak | anchor | searchreplace visualblocks code fullscreen preview | help',
      height: 550,
      menubar: 'file edit view insert format tools table help',
      // Pastikan path ini benar jika menggunakan image uploader TinyMCE
      // images_upload_url: '" . resolve_url("admin/modules/articles/process_image_upload.php") . "', 
      // automatic_uploads: true,
      // file_picker_types: 'image media',
      // file_picker_callback: function(cb, value, meta) { /* ... implementasi file picker ... */ }
    });

    if (typeof initializeSlugGenerator === 'function') {
        initializeSlugGenerator('title', 'slug');
    }
    if (typeof initializeImagePreview === 'function') {
        initializeImagePreview('featured_image_file', 'featuredImagePreview');
    }

    $('#articleForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const submitButton = $('#saveArticleButton');
        const originalButtonText = submitButton.html();
        submitButton.prop('disabled', true).html('<span class=\"spinner-border spinner-border-sm\"></span> Menyimpan...');

        if (typeof tinymce !== 'undefined' && tinymce.get('content_html')) {
            tinymce.get('content_html').save(); // Update textarea sebelum serialisasi
        }

        const formData = new FormData(this);

        form.find('.is-invalid').removeClass('is-invalid');
        form.find('.invalid-feedback.custom-error').remove();
        form.find('.invalid-feedback').html('');

        $.ajax({
            url: form.attr('action'),
            method: form.attr('method'),
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAdminNotification('success', response.message);
                    if (response.redirect_url) {
                        setTimeout(function() { window.location.href = response.redirect_url; }, 1500);
                    } else {
                        form[0].reset(); // Reset form
                        if (tinymce.get('content_html')) tinymce.get('content_html').setContent('');
                        $('#slug').val('');
                        $('#featuredImagePreview').hide().attr('src', '#');
                        // Mungkin perlu reset kategori dan tags jika ingin form benar-benar kosong
                    }
                } else {
                    showAdminNotification('danger', response.message || 'Gagal menyimpan. Periksa error di form.');
                    if (response.errors && typeof displayAdminFormErrors === 'function') {
                        displayAdminFormErrors(form, response.errors);
                    }
                }
            },
            error: function(jqXHR) {
                let errorMsg = 'Kesalahan server saat menyimpan artikel.';
                if (jqXHR.responseJSON && jqXHR.responseJSON.message) { errorMsg = jqXHR.responseJSON.message; }
                showAdminNotification('danger', errorMsg);
            },
            complete: function() {
                submitButton.prop('disabled', false).html(originalButtonText);
            }
        });
    });
});
</script>";
require_once PROJECT_ROOT . '/admin/includes/footer.php';
?>