<?php
// /oldugk/admin/includes/header_new.php
// Pastikan variabel $page_title sudah didefinisikan sebelum memanggil header ini
global $page_title, $module_base_path; // $module_base_path dibutuhkan jika ada link di header
if (!isset($page_title)) {
    $page_title = "Admin Panel";
}
if (!isset($module_base_path)) {
    $module_base_path = '../../'; // Default base path jika tidak diset
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo esc_html($page_title); ?> - Admin UGKMB</title>
    
    <!-- Bootstrap CSS (Anda menggunakan Bootstrap 5 dari CDN via data-bs-toggle) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome (Anda menggunakan Font Awesome 5) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    
    <!-- Custom Admin CSS (jika ada) -->
    <link rel="stylesheet" href="<?php echo esc_html(rtrim($module_base_path, '/')); ?>/assets/css/admin_styles_new.css"> 
    
    <style>
        /* Tambahan style minimal jika admin_styles_new.css tidak ada */
        body { display: flex; min-height: 100vh; flex-direction: column; }
        .main-content { flex: 1; padding-top: 1rem; /* Sesuaikan dengan tinggi navbar */ }
        .sidebar { min-height: 100vh; /* Atau sesuaikan agar sticky */ }
        /* Anda menggunakan .pre-scrollable, itu dari Bootstrap */
    </style>
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark sticky-top">
    <div class="container-fluid">
        <a class="navbar-brand" href="<?php echo esc_html(rtrim($module_base_path, '/')); ?>/index.php">Admin UGKMB</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#adminNavbar" aria-controls="adminNavbar" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="adminNavbar">
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link" href="#"><i class="fas fa-user me-1"></i> <?php echo esc_html($_SESSION['username'] ?? 'User'); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo esc_html(rtrim($module_base_path, '/')); ?>/logout.php"><i class="fas fa-sign-out-alt me-1"></i> Logout</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="container-fluid">
    <div class="row">
        <?php // Sidebar akan di-include setelah ini ?>