<?php
// ugkmb_cms/includes/db_connect.php

// config.php should have already been loaded and defined DB constants & PROJECT_ROOT.
// If this file is included directly without config.php first, it's an error.
if (!defined('DB_HOST')) {
    error_log("FATAL ERROR: DB_HOST not defined. config.php must be included before db_connect.php.");
    // Display a user-friendly error if not an AJAX request or CLI
    if (php_sapi_name() !== 'cli' && (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest')) {
        http_response_code(503);
        echo "<!DOCTYPE html><html lang='id'><head><title>Kesalahan Konfigurasi Database</title>";
        echo "<style>body{font-family: Arial, sans-serif; margin: 50px; text-align: center; background-color: #f0f0f0;} .container{background-color: #fff; padding: 20px; border-radius: 5px; box-shadow: 0 0 10px rgba(0,0,0,0.1);}</style>";
        echo "</head><body><div class='container'>";
        echo "<h1>Kesalahan Konfigurasi Database</h1>";
        echo "<p>Harap hubungi administrator. (Error Code: DB01)</p>";
        echo "</div></body></html>";
    }
    exit;
}

global $pdo;
if (!isset($pdo) || $pdo === null) {
    $pdo = null;

    $pdo_options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $pdo_options);
    } catch (\PDOException $e) {
        error_log("Database Connection Error: " . $e->getMessage() . " (DSN: " . $dsn . ")");
        // Display a user-friendly error if not an AJAX request or CLI
        if (php_sapi_name() !== 'cli' && (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest')) {
            http_response_code(503); // Service Unavailable
            echo "<!DOCTYPE html><html lang='id'><head><title>Kesalahan Koneksi Database</title>";
            echo "<style>body{font-family: Arial, sans-serif; margin: 50px; text-align: center; background-color: #f0f0f0;} .container{background-color: #fff; padding: 20px; border-radius: 5px; box-shadow: 0 0 10px rgba(0,0,0,0.1);}</style>";
            echo "</head><body><div class='container'>";
            echo "<h1>Terjadi Masalah Koneksi</h1>";
            echo "<p>Mohon maaf, kami tidak dapat terhubung ke database saat ini. Silakan coba lagi beberapa saat.</p>";
            echo "</div></body></html>";
        }
        exit;
    }
}
?>